/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.ui.xul.binding;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.ui.xul.XulComponent;
import org.pentaho.ui.xul.XulEventSource;
import org.pentaho.ui.xul.XulException;
import org.pentaho.ui.xul.binding.Binding;
import org.pentaho.ui.xul.binding.BindingContext;
import org.pentaho.ui.xul.binding.BindingConvertor;
import org.pentaho.ui.xul.binding.BindingException;
import org.pentaho.ui.xul.binding.BindingExceptionHandler;
import org.pentaho.ui.xul.binding.BindingUtil;
import org.pentaho.ui.xul.dom.Document;

public class DefaultBinding
implements Binding {
    protected Reference source;
    protected Reference target;
    protected String sourceAttr;
    protected String targetAttr;
    protected boolean negateBooleanAssignment = false;
    protected boolean reverseConversion = false;
    protected BindingConvertor conversion;
    protected PropertyChangeListener forwardListener;
    protected PropertyChangeListener reverseListener;
    protected Stack<Method> getterMethods = new Stack();
    protected Method sourceGetterMethod;
    protected Method targetGetterMethod;
    protected BindingContext context;
    protected static final Log logger = LogFactory.getLog(DefaultBinding.class);
    protected boolean destroyed = false;
    protected Binding.Type bindingStrategy = Binding.Type.BI_DIRECTIONAL;
    private BindingExceptionHandler exceptionHandler;

    public DefaultBinding() {
    }

    @Deprecated
    public DefaultBinding(Document document, String sourceId, String sourceAttr, String targetId, String targetAttr) {
        this.source = new WeakReference<XulComponent>(document.getElementById(sourceId));
        this.setSourceAttr(sourceAttr);
        this.target = new WeakReference<XulComponent>(document.getElementById(targetId));
        this.setTargetAttr(targetAttr);
    }

    @Deprecated
    public DefaultBinding(Document document, Object source, String sourceAttr, String targetId, String targetAttr) {
        this.source = new WeakReference<Object>(source);
        this.setSourceAttr(sourceAttr);
        this.target = new WeakReference<XulComponent>(document.getElementById(targetId));
        this.setTargetAttr(targetAttr);
    }

    @Deprecated
    public DefaultBinding(Document document, String sourceId, String sourceAttr, Object target, String targetAttr) {
        this.source = new WeakReference<XulComponent>(document.getElementById(sourceId));
        this.setSourceAttr(sourceAttr);
        this.target = new WeakReference<Object>(target);
        this.setTargetAttr(targetAttr);
    }

    public DefaultBinding(Object source, String sourceAttr, Object target, String targetAttr) {
        this.source = new WeakReference<Object>(source);
        this.setSourceAttr(sourceAttr);
        this.target = new WeakReference<Object>(target);
        this.setTargetAttr(targetAttr);
    }

    @Override
    public void setBindingType(Binding.Type t) {
        this.bindingStrategy = t;
    }

    @Override
    public Binding.Type getBindingType() {
        return this.bindingStrategy;
    }

    @Override
    public void initialize() {
        this.bindForward();
        if (this.getBindingType() == Binding.Type.BI_DIRECTIONAL) {
            this.bindReverse();
        }
    }

    @Override
    public Reference getSource() {
        return this.source;
    }

    @Override
    public void setSource(Object source) {
        this.source = new WeakReference<Object>(source);
    }

    @Override
    public Reference getTarget() {
        return this.target;
    }

    @Override
    public void setTarget(Object target) {
        this.target = new WeakReference<Object>(target);
    }

    @Override
    public String getSourceAttr() {
        return this.sourceAttr;
    }

    @Override
    public void setSourceAttr(String sourceAttr) {
        if (sourceAttr.charAt(0) == '!') {
            this.negateBooleanAssignment = !this.negateBooleanAssignment;
            sourceAttr = sourceAttr.substring(1);
        }
        this.sourceAttr = sourceAttr;
    }

    @Override
    public String getTargetAttr() {
        return this.targetAttr;
    }

    @Override
    public void setTargetAttr(String targetAttr) {
        if (targetAttr.charAt(0) == '!') {
            this.negateBooleanAssignment = !this.negateBooleanAssignment;
            targetAttr = targetAttr.substring(1);
        }
        this.targetAttr = targetAttr;
    }

    @Override
    public Object evaluateExpressions(Object val) {
        if (this.negateBooleanAssignment && val instanceof Boolean) {
            return (Boolean)val == false;
        }
        return val;
    }

    @Override
    public Object doConversions(Object val, BindingConvertor.Direction dir) {
        if (this.conversion != null) {
            return dir == BindingConvertor.Direction.FORWARD ? this.conversion.sourceToTarget(val) : this.conversion.targetToSource(val);
        }
        return val;
    }

    @Override
    public BindingConvertor getConversion() {
        return this.conversion;
    }

    @Override
    public void setConversion(BindingConvertor conversion) {
        this.conversion = conversion;
    }

    @Override
    public boolean isReverseConversion() {
        return this.reverseConversion;
    }

    @Override
    public void setReverseConversion(boolean reverseConversion) {
        this.reverseConversion = reverseConversion;
    }

    @Override
    public void fireSourceChanged() throws IllegalArgumentException, XulException, InvocationTargetException {
        try {
            Object getRetVal = this.sourceGetterMethod.invoke(this.getSource().get(), new Object[0]);
            this.forwardListener.propertyChange(new PropertyChangeEvent(this.getSource(), this.getSourceAttr(), null, getRetVal));
        }
        catch (IllegalAccessException e) {
            this.handleException(new BindingException(e));
        }
    }

    @Override
    public void bindForward() {
        this.setForwardListener(this.setupBinding(this.getSource(), this.getSourceAttr(), this.getTarget(), this.getTargetAttr(), BindingConvertor.Direction.FORWARD));
        this.sourceGetterMethod = this.getterMethods.pop();
        logger.debug((Object)("Forward binding established: " + this.source.get() + "." + this.sourceAttr + " ==> " + this.target.get() + "." + this.targetAttr));
    }

    @Override
    public void bindReverse() {
        this.setReverseListener(this.setupBinding(this.getTarget(), this.getTargetAttr(), this.getSource(), this.getSourceAttr(), BindingConvertor.Direction.BACK));
        this.targetGetterMethod = this.getterMethods.pop();
        logger.debug((Object)("Reverse binding established: " + this.source.get() + "." + this.sourceAttr + " <== " + this.target.get() + "." + this.targetAttr));
    }

    protected PropertyChangeListener setupBinding(Reference a, final String va, final Reference b, String vb, final BindingConvertor.Direction dir) {
        if (a.get() == null || va == null) {
            this.handleException(new BindingException("source bean or property is null"));
        }
        if (!(a.get() instanceof XulEventSource)) {
            this.handleException(new BindingException("Binding error, source object " + a.get() + " not a XulEventSource instance"));
        }
        if (b.get() == null || vb == null) {
            this.handleException(new BindingException("target bean or property is null"));
        }
        Method sourceGetMethod = BindingUtil.findGetMethod(a.get(), va);
        Class getterClazz = BindingUtil.getMethodReturnType(sourceGetMethod, a.get());
        this.getterMethods.push(sourceGetMethod);
        final Method targetSetMethod = BindingUtil.findSetMethod(b.get(), vb, getterClazz);
        PropertyChangeListener listener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                1 cThis = this;
                if (evt.getPropertyName().equalsIgnoreCase(va)) {
                    try {
                        Object targetObject = b.get();
                        if (targetObject == null) {
                            logger.debug((Object)"Binding target was Garbage Collected, removing propListener");
                            DefaultBinding.this.destroyBindings();
                            return;
                        }
                        Object value = DefaultBinding.this.doConversions(evt.getNewValue(), dir);
                        Object finalVal = DefaultBinding.this.evaluateExpressions(value);
                        logger.debug((Object)("Setting val: " + finalVal + " on: " + targetObject));
                        targetSetMethod.invoke(targetObject, finalVal);
                    }
                    catch (Exception e) {
                        logger.debug((Object)e);
                        DefaultBinding.this.handleException(new BindingException("Error invoking setter method [" + targetSetMethod.getName() + "] on target: " + DefaultBinding.this.target.get(), e));
                    }
                }
            }
        };
        ((XulEventSource)a.get()).addPropertyChangeListener(listener);
        return listener;
    }

    protected void handleException(BindingException exception) {
        if (this.exceptionHandler == null) {
            throw exception;
        }
        this.exceptionHandler.handleException(exception);
    }

    @Override
    public void destroyBindings() {
        if (this.destroyed) {
            return;
        }
        Object sourceObj = this.getSource().get();
        Object targetObj = this.getTarget().get();
        if (this.forwardListener != null && sourceObj != null && sourceObj instanceof XulEventSource) {
            ((XulEventSource)sourceObj).removePropertyChangeListener(this.forwardListener);
            logger.debug((Object)("Removing forward binding on " + sourceObj));
        }
        if (this.reverseListener != null && targetObj != null && targetObj instanceof XulEventSource) {
            ((XulEventSource)targetObj).removePropertyChangeListener(this.reverseListener);
            logger.debug((Object)("Removing reverse binding on " + targetObj));
        }
        this.setDestroyed(true);
        if (this.context != null) {
            this.context.remove(this);
        }
    }

    protected void setDestroyed(boolean flag) {
        this.destroyed = flag;
    }

    @Override
    public PropertyChangeListener getForwardListener() {
        return this.forwardListener;
    }

    @Override
    public void setForwardListener(PropertyChangeListener forwardListener) {
        this.forwardListener = forwardListener;
    }

    @Override
    public PropertyChangeListener getReverseListener() {
        return this.reverseListener;
    }

    @Override
    public void setReverseListener(PropertyChangeListener reverseListener) {
        this.reverseListener = reverseListener;
    }

    @Override
    public List<PropertyChangeListener> getListeneners() {
        ArrayList<PropertyChangeListener> l = new ArrayList<PropertyChangeListener>();
        if (this.forwardListener != null) {
            l.add(this.forwardListener);
        }
        if (this.reverseListener != null) {
            l.add(this.reverseListener);
        }
        return l;
    }

    @Override
    public BindingContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(BindingContext context) {
        this.context = context;
    }

    @Override
    public void setExceptionHandler(BindingExceptionHandler handler) {
        this.exceptionHandler = handler;
    }
}

