/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.llp;

import ca.uhn.hl7v2.llp.HL7Reader;
import ca.uhn.hl7v2.llp.LLPException;
import ca.uhn.hl7v2.llp.LowerLayerProtocol;
import ca.uhn.hl7v2.llp.MinLLPWriter;
import ca.uhn.log.HapiLog;
import ca.uhn.log.HapiLogFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.net.SocketException;

public class MinLLPReader
implements HL7Reader {
    public static final String CHARSET_KEY = "ca.uhn.hl7v2.llp.charset";
    private static final HapiLog log = HapiLogFactory.getHapiLog(MinLLPReader.class);
    private BufferedReader myReader;
    private static final char END_MESSAGE = '\u001c';
    private static final char START_MESSAGE = '\u000b';
    private static final char LAST_CHARACTER = '\r';

    public MinLLPReader() {
    }

    public MinLLPReader(InputStream in) throws IOException {
        this.setInputStream(in);
    }

    public synchronized void setInputStream(InputStream in) throws IOException {
        String charset = System.getProperty(CHARSET_KEY, "US-ASCII");
        this.myReader = charset.equals("default") ? new BufferedReader(new InputStreamReader(in)) : new BufferedReader(new InputStreamReader(in, charset));
    }

    /*
     * Unable to fully structure code
     */
    public synchronized String getMessage() throws LLPException, IOException {
        s_buffer = new StringBuffer();
        end_of_message = false;
        c = 0;
        try {
            c = this.myReader.read();
        }
        catch (SocketException e) {
            MinLLPReader.log.info("SocketException on read() attempt.  Socket appears to have been closed: " + e.getMessage());
            return null;
        }
        if (c == -1) {
            MinLLPReader.log.info("End of input stream reached.");
            return null;
        }
        LowerLayerProtocol.logCharacterReceived(c);
        if (c == 11) ** GOTO lbl30
        throw new LLPException("Message violates the minimal lower layer protocol: no start of message indicator received.");
lbl-1000:
        // 1 sources

        {
            c = this.myReader.read();
            if (c == -1) {
                throw new LLPException("Message violates the minimal lower protocol: message terminated without a terminating character.");
            }
            LowerLayerProtocol.logCharacterReceived(c);
            if (c == 28) {
                c = this.myReader.read();
                if (c >= 0) {
                    LowerLayerProtocol.logCharacterReceived(c);
                }
                if (c != 13) {
                    throw new LLPException("Message violates the minimal lower layer protocol: message terminator not followed by a return character.");
                }
                end_of_message = true;
                continue;
            }
            s_buffer.append((char)c);
lbl30:
            // 3 sources

            ** while (!end_of_message)
        }
lbl31:
        // 1 sources

        return s_buffer.toString();
    }

    public static void main(String[] args) {
        try {
            Socket s = new Socket("142.224.51.2", 7);
            MinLLPReader in = new MinLLPReader(s.getInputStream());
            MinLLPWriter out = new MinLLPWriter(s.getOutputStream());
            out.writeMessage("Some message.");
            System.out.println("wrote");
            String str = in.getMessage();
            System.out.println("read");
            System.out.println(str);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public synchronized void close() throws IOException {
        this.myReader.close();
    }

    private static OutputStreamWriter getWriter(OutputStream theStream) throws IOException {
        String charset = System.getProperty(CHARSET_KEY, "US-ASCII");
        if (charset.equals("default")) {
            return new OutputStreamWriter(theStream);
        }
        return new OutputStreamWriter(theStream, charset);
    }
}

