/*
 * Decompiled with CFR 0.152.
 */
package com.totvscrm.pentaho.step.jobsocket;

import com.totvscrm.pentaho.step.jobsocket.JobEntrySocketDialog;
import java.net.ServerSocket;
import java.util.List;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.annotations.JobEntry;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

@JobEntry(id="SocketJobEntry", name="SocketJobEntry.Name", description="SocketJobEntry.TooltipDesc", image="socket.png", categoryDescription="Socket.CategoryName", i18nPackageName="com.totvscrm.pentaho.step.jobsocket", documentationUrl="https://wsintegracoes.webnode.com/opensocket/", casesUrl="https://wsintegracoes.webnode.com/opensocket/", forumUrl="https://wsintegracoes.webnode.com/opensocket/")
public class JobEntrySocket
extends JobEntryBase
implements Cloneable,
JobEntryInterface {
    private static Class<?> PKG = JobEntrySocket.class;
    private static ServerSocket serversocket = null;
    private String porta = "0";

    public JobEntrySocket(String name) {
        super(name, "");
    }

    public JobEntrySocket() {
        this("");
    }

    public String getDialogClassName() {
        return JobEntrySocketDialog.class.getName();
    }

    public Object clone() {
        JobEntrySocket je = (JobEntrySocket)super.clone();
        return je;
    }

    public String getXML() {
        StringBuilder retval = new StringBuilder();
        retval.append(super.getXML());
        retval.append("      ").append(XMLHandler.addTagValue((String)"porta", (String)this.porta));
        return retval.toString();
    }

    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep, IMetaStore metaStore) throws KettleXMLException {
        try {
            this.loadXML(entrynode, databases, slaveServers);
            this.setPorta(XMLHandler.getNodeValue((Node)XMLHandler.getSubNode((Node)entrynode, (String)"porta")));
        }
        catch (Exception e) {
            throw new KettleXMLException("Plug-in Socket foi incapaz de ler informados steps do XML", (Throwable)e);
        }
    }

    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_job) throws KettleException {
        try {
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "porta", this.porta);
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException("Imposssalvar step no reposit" + String.valueOf(id_job), (Throwable)dbe);
        }
    }

    public void loadRep(Repository rep, IMetaStore metaStore, ObjectId id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        try {
            this.porta = rep.getJobEntryAttributeString(id_jobentry, "porta");
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException("Imposscarregar o step do reposit+ id_jobentry", (Throwable)dbe);
        }
    }

    public Result execute(Result prev_result, int nr) {
        if (!this.environmentSubstitute(this.porta).equals("0") && this.environmentSubstitute(this.porta) != null && !this.environmentSubstitute(this.porta).equals("")) {
            try {
                serversocket = new ServerSocket(Integer.parseInt(this.environmentSubstitute(this.porta)));
            }
            catch (Exception e) {
                this.logBasic("Porta " + this.environmentSubstitute(this.porta) + " sendo usada");
                System.exit(404);
            }
        } else {
            System.out.println("Nao foi informada nenhuma porta no kettle.properties para este job");
        }
        prev_result.setNrErrors(0L);
        prev_result.setResult(true);
        return prev_result;
    }

    public boolean evaluates() {
        return true;
    }

    public boolean isUnconditional() {
        return false;
    }

    public String getPorta() {
        return this.porta;
    }

    public void setPorta(String porta) {
        this.porta = porta;
    }

    public static Class<?> getPKG() {
        return PKG;
    }

    public static void setPKG(Class<?> pKG) {
        PKG = pKG;
    }
}

