/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.repository2.unified.spring;

import java.util.concurrent.Callable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.ISecurityHelper;
import org.pentaho.platform.api.repository2.unified.IBackingRepositoryLifecycleManager;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.security.SecurityHelper;
import org.pentaho.platform.repository2.unified.jcr.JcrTenantUtils;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.Ordered;
import org.springframework.security.authentication.event.AbstractAuthenticationEvent;
import org.springframework.security.authentication.event.AuthenticationSuccessEvent;
import org.springframework.security.authentication.event.InteractiveAuthenticationSuccessEvent;

public class BackingRepositoryLifecycleManagerAuthenticationSuccessListener
implements ApplicationListener,
Ordered {
    private static final Log logger = LogFactory.getLog(BackingRepositoryLifecycleManagerAuthenticationSuccessListener.class);
    private int order = 200;
    private IBackingRepositoryLifecycleManager lifecycleManager;
    private ISecurityHelper securityHelper;

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof AuthenticationSuccessEvent || event instanceof InteractiveAuthenticationSuccessEvent) {
            logger.debug((Object)"received AbstractAuthenticationEvent");
            final IBackingRepositoryLifecycleManager lifecycleManager = this.getLifecycleManager();
            AbstractAuthenticationEvent aEvent = (AbstractAuthenticationEvent)event;
            final String principalName = aEvent.getAuthentication().getName();
            try {
                this.getSecurityHelper().runAsSystem((Callable)new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        lifecycleManager.newTenant(JcrTenantUtils.getTenant(principalName, true));
                        return null;
                    }
                });
            }
            catch (Exception e) {
                logger.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            try {
                this.getSecurityHelper().runAsSystem((Callable)new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        lifecycleManager.newUser(JcrTenantUtils.getTenant(principalName, true), JcrTenantUtils.getPrincipalName(principalName, true));
                        return null;
                    }
                });
            }
            catch (Exception e) {
                logger.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            try {
                this.getSecurityHelper().runAsSystem((Callable)new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        lifecycleManager.newTenant();
                        return null;
                    }
                });
            }
            catch (Exception e) {
                logger.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            try {
                this.getSecurityHelper().runAsUser(principalName, (Callable)new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        lifecycleManager.newUser();
                        return null;
                    }
                });
            }
            catch (Exception e) {
                logger.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            logger.info((Object)("The user \"" + principalName + "\" connected to repository"));
        }
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public IBackingRepositoryLifecycleManager getLifecycleManager() {
        return null != this.lifecycleManager ? this.lifecycleManager : (IBackingRepositoryLifecycleManager)PentahoSystem.get(IBackingRepositoryLifecycleManager.class);
    }

    public void setLifecycleManager(IBackingRepositoryLifecycleManager lifecycleManager) {
        assert (null != lifecycleManager);
        this.lifecycleManager = lifecycleManager;
    }

    public ISecurityHelper getSecurityHelper() {
        return null != this.securityHelper ? this.securityHelper : SecurityHelper.getInstance();
    }

    public void setSecurityHelper(ISecurityHelper securityHelper) {
        this.securityHelper = securityHelper;
    }
}

