/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.repository2.unified.lifecycle;

import java.io.Serializable;
import org.pentaho.platform.api.mt.ITenant;
import org.pentaho.platform.api.mt.ITenantedPrincipleNameResolver;
import org.pentaho.platform.api.repository2.unified.RepositoryFile;
import org.pentaho.platform.api.repository2.unified.RepositoryFileAcl;
import org.pentaho.platform.api.repository2.unified.RepositoryFileSid;
import org.pentaho.platform.repository.messages.Messages;
import org.pentaho.platform.repository2.unified.IRepositoryFileAclDao;
import org.pentaho.platform.repository2.unified.IRepositoryFileDao;
import org.pentaho.platform.repository2.unified.ServerRepositoryPaths;
import org.pentaho.platform.repository2.unified.jcr.IPathConversionHelper;
import org.pentaho.platform.repository2.unified.jcr.JcrTenantUtils;
import org.pentaho.platform.repository2.unified.lifecycle.AbstractBackingRepositoryLifecycleManager;
import org.springframework.extensions.jcr.JcrTemplate;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.Assert;

public class MondrianBackingRepositoryLifecycleManager
extends AbstractBackingRepositoryLifecycleManager {
    protected String repositoryAdminUsername;
    protected String tenantAuthenticatedAuthorityNamePattern;
    protected String singleTenantAuthenticatedAuthorityName;
    protected IRepositoryFileDao repositoryFileDao;
    protected IRepositoryFileAclDao repositoryFileAclDao;
    private static final String FOLDER_MONDRIAN = "mondrian";
    private ITenantedPrincipleNameResolver userNameUtils;

    public MondrianBackingRepositoryLifecycleManager(IRepositoryFileDao contentDao, IRepositoryFileAclDao repositoryFileAclDao, TransactionTemplate txnTemplate, String repositoryAdminUsername, String tenantAuthenticatedAuthorityNamePattern, ITenantedPrincipleNameResolver userNameUtils, JcrTemplate adminJcrTemplate, IPathConversionHelper pathConversionHelper) {
        super(txnTemplate, adminJcrTemplate, pathConversionHelper);
        Assert.notNull((Object)contentDao);
        Assert.notNull((Object)repositoryFileAclDao);
        Assert.hasText((String)repositoryAdminUsername);
        Assert.hasText((String)tenantAuthenticatedAuthorityNamePattern);
        this.repositoryFileDao = contentDao;
        this.repositoryFileAclDao = repositoryFileAclDao;
        this.repositoryAdminUsername = repositoryAdminUsername;
        this.tenantAuthenticatedAuthorityNamePattern = tenantAuthenticatedAuthorityNamePattern;
        this.userNameUtils = userNameUtils;
    }

    protected void createEtcMondrianFolder(final ITenant tenant) {
        this.txnTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            public void doInTransactionWithoutResult(TransactionStatus status) {
                RepositoryFileSid repositoryAdminUserSid = new RepositoryFileSid(MondrianBackingRepositoryLifecycleManager.this.userNameUtils.getPrincipleId(tenant, MondrianBackingRepositoryLifecycleManager.this.repositoryAdminUsername));
                RepositoryFile tenantEtcFolder = MondrianBackingRepositoryLifecycleManager.this.repositoryFileDao.getFileByAbsolutePath(ServerRepositoryPaths.getTenantEtcFolderPath(tenant));
                Assert.notNull((Object)tenantEtcFolder);
                if (MondrianBackingRepositoryLifecycleManager.this.repositoryFileDao.getFileByAbsolutePath(ServerRepositoryPaths.getTenantEtcFolderPath(tenant) + "/" + MondrianBackingRepositoryLifecycleManager.FOLDER_MONDRIAN) == null) {
                    MondrianBackingRepositoryLifecycleManager.this.internalCreateFolder(tenantEtcFolder.getId(), new RepositoryFile.Builder(MondrianBackingRepositoryLifecycleManager.FOLDER_MONDRIAN).folder(true).build(), true, repositoryAdminUserSid, Messages.getInstance().getString("MondrianRepositoryLifecycleManager.USER_0001_VER_COMMENT_MONDRIAN"));
                }
            }
        });
    }

    public void startup() {
        this.createEtcMondrianFolder(JcrTenantUtils.getDefaultTenant());
    }

    public void shutdown() {
    }

    public void newTenant(ITenant tenant) {
        if (!tenant.equals(JcrTenantUtils.getDefaultTenant())) {
            this.createEtcMondrianFolder(tenant);
        }
    }

    public void newTenant() {
    }

    public void newUser(ITenant tenant, String username) {
    }

    public void newUser() {
    }

    protected RepositoryFile internalCreateFolder(Serializable parentFolderId, RepositoryFile file, boolean inheritAces, RepositoryFileSid ownerSid, String versionMessage) {
        Assert.notNull((Object)file);
        return this.repositoryFileDao.createFolder(parentFolderId, file, this.makeAcl(inheritAces, ownerSid), versionMessage);
    }

    protected RepositoryFileAcl makeAcl(boolean inheritAces, RepositoryFileSid ownerSid) {
        return new RepositoryFileAcl.Builder(ownerSid).entriesInheriting(inheritAces).build();
    }
}

