/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.repository2.unified.lifecycle;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.mt.ITenant;
import org.pentaho.platform.repository2.unified.jcr.IPathConversionHelper;
import org.pentaho.platform.repository2.unified.jcr.JcrTenantUtils;
import org.pentaho.platform.repository2.unified.lifecycle.AbstractBackingRepositoryLifecycleManager;
import org.pentaho.platform.repository2.unified.lifecycle.DefaultUserRepositoryLifecycleManager;
import org.pentaho.platform.security.policy.rolebased.IRoleAuthorizationPolicyRoleBindingDao;
import org.springframework.extensions.jcr.JcrTemplate;
import org.springframework.transaction.support.TransactionTemplate;

public class ExecutePermissionRepositoryLifecycleManager
extends AbstractBackingRepositoryLifecycleManager {
    private static final Log logger = LogFactory.getLog(DefaultUserRepositoryLifecycleManager.class);
    private static final ITenant DEFAULT_TENANT = JcrTenantUtils.getDefaultTenant();
    private final IRoleAuthorizationPolicyRoleBindingDao roleBindingDao;
    private List<String> rolesNeedingExecutePermission;
    public static final String EXECUTE_PERMISSION_ADDED_METADATA = "executePermissionAdded";
    public static final String EXECUTE_PERMISSION_NAME = "org.pentaho.repository.execute";

    public ExecutePermissionRepositoryLifecycleManager(IRoleAuthorizationPolicyRoleBindingDao roleBindingDao, TransactionTemplate txnTemplate, JcrTemplate adminJcrTemplate, IPathConversionHelper pathConversionHelper) {
        super(txnTemplate, adminJcrTemplate, pathConversionHelper);
        this.roleBindingDao = roleBindingDao;
    }

    public void newTenant() {
    }

    public void newTenant(ITenant arg0) {
    }

    public void newUser() {
    }

    public void newUser(ITenant arg0, String arg1) {
    }

    public void shutdown() {
    }

    public void startup() {
        if (!this.doesMetadataExists(EXECUTE_PERMISSION_ADDED_METADATA).booleanValue()) {
            this.addExecutePermissionToRoles();
            this.addMetadataToRepository(EXECUTE_PERMISSION_ADDED_METADATA);
        }
    }

    private void addExecutePermissionToRoles() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Configuring execute permissions for specified roles.");
        }
        if (this.rolesNeedingExecutePermission != null) {
            for (String roleNeedingExecutePermission : this.rolesNeedingExecutePermission) {
                List<String> roleNeedingExecutePermissionAsList = this.roleBindingDao.getBoundLogicalRoleNames(DEFAULT_TENANT, Arrays.asList(roleNeedingExecutePermission));
                if (roleNeedingExecutePermissionAsList == null) continue;
                roleNeedingExecutePermissionAsList.add(EXECUTE_PERMISSION_NAME);
                this.roleBindingDao.setRoleBindings(DEFAULT_TENANT, roleNeedingExecutePermission, roleNeedingExecutePermissionAsList);
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("Adding Execute permission to role: " + roleNeedingExecutePermission));
            }
        }
    }

    public void setRolesNeedingExecutePermission(List<String> rolesNeedingExecutePermission) {
        this.rolesNeedingExecutePermission = rolesNeedingExecutePermission;
    }

    public List<String> getRolesNeedingExecutePermission() {
        return this.rolesNeedingExecutePermission;
    }
}

