/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.repository2.unified.lifecycle;

import java.util.List;
import org.pentaho.platform.api.mt.ITenant;
import org.pentaho.platform.api.repository2.unified.IBackingRepositoryLifecycleManager;
import org.springframework.util.Assert;

public class DelegatingBackingRepositoryLifecycleManager
implements IBackingRepositoryLifecycleManager {
    private List<IBackingRepositoryLifecycleManager> managers;

    public DelegatingBackingRepositoryLifecycleManager(List<IBackingRepositoryLifecycleManager> managers) {
        Assert.notNull(managers);
        this.managers = managers;
    }

    public void newTenant() {
        for (IBackingRepositoryLifecycleManager manager : this.managers) {
            manager.newTenant();
        }
    }

    public void newTenant(ITenant tenant) {
        for (IBackingRepositoryLifecycleManager manager : this.managers) {
            manager.newTenant(tenant);
        }
    }

    public void newUser() {
        for (IBackingRepositoryLifecycleManager manager : this.managers) {
            manager.newUser();
        }
    }

    public void newUser(ITenant tenant, String username) {
        for (IBackingRepositoryLifecycleManager manager : this.managers) {
            manager.newUser(tenant, username);
        }
    }

    public synchronized void shutdown() {
        for (IBackingRepositoryLifecycleManager manager : this.managers) {
            manager.shutdown();
        }
    }

    public synchronized void startup() {
        for (IBackingRepositoryLifecycleManager manager : this.managers) {
            manager.startup();
        }
    }

    public void addMetadataToRepository(String arg0) {
    }

    public Boolean doesMetadataExists(String arg0) {
        return null;
    }

    public void addLifeCycleManager(IBackingRepositoryLifecycleManager manager) {
        this.managers.add(manager);
    }

    public void removeLifeCycleManager(IBackingRepositoryLifecycleManager manager) {
        this.managers.remove(manager);
    }
}

