/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.repository2.unified.jcr.sejcr.ntdproviders;

import com.google.common.annotations.VisibleForTesting;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.jcr.RepositoryException;
import javax.jcr.ValueFactory;
import javax.jcr.nodetype.NodeDefinitionTemplate;
import javax.jcr.nodetype.NodeTypeDefinition;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.nodetype.NodeTypeTemplate;
import org.pentaho.platform.repository2.unified.jcr.sejcr.NodeTypeDefinitionProvider;

public class LocaleNtdProvider
implements NodeTypeDefinitionProvider {
    @VisibleForTesting
    static final String GERMAN_GREECE = "de_GR";
    @VisibleForTesting
    static final String SIMPLIFIED_CHINESE_SINGAPORE = "zh_SG_#Hans";
    static final String TRADITIONAL_CHINESE_TAIWAN = "zh_TW_#Hant";
    static final String TRADITIONAL_CHINESE_HONG_KONG = "zh_HK_#Hant";
    static final String SIMPLIFIED_CHINESE_CHINA = "zh_CN_#Hans";
    static final String NORWEGIAN_BOKMAL = "nb_NO";
    static final String NORWEGIAN = "nb";
    static final String NORWEGIAN_NYNORSK = "nn_NO";

    @Override
    public NodeTypeDefinition getNodeTypeDefinition(NodeTypeManager ntMgr, ValueFactory vFac) throws RepositoryException {
        NodeTypeTemplate t = ntMgr.createNodeTypeTemplate();
        t.setName("{http://www.pentaho.org/jcr/nt/2.0}locale");
        t.getNodeDefinitionTemplates().add(this.getLocaleNode(ntMgr, "default"));
        for (String localeName : LocaleNtdProvider.getLocaleNames()) {
            t.getNodeDefinitionTemplates().add(this.getLocaleNode(ntMgr, localeName));
        }
        return t;
    }

    @VisibleForTesting
    static List<String> getLocaleNames() {
        List<String> localeNames = Arrays.stream(Locale.getAvailableLocales()).filter(Objects::nonNull).map(Locale::toString).filter(Objects::nonNull).filter(localeName -> !localeName.isEmpty()).filter(localeName -> !GERMAN_GREECE.equals(localeName)).filter(localeName -> !SIMPLIFIED_CHINESE_SINGAPORE.equals(localeName)).filter(localeName -> !TRADITIONAL_CHINESE_TAIWAN.equals(localeName)).filter(localeName -> !TRADITIONAL_CHINESE_HONG_KONG.equals(localeName)).filter(localeName -> !SIMPLIFIED_CHINESE_CHINA.equals(localeName)).filter(localeName -> !NORWEGIAN_BOKMAL.equals(localeName)).filter(localeName -> !NORWEGIAN.equals(localeName)).filter(localeName -> !NORWEGIAN_NYNORSK.equals(localeName)).collect(Collectors.toList());
        localeNames.add(GERMAN_GREECE);
        return localeNames;
    }

    private NodeDefinitionTemplate getLocaleNode(NodeTypeManager ntMgr, String localeName) throws RepositoryException {
        NodeDefinitionTemplate t = ntMgr.createNodeDefinitionTemplate();
        t.setName(localeName);
        t.setRequiredPrimaryTypeNames(new String[]{"nt:unstructured"});
        t.setOnParentVersion(1);
        t.setSameNameSiblings(false);
        return t;
    }
}

