/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.repository2.unified.jcr;

import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.version.VersionHistory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jackrabbit.core.IPentahoSystemSessionFactory;
import org.apache.jackrabbit.core.RepositoryImpl;
import org.apache.jackrabbit.core.gc.GarbageCollector;
import org.pentaho.platform.engine.core.system.PentahoSystem;

public class RepositoryCleaner {
    private final Log logger = LogFactory.getLog(RepositoryCleaner.class);
    private static final String JCR_FROZEN_NODE = "jcr:frozenNode";
    private static final String JCR_FROZEN_UUID = "jcr:frozenUuid";
    private static final String JCR_ROOT_VERSION = "jcr:rootVersion";
    private IPentahoSystemSessionFactory systemSessionFactory = new IPentahoSystemSessionFactory.DefaultImpl();

    public void setSystemSessionFactory(IPentahoSystemSessionFactory systemSessionFactory) {
        this.systemSessionFactory = systemSessionFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void gc() {
        Repository jcrRepository = (Repository)PentahoSystem.get(Repository.class, (String)"jcrRepository", null);
        if (jcrRepository == null) {
            this.logger.error((Object)"Cannot obtain JCR repository. Exiting");
            return;
        }
        if (!(jcrRepository instanceof RepositoryImpl)) {
            this.logger.error((Object)String.format("Expected RepositoryImpl, but got: [%s]. Exiting", jcrRepository.getClass().getName()));
            return;
        }
        RepositoryImpl repository = (RepositoryImpl)jcrRepository;
        try {
            this.logger.debug((Object)"Starting Orphaned Version Purge");
            Session systemSession = this.systemSessionFactory.create(repository);
            Node node = systemSession.getNode("/jcr:system/jcr:versionStorage");
            this.findVersionNodesAndPurge(node, systemSession);
            systemSession.save();
            this.logger.debug((Object)"Finished Orphaned Version Purge");
        }
        catch (RepositoryException e) {
            this.logger.error((Object)"Error running Orphaned Version purge", (Throwable)e);
        }
        try {
            this.logger.info((Object)"Creating garbage collector");
            try (GarbageCollector gc = repository.createDataStoreGarbageCollector();){
                this.logger.debug((Object)"Starting marking stage");
                gc.setPersistenceManagerScan(false);
                gc.mark();
                this.logger.debug((Object)"Starting sweeping stage");
                int deleted = gc.sweep();
                this.logger.info((Object)String.format("Garbage collecting completed. %d items were deleted", deleted));
            }
        }
        catch (RepositoryException e) {
            this.logger.error((Object)"Error during garbage collecting", (Throwable)e);
        }
    }

    private void findVersionNodesAndPurge(Node node, Session session) {
        block10: {
            if (node == null || session == null) {
                return;
            }
            try {
                if (!node.getName().equals(JCR_FROZEN_NODE) || !node.hasProperty(JCR_FROZEN_UUID) || node.getParent().getName().equals(JCR_ROOT_VERSION)) break block10;
                Property property = node.getProperty(JCR_FROZEN_UUID);
                Value uuid = property.getValue();
                Node nodeByIdentifier = null;
                try {
                    nodeByIdentifier = session.getNodeByIdentifier(uuid.getString());
                    nodeByIdentifier = session.getNode(nodeByIdentifier.getPath());
                }
                catch (RepositoryException repositoryException) {
                    // empty catch block
                }
                if (nodeByIdentifier == null) {
                    this.logger.info((Object)("Removed orphan version: " + node.getPath()));
                    ((VersionHistory)node.getParent().getParent()).removeVersion(node.getParent().getName());
                }
            }
            catch (RepositoryException e) {
                this.logger.error((Object)"Error purging version nodes. Routine will continue", (Throwable)e);
            }
        }
        NodeIterator nodes = null;
        try {
            nodes = node.getNodes();
        }
        catch (RepositoryException e) {
            this.logger.error((Object)"Error purging version nodes. Routine will continue", (Throwable)e);
        }
        if (nodes == null) {
            return;
        }
        while (nodes.hasNext()) {
            this.findVersionNodesAndPurge(nodes.nextNode(), session);
        }
    }
}

