/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.repository2.unified.jcr;

import org.apache.jackrabbit.util.ISO9075;
import org.apache.jackrabbit.util.Text;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;

public class JcrStringHelper {
    private static boolean useMultiByteEncoding = false;
    private static boolean multiByteValueInitialized = false;
    private static final String SEPARATOR = "/";

    private JcrStringHelper() {
    }

    public static String fileNameEncode(String fileName) {
        return JcrStringHelper.fileNameEncode(fileName, JcrStringHelper.isMultiByteEncodingEnabled());
    }

    public static String fileNameEncode(String fileName, boolean useMultiByte) {
        if (useMultiByte) {
            return Text.escapeIllegalJcrChars((String)ISO9075.encode((String)fileName));
        }
        return Text.escapeIllegalJcrChars((String)fileName);
    }

    public static String idEncode(String id) {
        return Text.escapeIllegalJcrChars((String)id);
    }

    public static String fileNameDecode(String encodedFileName) {
        return JcrStringHelper.fileNameDecode(encodedFileName, JcrStringHelper.isMultiByteEncodingEnabled());
    }

    public static String fileNameDecode(String encodedFileName, boolean useMultiByte) {
        if (useMultiByte) {
            return Text.unescapeIllegalJcrChars((String)ISO9075.decode((String)encodedFileName));
        }
        return Text.unescapeIllegalJcrChars((String)encodedFileName);
    }

    public static String pathEncode(String path) {
        String[] folders = path.split(SEPARATOR);
        StringBuilder encodedPath = new StringBuilder(path.length() * 2);
        for (int i = 0; i < folders.length; ++i) {
            encodedPath.append(JcrStringHelper.fileNameEncode(folders[i]));
            if (i == folders.length - 1 && !path.endsWith(SEPARATOR)) continue;
            encodedPath.append(SEPARATOR);
        }
        return encodedPath.toString();
    }

    public static String pathEncode(String path, boolean useMultiByte) {
        String[] folders = path.split(SEPARATOR);
        StringBuilder encodedPath = new StringBuilder(path.length() * 2);
        for (int i = 0; i < folders.length; ++i) {
            encodedPath.append(JcrStringHelper.fileNameEncode(folders[i], useMultiByte));
            if (i == folders.length - 1 && !path.endsWith(SEPARATOR)) continue;
            encodedPath.append(SEPARATOR);
        }
        return encodedPath.toString();
    }

    public static String pathDecode(String encodedPath) {
        String[] folders = encodedPath.split(SEPARATOR);
        StringBuilder decodedPath = new StringBuilder(encodedPath.length() * 2);
        for (int i = 0; i < folders.length; ++i) {
            decodedPath.append(JcrStringHelper.fileNameDecode(folders[i]));
            if (i == folders.length - 1 && !encodedPath.endsWith(SEPARATOR)) continue;
            decodedPath.append(SEPARATOR);
        }
        return decodedPath.toString();
    }

    public static String pathDecode(String encodedPath, boolean useMultiByte) {
        String[] folders = encodedPath.split(SEPARATOR);
        StringBuilder decodedPath = new StringBuilder(encodedPath.length() * 2);
        for (int i = 0; i < folders.length; ++i) {
            decodedPath.append(JcrStringHelper.fileNameDecode(folders[i], useMultiByte));
            if (i == folders.length - 1 && !encodedPath.endsWith(SEPARATOR)) continue;
            decodedPath.append(SEPARATOR);
        }
        return decodedPath.toString();
    }

    public static boolean isMultiByteEncodingEnabled() {
        if (!multiByteValueInitialized && PentahoSystem.getInitializedOK()) {
            Boolean setting = (Boolean)PentahoSystem.get(Boolean.class, (String)"useMultiByteEncoding", (IPentahoSession)PentahoSessionHolder.getSession());
            useMultiByteEncoding = setting == null ? false : setting;
            multiByteValueInitialized = true;
        }
        return useMultiByteEncoding;
    }

    public static void setMultiByteEncodingEnabled(boolean useMultiByteEncoding) {
        JcrStringHelper.useMultiByteEncoding = useMultiByteEncoding;
    }

    public static boolean isEncoded(String path) {
        return !path.equals(JcrStringHelper.pathDecode(path));
    }
}

