/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.repository2.unified.jcr;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.security.Privilege;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.repository2.unified.RepositoryFilePermission;
import org.pentaho.platform.repository2.unified.jcr.JcrRepositoryFileAclDao;
import org.pentaho.platform.repository2.unified.jcr.JcrRepositoryFileAclUtils;
import org.pentaho.platform.repository2.unified.jcr.PentahoJcrConstants;
import org.springframework.util.Assert;

public class DefaultPermissionConversionHelper
implements JcrRepositoryFileAclDao.IPermissionConversionHelper {
    private static final Log logger = LogFactory.getLog(DefaultPermissionConversionHelper.class);
    protected Multimap<RepositoryFilePermission, String> permissionEnumToPrivilegeNamesMap;
    protected Multimap<String, RepositoryFilePermission> privilegeNameToPermissionEnumsMap;

    public DefaultPermissionConversionHelper(Session session) {
        this.initMaps(session);
    }

    @Override
    public Privilege[] pentahoPermissionsToPrivileges(Session session, EnumSet<RepositoryFilePermission> permissions) throws RepositoryException {
        Assert.notNull((Object)session);
        Assert.notNull(permissions);
        Assert.notEmpty(permissions);
        HashSet<Privilege> privileges = new HashSet<Privilege>();
        for (RepositoryFilePermission currentPermission : permissions) {
            if (this.permissionEnumToPrivilegeNamesMap.containsKey((Object)currentPermission)) {
                Collection privNames = this.permissionEnumToPrivilegeNamesMap.get((Object)currentPermission);
                for (String privName : privNames) {
                    privileges.add(session.getAccessControlManager().privilegeFromName(privName));
                }
                continue;
            }
            logger.debug((Object)("skipping permission=" + currentPermission + " as it doesn't have any corresponding privileges"));
        }
        Assert.isTrue((!privileges.isEmpty() ? 1 : 0) != 0, (String)"no privileges; see previous 'skipping permission' messages");
        return privileges.toArray(new Privilege[0]);
    }

    @Override
    public EnumSet<RepositoryFilePermission> privilegesToPentahoPermissions(Session session, Privilege[] privileges) throws RepositoryException {
        Privilege[] expandedPrivileges;
        Assert.notNull((Object)session);
        Assert.notNull((Object)privileges);
        new PentahoJcrConstants(session);
        EnumSet<RepositoryFilePermission> permissions = EnumSet.noneOf(RepositoryFilePermission.class);
        for (Privilege privilege : expandedPrivileges = JcrRepositoryFileAclUtils.expandPrivileges(privileges, true)) {
            String extendedPrivilegeName = privilege.getName();
            String privilegeName = privilege.getName();
            int colonIndex = privilegeName.indexOf(58);
            if (colonIndex > -1) {
                String namespaceUri = session.getNamespaceURI(privilegeName.substring(0, colonIndex));
                extendedPrivilegeName = "{" + namespaceUri + "}" + privilegeName.substring(colonIndex + 1);
            }
            if (this.privilegeNameToPermissionEnumsMap.containsKey((Object)extendedPrivilegeName)) {
                Collection permEnums = this.privilegeNameToPermissionEnumsMap.get((Object)extendedPrivilegeName);
                for (RepositoryFilePermission perm : permEnums) {
                    permissions.add(perm);
                }
                continue;
            }
            logger.debug((Object)("skipping privilege with name=" + extendedPrivilegeName + " as it doesn't have any corresponding permissions"));
        }
        Assert.isTrue((!permissions.isEmpty() ? 1 : 0) != 0, (String)"no permissions; see previous 'skipping privilege' messages");
        return permissions;
    }

    protected void initMaps(Session session) {
        new PentahoJcrConstants(session);
        this.permissionEnumToPrivilegeNamesMap = HashMultimap.create();
        this.permissionEnumToPrivilegeNamesMap.put((Object)RepositoryFilePermission.READ, (Object)"{http://www.jcp.org/jcr/1.0}read");
        this.permissionEnumToPrivilegeNamesMap.put((Object)RepositoryFilePermission.READ, (Object)"{http://www.jcp.org/jcr/1.0}readAccessControl");
        this.permissionEnumToPrivilegeNamesMap.put((Object)RepositoryFilePermission.DELETE, (Object)"{http://www.jcp.org/jcr/1.0}removeNode");
        this.permissionEnumToPrivilegeNamesMap.put((Object)RepositoryFilePermission.WRITE, (Object)"{http://www.jcp.org/jcr/1.0}addChildNodes");
        this.permissionEnumToPrivilegeNamesMap.put((Object)RepositoryFilePermission.WRITE, (Object)"{http://www.jcp.org/jcr/1.0}removeChildNodes");
        this.permissionEnumToPrivilegeNamesMap.put((Object)RepositoryFilePermission.WRITE, (Object)"{http://www.jcp.org/jcr/1.0}versionManagement");
        this.permissionEnumToPrivilegeNamesMap.put((Object)RepositoryFilePermission.WRITE, (Object)"{http://www.jcp.org/jcr/1.0}lockManagement");
        this.permissionEnumToPrivilegeNamesMap.put((Object)RepositoryFilePermission.WRITE, (Object)"{http://www.jcp.org/jcr/1.0}modifyProperties");
        this.permissionEnumToPrivilegeNamesMap.put((Object)RepositoryFilePermission.WRITE, (Object)"{http://www.jcp.org/jcr/1.0}nodeTypeManagement");
        this.permissionEnumToPrivilegeNamesMap.put((Object)RepositoryFilePermission.WRITE, (Object)"{http://www.jcp.org/jcr/1.0}modifyAccessControl");
        this.permissionEnumToPrivilegeNamesMap.put((Object)RepositoryFilePermission.ACL_MANAGEMENT, (Object)"{http://www.pentaho.org/jcr/2.0}aclManagement");
        this.permissionEnumToPrivilegeNamesMap.put((Object)RepositoryFilePermission.ALL, (Object)"{http://www.jcp.org/jcr/1.0}all");
        this.permissionEnumToPrivilegeNamesMap.put((Object)RepositoryFilePermission.ALL, (Object)"{http://www.pentaho.org/jcr/2.0}aclManagement");
        this.privilegeNameToPermissionEnumsMap = HashMultimap.create();
        this.privilegeNameToPermissionEnumsMap.put((Object)"{http://www.jcp.org/jcr/1.0}read", (Object)RepositoryFilePermission.READ);
        this.privilegeNameToPermissionEnumsMap.put((Object)"{http://www.jcp.org/jcr/1.0}readAccessControl", (Object)RepositoryFilePermission.READ);
        this.privilegeNameToPermissionEnumsMap.put((Object)"{http://www.jcp.org/jcr/1.0}removeNode", (Object)RepositoryFilePermission.DELETE);
        this.privilegeNameToPermissionEnumsMap.put((Object)"{http://www.pentaho.org/jcr/2.0}aclManagement", (Object)RepositoryFilePermission.ACL_MANAGEMENT);
        this.privilegeNameToPermissionEnumsMap.put((Object)"{http://www.jcp.org/jcr/1.0}addChildNodes", (Object)RepositoryFilePermission.WRITE);
        this.privilegeNameToPermissionEnumsMap.put((Object)"{http://www.jcp.org/jcr/1.0}removeChildNodes", (Object)RepositoryFilePermission.WRITE);
        this.privilegeNameToPermissionEnumsMap.put((Object)"{http://www.jcp.org/jcr/1.0}versionManagement", (Object)RepositoryFilePermission.WRITE);
        this.privilegeNameToPermissionEnumsMap.put((Object)"{http://www.jcp.org/jcr/1.0}lockManagement", (Object)RepositoryFilePermission.WRITE);
        this.privilegeNameToPermissionEnumsMap.put((Object)"{http://www.jcp.org/jcr/1.0}modifyProperties", (Object)RepositoryFilePermission.WRITE);
        this.privilegeNameToPermissionEnumsMap.put((Object)"{http://www.jcp.org/jcr/1.0}nodeTypeManagement", (Object)RepositoryFilePermission.WRITE);
        this.privilegeNameToPermissionEnumsMap.put((Object)"{http://www.jcp.org/jcr/1.0}modifyAccessControl", (Object)RepositoryFilePermission.WRITE);
        this.privilegeNameToPermissionEnumsMap.put((Object)"{http://www.jcp.org/jcr/1.0}all", (Object)RepositoryFilePermission.ALL);
        this.privilegeNameToPermissionEnumsMap.put((Object)"{http://www.pentaho.org/jcr/2.0}aclManagement", (Object)RepositoryFilePermission.ALL);
    }
}

