/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.repository2.unified.jcr;

import org.pentaho.platform.repository2.unified.ServerRepositoryPaths;
import org.pentaho.platform.repository2.unified.jcr.IPathConversionHelper;
import org.springframework.util.Assert;

public class DefaultPathConversionHelper
implements IPathConversionHelper {
    @Override
    public String absToRel(String absPath) {
        Assert.hasLength((String)absPath);
        Assert.isTrue((boolean)absPath.startsWith("/"));
        String convertedAbsPath = this.convertPathSlashes(absPath);
        if (ServerRepositoryPaths.getTenantRootFolderPath() != null && convertedAbsPath.startsWith(ServerRepositoryPaths.getTenantRootFolderPath())) {
            String tmpPath = convertedAbsPath.substring(ServerRepositoryPaths.getTenantRootFolderPath().length());
            if ("".equals(tmpPath)) {
                return "/";
            }
            return tmpPath;
        }
        return null;
    }

    @Override
    public String relToAbs(String relPath) {
        Assert.hasLength((String)relPath);
        Assert.isTrue((boolean)relPath.startsWith("/"));
        String convertedRelPath = this.convertPathSlashes(relPath);
        return ServerRepositoryPaths.getTenantRootFolderPath() + ("/".equals(convertedRelPath) ? "" : convertedRelPath);
    }

    private String convertPathSlashes(String path) {
        return path.replace("\\", "/");
    }
}

