/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.repository2.unified.fs;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.commons.lang.StringUtils;
import org.pentaho.platform.api.locale.IPentahoLocale;
import org.pentaho.platform.api.repository2.unified.IRepositoryFileData;
import org.pentaho.platform.api.repository2.unified.RepositoryFile;
import org.pentaho.platform.api.repository2.unified.RepositoryFileAcl;
import org.pentaho.platform.api.repository2.unified.RepositoryFileTree;
import org.pentaho.platform.api.repository2.unified.RepositoryRequest;
import org.pentaho.platform.api.repository2.unified.UnifiedRepositoryException;
import org.pentaho.platform.api.repository2.unified.VersionSummary;
import org.pentaho.platform.api.repository2.unified.data.node.NodeRepositoryFileData;
import org.pentaho.platform.api.repository2.unified.data.simple.SimpleRepositoryFileData;
import org.pentaho.platform.repository.RepositoryFilenameUtils;
import org.pentaho.platform.repository2.unified.IRepositoryFileDao;
import org.pentaho.platform.util.RepositoryPathEncoder;

public class FileSystemRepositoryFileDao
implements IRepositoryFileDao {
    private File rootDir = new File(System.getProperty("solution.root.dir", System.getProperty("user.dir")));
    private static List<Character> reservedChars = Collections.unmodifiableList(Arrays.asList(Character.valueOf('/'), Character.valueOf('\\'), Character.valueOf('\t'), Character.valueOf('\r'), Character.valueOf('\n')));
    private static List<Character> reservedCharsWindows = Collections.unmodifiableList(Arrays.asList(Character.valueOf('?'), Character.valueOf('*'), Character.valueOf(':'), Character.valueOf('<'), Character.valueOf('>'), Character.valueOf('|')));
    private boolean IS_WINDOWS;

    public FileSystemRepositoryFileDao() {
        this(new File(System.getProperty("solution.root.dir", System.getProperty("user.dir"))));
    }

    public FileSystemRepositoryFileDao(String baseDir) {
        this(new File(baseDir));
    }

    public FileSystemRepositoryFileDao(File baseDir) {
        String os = System.getProperty("os.name").toLowerCase();
        this.IS_WINDOWS = os.contains("win");
        if (this.IS_WINDOWS && baseDir.getPath().equals("\\")) {
            baseDir = new File("C:\\");
        }
        assert (baseDir.exists() && baseDir.isDirectory());
        this.rootDir = baseDir;
    }

    @Override
    public boolean canUnlockFile(Serializable fileId) {
        throw new UnsupportedOperationException("This operation is not support by this repository");
    }

    public File getRootDir() {
        return new File(this.rootDir.getAbsolutePath());
    }

    private byte[] inputStreamToBytes(InputStream in) throws IOException {
        int len;
        ByteArrayOutputStream out = new ByteArrayOutputStream(4096);
        byte[] buffer = new byte[4096];
        while ((len = in.read(buffer)) >= 0) {
            out.write(buffer, 0, len);
        }
        in.close();
        out.close();
        return out.toByteArray();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public RepositoryFile createFile(Serializable parentFolderId, RepositoryFile file, IRepositoryFileData data, RepositoryFileAcl acl, String versionMessage) {
        File f;
        FileOutputStream fos;
        block7: {
            String fileNameWithPath = RepositoryFilenameUtils.concat(parentFolderId.toString(), file.getName());
            fos = null;
            f = new File(fileNameWithPath);
            try {
                f.createNewFile();
                fos = new FileOutputStream(f);
                if (data instanceof SimpleRepositoryFileData) {
                    fos.write(this.inputStreamToBytes(((SimpleRepositoryFileData)data).getInputStream()));
                    break block7;
                }
                if (data instanceof NodeRepositoryFileData) {
                    fos.write(this.inputStreamToBytes(new ByteArrayInputStream(((NodeRepositoryFileData)data).getNode().toString().getBytes())));
                }
            }
            catch (FileNotFoundException e) {
                try {
                    throw new UnifiedRepositoryException("Error writing file [" + fileNameWithPath + "]", (Throwable)e);
                    catch (IOException e2) {
                        throw new UnifiedRepositoryException("Error writing file [" + fileNameWithPath + "]", (Throwable)e2);
                    }
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(fos);
                    throw throwable;
                }
            }
        }
        IOUtils.closeQuietly((OutputStream)fos);
        return this.internalGetFile(f);
    }

    @Override
    public RepositoryFile createFolder(Serializable parentFolderId, RepositoryFile file, RepositoryFileAcl acl, String versionMessage) {
        try {
            String folderNameWithPath = parentFolderId + "/" + file.getName();
            File newFolder = new File(folderNameWithPath);
            newFolder.mkdir();
            RepositoryFile repositoryFolder = this.internalGetFile(newFolder);
            return repositoryFolder;
        }
        catch (Throwable th) {
            throw new UnifiedRepositoryException();
        }
    }

    @Override
    public void deleteFile(Serializable fileId, String versionMessage) {
        try {
            File f = new File(fileId.toString());
            if (f.isDirectory()) {
                FileUtils.deleteDirectory((File)f);
            } else {
                f.delete();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void deleteFileAtVersion(Serializable fileId, Serializable versionId) {
        this.deleteFile(fileId, null);
    }

    @Override
    public List<RepositoryFile> getChildren(RepositoryRequest repositoryRequest) {
        ArrayList<RepositoryFile> children = new ArrayList<RepositoryFile>();
        File folder = new File(this.getPhysicalFileLocation(repositoryRequest.getPath()));
        Iterator iterator = FileUtils.listFiles((File)folder, (IOFileFilter)new WildcardFileFilter(repositoryRequest.getChildNodeFilter()), null).iterator();
        while (iterator.hasNext()) {
            children.add(this.internalGetFile((File)iterator.next()));
        }
        return children;
    }

    @Deprecated
    public List<RepositoryFile> getChildren(Serializable folderId) {
        return this.getChildren(folderId, "", false);
    }

    @Deprecated
    public List<RepositoryFile> getChildren(Serializable folderId, String filter) {
        return this.getChildren(folderId, filter, false);
    }

    @Override
    @Deprecated
    public List<RepositoryFile> getChildren(Serializable folderId, String filter, Boolean showHiddenFiles) {
        return this.getChildren(new RepositoryRequest(folderId.toString(), showHiddenFiles, Integer.valueOf(-1), filter));
    }

    @Override
    public <T extends IRepositoryFileData> T getData(Serializable fileId, Serializable versionId, Class<T> dataClass) {
        File f = new File(fileId.toString());
        SimpleRepositoryFileData data = null;
        try {
            if (SimpleRepositoryFileData.class.getName().equals(dataClass.getName())) {
                data = new SimpleRepositoryFileData((InputStream)new FileInputStream(f), "UTF-8", "text/plain");
            } else if (NodeRepositoryFileData.class.getName().equals(dataClass.getName())) {
                throw new UnsupportedOperationException("This operation is not support by this repository");
            }
        }
        catch (FileNotFoundException e) {
            throw new UnifiedRepositoryException((Throwable)e);
        }
        return (T)data;
    }

    public List<RepositoryFile> getDeletedFiles(Serializable folderId, String filter) {
        throw new UnsupportedOperationException("This operation is not support by this repository");
    }

    @Override
    public List<RepositoryFile> getDeletedFiles() {
        throw new UnsupportedOperationException("This operation is not support by this repository");
    }

    public RepositoryFile internalGetFile(File f) {
        RepositoryFile file = null;
        if (f.exists()) {
            String jcrPath = f.getAbsolutePath().substring(this.rootDir.getAbsolutePath().length());
            if (jcrPath.length() == 0) {
                jcrPath = "/";
            } else if (this.IS_WINDOWS) {
                jcrPath = FilenameUtils.separatorsToUnix((String)jcrPath);
            }
            file = new RepositoryFile.Builder((Serializable)((Object)f.getAbsolutePath()), f.getName()).createdDate(new Date(f.lastModified())).lastModificationDate(new Date(f.lastModified())).folder(f.isDirectory()).versioned(false).path(jcrPath).versionId((Serializable)((Object)f.getName())).locked(false).lockDate(null).lockMessage(null).lockOwner(null).title(f.getName()).description(f.getName()).locale(null).fileSize(f.length()).build();
        }
        return file;
    }

    @Override
    public RepositoryFile getFile(String relPath) {
        return this.internalGetFile(new File(this.getPhysicalFileLocation(relPath)));
    }

    static String idToPath(String relPath) {
        relPath = RepositoryPathEncoder.decodeRepositoryPath((String)relPath);
        return relPath.replaceFirst("^/?([A-z])/[/\\\\](.*)", "$1:/$2");
    }

    @Override
    public RepositoryFile getFile(Serializable fileId, Serializable versionId) {
        return this.getFile(fileId.toString());
    }

    @Override
    public RepositoryFile getFileByAbsolutePath(String absPath) {
        return this.getFile(absPath);
    }

    @Override
    public RepositoryFile getFileById(Serializable fileId) {
        return this.getFile(fileId.toString());
    }

    @Override
    public RepositoryFile getFile(String relPath, boolean loadLocaleMaps) {
        return this.getFile(relPath);
    }

    @Override
    public RepositoryFile getFileById(Serializable fileId, boolean loadLocaleMaps) {
        return this.getFile(fileId.toString());
    }

    @Override
    public RepositoryFile getFile(String relPath, IPentahoLocale locale) {
        return this.getFile(relPath);
    }

    @Override
    public RepositoryFile getFileById(Serializable fileId, IPentahoLocale locale) {
        return this.getFile(fileId.toString());
    }

    @Override
    public RepositoryFile getFile(String relPath, boolean loadLocaleMaps, IPentahoLocale locale) {
        return this.getFile(relPath);
    }

    @Override
    public RepositoryFile getFileById(Serializable fileId, boolean loadLocaleMaps, IPentahoLocale locale) {
        return this.getFile(fileId.toString());
    }

    @Override
    public RepositoryFileTree getTree(RepositoryRequest repositoryRequest) {
        File root = new File(this.getPhysicalFileLocation(repositoryRequest.getPath()));
        return this.getTree(root, (int)repositoryRequest.getDepth(), repositoryRequest.getChildNodeFilter(), repositoryRequest.getTypes());
    }

    @Override
    @Deprecated
    public RepositoryFileTree getTree(String relPath, int depth, String filter, boolean showHidden) {
        File root = new File(this.getPhysicalFileLocation(relPath));
        return this.getTree(root, depth, filter, RepositoryRequest.FILES_TYPE_FILTER.FILES_FOLDERS);
    }

    private RepositoryFileTree getTree(File file, int depth, String childNodeFilter, RepositoryRequest.FILES_TYPE_FILTER types) {
        ArrayList<RepositoryFileTree> children;
        RepositoryFile rootFile = this.internalGetFile(file);
        if (depth != 0) {
            children = new ArrayList<RepositoryFileTree>();
            if (file.isDirectory()) {
                File[] childrenArray;
                for (File child : childrenArray = file.listFiles()) {
                    if (child.isFile()) {
                        if (types != RepositoryRequest.FILES_TYPE_FILTER.FILES_FOLDERS && types != RepositoryRequest.FILES_TYPE_FILTER.FILES) continue;
                        children.add(new RepositoryFileTree(this.internalGetFile(child), new ArrayList()));
                        continue;
                    }
                    RepositoryFileTree repositoryChildFileTree = this.getTree(child, depth - 1, childNodeFilter, types);
                    if (repositoryChildFileTree == null) continue;
                    children.add(repositoryChildFileTree);
                }
            }
            Collections.sort(children);
        } else {
            children = null;
        }
        return new RepositoryFileTree(rootFile, children);
    }

    @Override
    public List<VersionSummary> getVersionSummaries(Serializable fileId) {
        throw new UnsupportedOperationException("This operation is not support by this repository");
    }

    @Override
    public VersionSummary getVersionSummary(Serializable fileId, Serializable versionId) {
        RepositoryFile file = this.getFile(fileId, versionId);
        ArrayList labels = new ArrayList();
        return new VersionSummary(fileId, versionId != null ? versionId : fileId, false, file.getCreatedDate(), file.getCreatorId(), "", labels);
    }

    @Override
    public void lockFile(Serializable fileId, String message) {
        throw new UnsupportedOperationException("This operation is not support by this repository");
    }

    @Override
    public void moveFile(Serializable fileId, String destRelPath, String versionMessage) {
        RepositoryFile file = this.getFileById(fileId);
        SimpleRepositoryFileData data = this.getData(fileId, null, SimpleRepositoryFileData.class);
        this.deleteFile(fileId, versionMessage);
        this.createFile(null, file, (IRepositoryFileData)data, null, versionMessage);
    }

    @Override
    public void permanentlyDeleteFile(Serializable fileId, String versionMessage) {
        throw new UnsupportedOperationException("This operation is not support by this repository");
    }

    @Override
    public void restoreFileAtVersion(Serializable fileId, Serializable versionId, String versionMessage) {
        throw new UnsupportedOperationException("This operation is not support by this repository");
    }

    @Override
    public void undeleteFile(Serializable fileId, String versionMessage) {
        throw new UnsupportedOperationException("This operation is not support by this repository");
    }

    @Override
    public void unlockFile(Serializable fileId) {
        throw new UnsupportedOperationException("This operation is not support by this repository");
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public RepositoryFile updateFile(RepositoryFile file, IRepositoryFileData data, String versionMessage) {
        FileOutputStream fos;
        block7: {
            File f = new File(file.getId().toString());
            fos = null;
            try {
                fos = new FileOutputStream(f, false);
                if (data instanceof SimpleRepositoryFileData) {
                    fos.write(this.inputStreamToBytes(((SimpleRepositoryFileData)data).getInputStream()));
                    break block7;
                }
                if (data instanceof NodeRepositoryFileData) {
                    fos.write(this.inputStreamToBytes(new ByteArrayInputStream(((NodeRepositoryFileData)data).getNode().toString().getBytes())));
                }
            }
            catch (FileNotFoundException e) {
                try {
                    throw new UnifiedRepositoryException((Throwable)e);
                    catch (IOException e2) {
                        throw new UnifiedRepositoryException((Throwable)e2);
                    }
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(fos);
                    throw throwable;
                }
            }
        }
        IOUtils.closeQuietly((OutputStream)fos);
        return this.getFile(file.getPath());
    }

    @Override
    public List<RepositoryFile> getReferrers(Serializable fileId) {
        throw new UnsupportedOperationException();
    }

    public void setRootDir(File rootDir) {
        this.rootDir = rootDir;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void setFileMetadata(Serializable fileId, Map<String, Serializable> metadataMap) {
        File targetFile = new File(fileId.toString());
        if (!targetFile.exists()) return;
        FileOutputStream fos = null;
        try {
            File metadataFile;
            File metadataDir = new File(targetFile.getParent() + File.separatorChar + ".metadata");
            if (!metadataDir.exists()) {
                metadataDir.mkdir();
            }
            if (!(metadataFile = new File(metadataDir, targetFile.getName())).exists()) {
                metadataFile.createNewFile();
            }
            StringBuilder data = new StringBuilder();
            for (String key : metadataMap.keySet()) {
                data.append(key).append('=');
                if (metadataMap.get(key) != null) {
                    data.append(metadataMap.get(key).toString());
                }
                data.append('\n');
            }
            fos = new FileOutputStream(metadataFile);
            fos.write(data.toString().getBytes());
        }
        catch (FileNotFoundException e) {
            try {
                throw new UnifiedRepositoryException("Error writing file metadata [" + fileId + "]", (Throwable)e);
                catch (IOException e2) {
                    throw new UnifiedRepositoryException("Error writing file metadata [" + fileId + "]", (Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fos);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)fos);
    }

    /*
     * Loose catch block
     */
    @Override
    public Map<String, Serializable> getFileMetadata(Serializable fileId) {
        String metadataFilename = FilenameUtils.concat((String)FilenameUtils.concat((String)FilenameUtils.getFullPathNoEndSeparator((String)fileId.toString()), (String)".metadata"), (String)FilenameUtils.getName((String)fileId.toString()));
        HashMap<String, Serializable> metadata = new HashMap<String, Serializable>();
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(metadataFilename));
            String data = reader.readLine();
            while (data != null) {
                int pos = data.indexOf(61);
                if (pos > 0) {
                    String key = data.substring(0, pos);
                    String value = data.length() > pos ? data.substring(pos + 1) : null;
                    metadata.put(key, (Serializable)((Object)value));
                }
                data = reader.readLine();
            }
        }
        catch (FileNotFoundException data) {
            IOUtils.closeQuietly(reader);
        }
        catch (IOException e) {
            throw new UnifiedRepositoryException("Error reading metadata [" + fileId + "]", (Throwable)e);
            {
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(reader);
                    throw throwable;
                }
            }
        }
        IOUtils.closeQuietly((Reader)reader);
        return metadata;
    }

    @Override
    public void copyFile(Serializable fileId, String destAbsPath, String versionMessage) {
        throw new UnsupportedOperationException("This operation is not support by this repository");
    }

    @Override
    public List<RepositoryFile> getDeletedFiles(String origParentFolderPath, String filter) {
        throw new UnsupportedOperationException("This operation is not support by this repository");
    }

    @Override
    public List<Character> getReservedChars() {
        ArrayList<Character> charList = new ArrayList<Character>();
        String osName = System.getProperty("os.name");
        charList.addAll(reservedChars);
        if (osName.contains("Windows")) {
            charList.addAll(reservedCharsWindows);
        }
        return charList;
    }

    @Override
    public List<Locale> getAvailableLocalesForFileById(Serializable fileId) {
        throw new UnsupportedOperationException("This operation is not support by this repository");
    }

    @Override
    public List<Locale> getAvailableLocalesForFileByPath(String relPath) {
        throw new UnsupportedOperationException("This operation is not support by this repository");
    }

    @Override
    public List<Locale> getAvailableLocalesForFile(RepositoryFile repositoryFile) {
        throw new UnsupportedOperationException("This operation is not support by this repository");
    }

    @Override
    public Properties getLocalePropertiesForFileById(Serializable fileId, String locale) {
        throw new UnsupportedOperationException("This operation is not support by this repository");
    }

    @Override
    public Properties getLocalePropertiesForFileByPath(String relPath, String locale) {
        throw new UnsupportedOperationException("This operation is not support by this repository");
    }

    @Override
    public Properties getLocalePropertiesForFile(RepositoryFile repositoryFile, String locale) {
        throw new UnsupportedOperationException("This operation is not support by this repository");
    }

    @Override
    public void setLocalePropertiesForFileById(Serializable fileId, String locale, Properties properties) {
        throw new UnsupportedOperationException("This operation is not support by this repository");
    }

    @Override
    public void setLocalePropertiesForFileByPath(String relPath, String locale, Properties properties) {
        throw new UnsupportedOperationException("This operation is not support by this repository");
    }

    @Override
    public void setLocalePropertiesForFile(RepositoryFile repositoryFile, String locale, Properties properties) {
        throw new UnsupportedOperationException("This operation is not support by this repository");
    }

    @Override
    public void deleteLocalePropertiesForFile(RepositoryFile repositoryFile, String locale) {
        throw new UnsupportedOperationException("This operation is not support by this repository");
    }

    @Override
    public RepositoryFile updateFolder(RepositoryFile file, String versionMessage) {
        throw new UnsupportedOperationException("This operation is not support by this repository");
    }

    private String getPhysicalFileLocation(String relPath) {
        if (StringUtils.isEmpty((String)relPath)) {
            return relPath;
        }
        String physicalFileLocation = relPath;
        physicalFileLocation = relPath.equals("/") ? this.rootDir.getAbsolutePath() : (relPath.startsWith(this.rootDir.getAbsolutePath()) ? relPath : RepositoryFilenameUtils.concat(this.rootDir.getAbsolutePath(), relPath.substring(RepositoryFilenameUtils.getPrefixLength(relPath))));
        return physicalFileLocation;
    }
}

