/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.repository2.unified.fs;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.pentaho.platform.api.locale.IPentahoLocale;
import org.pentaho.platform.api.repository2.unified.IRepositoryFileData;
import org.pentaho.platform.api.repository2.unified.IUnifiedRepository;
import org.pentaho.platform.api.repository2.unified.RepositoryFile;
import org.pentaho.platform.api.repository2.unified.RepositoryFileAce;
import org.pentaho.platform.api.repository2.unified.RepositoryFileAcl;
import org.pentaho.platform.api.repository2.unified.RepositoryFilePermission;
import org.pentaho.platform.api.repository2.unified.RepositoryFileTree;
import org.pentaho.platform.api.repository2.unified.RepositoryRequest;
import org.pentaho.platform.api.repository2.unified.VersionSummary;
import org.pentaho.platform.repository2.unified.fs.FileSystemRepositoryFileDao;
import org.springframework.util.Assert;

public class FileSystemBackedUnifiedRepository
implements IUnifiedRepository {
    private FileSystemRepositoryFileDao repositoryFileDao;

    public FileSystemBackedUnifiedRepository(String baseDir) {
        this(new FileSystemRepositoryFileDao(baseDir));
    }

    public FileSystemBackedUnifiedRepository(File baseDir) {
        this(new FileSystemRepositoryFileDao(baseDir));
    }

    public FileSystemBackedUnifiedRepository() {
        this(new FileSystemRepositoryFileDao());
    }

    public FileSystemBackedUnifiedRepository(FileSystemRepositoryFileDao repositoryFileDao) {
        this.repositoryFileDao = repositoryFileDao;
    }

    public boolean canUnlockFile(Serializable fileId) {
        return this.repositoryFileDao.canUnlockFile(fileId);
    }

    public RepositoryFile createFile(Serializable parentFolderId, RepositoryFile file, IRepositoryFileData data, String versionMessage) {
        return this.repositoryFileDao.createFile(parentFolderId, file, data, null, versionMessage);
    }

    public RepositoryFile createFile(Serializable parentFolderId, RepositoryFile file, IRepositoryFileData data, RepositoryFileAcl acl, String versionMessage) {
        return this.repositoryFileDao.createFile(parentFolderId, file, data, acl, versionMessage);
    }

    public RepositoryFile createFolder(Serializable parentFolderId, RepositoryFile file, String versionMessage) {
        return this.repositoryFileDao.createFolder(parentFolderId, file, null, versionMessage);
    }

    public RepositoryFile createFolder(Serializable parentFolderId, RepositoryFile file, RepositoryFileAcl acl, String versionMessage) {
        return this.repositoryFileDao.createFolder(parentFolderId, file, acl, versionMessage);
    }

    public void deleteFile(Serializable fileId, boolean permanent, String versionMessage) {
        this.repositoryFileDao.deleteFile(fileId, versionMessage);
    }

    public void deleteFile(Serializable fileId, String versionMessage) {
        this.repositoryFileDao.deleteFile(fileId, versionMessage);
    }

    public void deleteFileAtVersion(Serializable fileId, Serializable versionId) {
        this.repositoryFileDao.deleteFileAtVersion(fileId, versionId);
    }

    public RepositoryFileAcl getAcl(Serializable fileId) {
        throw new UnsupportedOperationException();
    }

    public List<RepositoryFile> getChildren(RepositoryRequest repositoryRequest) {
        return this.repositoryFileDao.getChildren(repositoryRequest);
    }

    @Deprecated
    public List<RepositoryFile> getChildren(Serializable folderId) {
        return this.repositoryFileDao.getChildren(folderId, "", false);
    }

    @Deprecated
    public List<RepositoryFile> getChildren(Serializable folderId, String filter) {
        return this.repositoryFileDao.getChildren(folderId, filter, false);
    }

    @Deprecated
    public List<RepositoryFile> getChildren(Serializable folderId, String filter, Boolean showHiddenFiles) {
        return this.repositoryFileDao.getChildren(new RepositoryRequest(folderId.toString(), showHiddenFiles, Integer.valueOf(-1), filter));
    }

    public <T extends IRepositoryFileData> T getDataAtVersionForExecute(Serializable fileId, Serializable versionId, Class<T> dataClass) {
        return this.repositoryFileDao.getData(fileId, versionId, dataClass);
    }

    public <T extends IRepositoryFileData> T getDataAtVersionForRead(Serializable fileId, Serializable versionId, Class<T> dataClass) {
        return this.repositoryFileDao.getData(fileId, versionId, dataClass);
    }

    public <T extends IRepositoryFileData> T getDataForExecute(Serializable fileId, Class<T> dataClass) {
        return this.repositoryFileDao.getData(fileId, null, dataClass);
    }

    public <T extends IRepositoryFileData> T getDataForRead(Serializable fileId, Class<T> dataClass) {
        return this.repositoryFileDao.getData(fileId, null, dataClass);
    }

    public List<RepositoryFile> getDeletedFiles(Serializable folderId) {
        return this.repositoryFileDao.getDeletedFiles(folderId, null);
    }

    public List<RepositoryFile> getDeletedFiles(Serializable folderId, String filter) {
        return this.repositoryFileDao.getDeletedFiles(folderId, filter);
    }

    public List<RepositoryFile> getDeletedFiles() {
        return this.repositoryFileDao.getDeletedFiles();
    }

    public List<RepositoryFileAce> getEffectiveAces(Serializable fileId) {
        return null;
    }

    public List<RepositoryFileAce> getEffectiveAces(Serializable fileId, boolean forceEntriesInheriting) {
        return null;
    }

    public RepositoryFile getFile(String path) {
        RepositoryFile result = this.repositoryFileDao.getFile(path);
        if (result == null && path.matches("^/[A-z]:/.*")) {
            result = this.repositoryFileDao.getFile(path.substring(1));
        }
        return result;
    }

    public RepositoryFile getFile(String path, boolean loadLocaleMaps) {
        return this.repositoryFileDao.getFile(path, loadLocaleMaps);
    }

    public RepositoryFile getFileAtVersion(Serializable fileId, Serializable versionId) {
        return this.repositoryFileDao.getFile(fileId, versionId);
    }

    public RepositoryFile getFileById(Serializable fileId) {
        return this.repositoryFileDao.getFile(fileId, null);
    }

    public RepositoryFile getFileById(Serializable fileId, boolean loadLocaleMaps) {
        return this.repositoryFileDao.getFileById(fileId, loadLocaleMaps);
    }

    public RepositoryFile getFile(String path, IPentahoLocale locale) {
        return this.repositoryFileDao.getFile(path, locale);
    }

    public RepositoryFile getFileById(Serializable fileId, IPentahoLocale locale) {
        return this.repositoryFileDao.getFileById(fileId, locale);
    }

    public RepositoryFile getFile(String path, boolean loadLocaleMaps, IPentahoLocale locale) {
        return this.repositoryFileDao.getFile(path, loadLocaleMaps, locale);
    }

    public RepositoryFile getFileById(Serializable fileId, boolean loadLocaleMaps, IPentahoLocale locale) {
        return this.repositoryFileDao.getFileById(fileId, loadLocaleMaps, locale);
    }

    public RepositoryFileTree getTree(RepositoryRequest repositoryRequest) {
        return this.repositoryFileDao.getTree(repositoryRequest);
    }

    public RepositoryFileTree getTree(String path, int depth, String filter, boolean showHidden) {
        return this.repositoryFileDao.getTree(new RepositoryRequest(path, Boolean.valueOf(showHidden), Integer.valueOf(depth), filter));
    }

    public List<VersionSummary> getVersionSummaries(Serializable fileId) {
        return this.repositoryFileDao.getVersionSummaries(fileId);
    }

    public VersionSummary getVersionSummary(Serializable fileId, Serializable versionId) {
        return this.repositoryFileDao.getVersionSummary(fileId, versionId);
    }

    public void setRootDir(File rootDir) {
        this.repositoryFileDao.setRootDir(rootDir);
    }

    public boolean hasAccess(String path, EnumSet<RepositoryFilePermission> permissions) {
        throw new UnsupportedOperationException();
    }

    public void lockFile(Serializable fileId, String message) {
        this.repositoryFileDao.lockFile(fileId, message);
    }

    public void moveFile(Serializable fileId, String destAbsPath, String versionMessage) {
        this.repositoryFileDao.moveFile(fileId, destAbsPath, versionMessage);
    }

    public void restoreFileAtVersion(Serializable fileId, Serializable versionId, String versionMessage) {
        this.repositoryFileDao.restoreFileAtVersion(fileId, versionId, versionMessage);
    }

    public void undeleteFile(Serializable fileId, String versionMessage) {
        this.repositoryFileDao.undeleteFile(fileId, versionMessage);
    }

    public void unlockFile(Serializable fileId) {
        this.repositoryFileDao.unlockFile(fileId);
    }

    public RepositoryFileAcl updateAcl(RepositoryFileAcl acl) {
        throw new UnsupportedOperationException();
    }

    public RepositoryFile updateFile(RepositoryFile file, IRepositoryFileData data, String versionMessage) {
        return this.repositoryFileDao.updateFile(file, data, versionMessage);
    }

    public List<RepositoryFile> getReferrers(Serializable arg0) {
        throw new UnsupportedOperationException();
    }

    public <T extends IRepositoryFileData> List<T> getDataForExecuteInBatch(List<RepositoryFile> files, Class<T> dataClass) {
        throw new UnsupportedOperationException();
    }

    public <T extends IRepositoryFileData> List<T> getDataForReadInBatch(List<RepositoryFile> files, Class<T> dataClass) {
        Assert.notNull(files);
        ArrayList<T> data = new ArrayList<T>(files.size());
        for (RepositoryFile f : files) {
            Assert.notNull((Object)f);
            data.add(this.repositoryFileDao.getData(f.getId(), f.getVersionId(), dataClass));
        }
        return data;
    }

    public List<VersionSummary> getVersionSummaryInBatch(List<RepositoryFile> files) {
        Assert.notNull(files);
        ArrayList<VersionSummary> versionSummaryList = new ArrayList<VersionSummary>(files.size());
        for (RepositoryFile file : files) {
            versionSummaryList.add(this.getVersionSummary(file.getId(), file.getVersionId()));
        }
        return versionSummaryList;
    }

    public void setFileMetadata(Serializable fileId, Map<String, Serializable> metadataMap) {
        this.repositoryFileDao.setFileMetadata(fileId, metadataMap);
    }

    public Map<String, Serializable> getFileMetadata(Serializable fileId) {
        return this.repositoryFileDao.getFileMetadata(fileId);
    }

    public void copyFile(Serializable fileId, String destAbsPath, String versionMessage) {
        throw new UnsupportedOperationException();
    }

    public List<RepositoryFile> getDeletedFiles(String origParentFolderPath, String filter) {
        throw new UnsupportedOperationException();
    }

    public List<RepositoryFile> getDeletedFiles(String origParentFolderPath) {
        throw new UnsupportedOperationException();
    }

    public List<Character> getReservedChars() {
        return this.repositoryFileDao.getReservedChars();
    }

    public List<Locale> getAvailableLocalesForFileById(Serializable fileId) {
        throw new UnsupportedOperationException();
    }

    public List<Locale> getAvailableLocalesForFileByPath(String relPath) {
        throw new UnsupportedOperationException();
    }

    public List<Locale> getAvailableLocalesForFile(RepositoryFile repositoryFile) {
        throw new UnsupportedOperationException();
    }

    public Properties getLocalePropertiesForFileById(Serializable fileId, String locale) {
        throw new UnsupportedOperationException();
    }

    public Properties getLocalePropertiesForFileByPath(String relPath, String locale) {
        throw new UnsupportedOperationException();
    }

    public Properties getLocalePropertiesForFile(RepositoryFile repositoryFile, String locale) {
        throw new UnsupportedOperationException();
    }

    public void setLocalePropertiesForFileById(Serializable fileId, String locale, Properties properties) {
        throw new UnsupportedOperationException();
    }

    public void setLocalePropertiesForFileByPath(String relPath, String locale, Properties properties) {
        throw new UnsupportedOperationException();
    }

    public void setLocalePropertiesForFile(RepositoryFile repositoryFile, String locale, Properties properties) {
        throw new UnsupportedOperationException();
    }

    public void deleteLocalePropertiesForFile(RepositoryFile repositoryFile, String locale) {
        throw new UnsupportedOperationException();
    }

    public RepositoryFile updateFolder(RepositoryFile folder, String versionMessage) {
        throw new UnsupportedOperationException();
    }
}

