/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.repository2.unified.fileio;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.text.MessageFormat;
import org.pentaho.platform.api.repository2.unified.IUnifiedRepository;
import org.pentaho.platform.api.repository2.unified.RepositoryFile;
import org.pentaho.platform.api.repository2.unified.data.simple.SimpleRepositoryFileData;
import org.pentaho.platform.engine.core.system.PentahoSystem;

public class RepositoryFileInputStream
extends InputStream {
    protected InputStream is = null;
    protected IUnifiedRepository repository = null;
    protected RepositoryFile file;
    protected SimpleRepositoryFileData fileData;

    public RepositoryFileInputStream(String path) throws FileNotFoundException {
        this(path, (IUnifiedRepository)PentahoSystem.get(IUnifiedRepository.class));
    }

    public RepositoryFileInputStream(RepositoryFile file) throws FileNotFoundException {
        this(file, (IUnifiedRepository)PentahoSystem.get(IUnifiedRepository.class));
    }

    public RepositoryFileInputStream(Serializable id) throws FileNotFoundException {
        this(id, (IUnifiedRepository)PentahoSystem.get(IUnifiedRepository.class));
    }

    public RepositoryFileInputStream(String path, IUnifiedRepository repository) throws FileNotFoundException {
        if (path == null) {
            throw new FileNotFoundException("Repository file path cannot be null");
        }
        assert (null != repository);
        this.repository = repository;
        this.file = repository.getFile(path);
        if (this.file == null) {
            throw new FileNotFoundException(MessageFormat.format("Repository file {0} not readable or does not exist", path));
        }
        if (this.file.isFolder()) {
            throw new FileNotFoundException(MessageFormat.format("Repository file {0} is a directory", this.file.getPath()));
        }
    }

    public RepositoryFileInputStream(RepositoryFile file, IUnifiedRepository repository) throws FileNotFoundException {
        this(file == null ? null : file.getPath(), repository);
    }

    public RepositoryFileInputStream(Serializable id, IUnifiedRepository repository) throws FileNotFoundException {
        assert (null != repository);
        assert (null != id);
        this.repository = repository;
        this.file = repository.getFileById(id);
        if (this.file == null) {
            throw new FileNotFoundException(MessageFormat.format("Repository file with id {0} not readable or does not exist", id));
        }
        if (this.file.isFolder()) {
            throw new FileNotFoundException(MessageFormat.format("Repository file {0} is a directory", this.file.getPath()));
        }
    }

    public RepositoryFile getFile() {
        return this.file;
    }

    protected void setStream() throws FileNotFoundException {
        if (this.fileData == null) {
            this.fileData = (SimpleRepositoryFileData)this.repository.getDataForRead(this.file.getId(), SimpleRepositoryFileData.class);
        }
        this.is = this.fileData.getInputStream();
    }

    @Override
    public int read() throws IOException {
        if (this.is == null) {
            this.setStream();
        }
        return this.is.read();
    }

    public String getMimeType() {
        if (this.fileData == null) {
            this.fileData = (SimpleRepositoryFileData)this.repository.getDataForRead(this.file.getId(), SimpleRepositoryFileData.class);
        }
        return this.fileData.getMimeType();
    }

    public IUnifiedRepository getRepository() {
        return this.repository;
    }

    public void setRepository(IUnifiedRepository repository) {
        this.repository = repository;
    }
}

