/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.repository2.unified;

import org.pentaho.platform.api.repository2.unified.IRepositoryFileData;
import org.pentaho.platform.api.repository2.unified.IUnifiedRepository;
import org.pentaho.platform.api.repository2.unified.RepositoryFile;
import org.pentaho.platform.api.repository2.unified.RepositoryFileAcl;
import org.pentaho.platform.repository.RepositoryFilenameUtils;

public class RepositoryUtils {
    private IUnifiedRepository repository;

    public RepositoryUtils(IUnifiedRepository repository) {
        if (null == repository) {
            throw new NullPointerException();
        }
        this.repository = repository;
    }

    public IUnifiedRepository getRepository() {
        return this.repository;
    }

    public RepositoryFile getFolder(String path, boolean createIfNotExist, boolean createParents, String versionMessage) {
        return this.getFolder(path, null, createIfNotExist, createParents, versionMessage);
    }

    public RepositoryFile getFolder(String path, RepositoryFileAcl acl, boolean createIfNotExist, boolean createParents, String versionMessage) {
        RepositoryFile parentFolder;
        String parentPath;
        RepositoryFile folder = this.repository.getFile(path);
        if (null == folder && createIfNotExist && !(parentPath = RepositoryFilenameUtils.getFullPathNoEndSeparator(path)).equals(path) && null != (parentFolder = this.getFolder(parentPath, acl, createParents, createParents, versionMessage))) {
            String folderName = RepositoryFilenameUtils.getName(path);
            folder = new RepositoryFile.Builder(folderName).path(path).folder(true).build();
            folder = null != acl ? this.repository.createFolder(parentFolder.getId(), folder, acl, versionMessage) : this.repository.createFolder(parentFolder.getId(), folder, versionMessage);
        }
        return folder;
    }

    public RepositoryFile getFile(String path, IRepositoryFileData data, boolean createIfNotExist, boolean createParents, String versionMessage) {
        String parentFolderName;
        RepositoryFile parentFolder;
        RepositoryFile file = this.repository.getFile(path);
        if (null == file && createIfNotExist && null != (parentFolder = this.getFolder(parentFolderName = RepositoryFilenameUtils.getFullPathNoEndSeparator(path), createParents, createParents, versionMessage))) {
            String fileName = RepositoryFilenameUtils.getName(path);
            file = new RepositoryFile.Builder(fileName).folder(false).build();
            file = this.repository.createFile(parentFolder.getId(), file, data, versionMessage);
        }
        return file;
    }

    public RepositoryFile saveFile(String filePath, IRepositoryFileData data, boolean create, boolean overwrite, boolean createParentDirs, boolean versioned, String versionMessage) {
        RepositoryFile file = this.repository.getFile(filePath);
        if (file == null) {
            if (!create) {
                return null;
            }
            return this.createFile(filePath, data, createParentDirs, versioned, versionMessage);
        }
        if (!overwrite) {
            return null;
        }
        return this.repository.updateFile(file, data, versionMessage);
    }

    protected RepositoryFile createFile(String filePath, IRepositoryFileData data, boolean createParentDirs, boolean versioned, String versionMessage) {
        String path = RepositoryFilenameUtils.getFullPath(filePath);
        String filename = RepositoryFilenameUtils.getName(filePath);
        RepositoryFile parentDir = this.getFolder(path, createParentDirs, createParentDirs, versionMessage);
        if (null == parentDir) {
            return null;
        }
        return this.repository.createFile(parentDir.getId(), new RepositoryFile.Builder(filename).versioned(versioned).build(), data, versionMessage);
    }
}

