/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.repository2.mt;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.security.userroledao.IUserRoleDao;
import org.pentaho.platform.api.mt.ITenant;
import org.pentaho.platform.api.mt.ITenantedPrincipleNameResolver;
import org.pentaho.platform.api.repository2.unified.RepositoryFile;
import org.pentaho.platform.api.repository2.unified.RepositoryFileAcl;
import org.pentaho.platform.api.repository2.unified.RepositoryFilePermission;
import org.pentaho.platform.api.repository2.unified.RepositoryFileSid;
import org.pentaho.platform.core.mt.Tenant;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.StandaloneSession;
import org.pentaho.platform.repository2.mt.AbstractRepositoryTenantManager;
import org.pentaho.platform.repository2.unified.IRepositoryFileAclDao;
import org.pentaho.platform.repository2.unified.IRepositoryFileDao;
import org.pentaho.platform.repository2.unified.ServerRepositoryPaths;
import org.pentaho.platform.repository2.unified.jcr.JcrRepositoryFileUtils;
import org.pentaho.platform.repository2.unified.jcr.PentahoJcrConstants;
import org.pentaho.platform.security.policy.rolebased.IRoleAuthorizationPolicyRoleBindingDao;
import org.pentaho.platform.security.policy.rolebased.messages.Messages;
import org.springframework.extensions.jcr.JcrCallback;
import org.springframework.extensions.jcr.JcrTemplate;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.User;
import org.springframework.util.Assert;

public class RepositoryTenantManager
extends AbstractRepositoryTenantManager {
    protected static final Log logger = LogFactory.getLog(RepositoryTenantManager.class);
    protected JcrTemplate jcrTemplate;

    public RepositoryTenantManager(IRepositoryFileDao contentDao, IUserRoleDao userRoleDao, IRepositoryFileAclDao repositoryFileAclDao, IRoleAuthorizationPolicyRoleBindingDao roleBindingDao, JcrTemplate jcrTemplate, String repositoryAdminUsername, String tenantAuthenticatedAuthorityNamePattern, ITenantedPrincipleNameResolver tenantedUserNameResolver, ITenantedPrincipleNameResolver tenantedRoleNameResolver, String tenantAdminRoleName, List<String> singleTenantAuthenticatedAuthorityRoleBindingList) {
        super(contentDao, userRoleDao, repositoryFileAclDao, roleBindingDao, repositoryAdminUsername, tenantAuthenticatedAuthorityNamePattern, tenantedUserNameResolver, tenantedRoleNameResolver, tenantAdminRoleName, singleTenantAuthenticatedAuthorityRoleBindingList);
        this.jcrTemplate = jcrTemplate;
    }

    private RepositoryFile createTenantFolder(final ITenant parentTenant, final String tenantName, final String tenantCreatorId) {
        return (RepositoryFile)this.jcrTemplate.execute(new JcrCallback(){

            public Object doInJcr(Session session) throws RepositoryException {
                Tenant tenant = null;
                RepositoryFile parentFolder = null;
                if (parentTenant == null) {
                    tenant = new Tenant("/" + tenantName, Boolean.valueOf(true));
                } else {
                    tenant = new Tenant(parentTenant.getRootFolderAbsolutePath() + "/" + tenantName, Boolean.valueOf(true));
                    String folderPath = parentTenant.getRootFolderAbsolutePath();
                    parentFolder = RepositoryTenantManager.this.repositoryFileDao.getFileByAbsolutePath(folderPath);
                }
                RepositoryFileAcl acl = new RepositoryFileAcl.Builder(tenantCreatorId).entriesInheriting(false).build();
                RepositoryFile systemTenantFolder = RepositoryTenantManager.this.repositoryFileDao.createFolder(parentFolder != null ? parentFolder.getId() : null, new RepositoryFile.Builder(tenant.getName()).folder(true).build(), acl, "");
                RepositoryTenantManager.this.repositoryFileDao.getFileByAbsolutePath(tenant.getId());
                Map<String, Serializable> fileMeta = RepositoryTenantManager.this.repositoryFileDao.getFileMetadata(systemTenantFolder.getId());
                fileMeta.put("isTenantRoot", Boolean.valueOf(true));
                fileMeta.put("isTenantEnabled", Boolean.valueOf(true));
                JcrRepositoryFileUtils.setFileMetadata(session, systemTenantFolder.getId(), fileMeta);
                RepositoryTenantManager.this.createRuntimeRolesFolderNode(session, new PentahoJcrConstants(session), (ITenant)tenant);
                return systemTenantFolder;
            }
        });
    }

    public Node createAuthzFolderNode(Session session, PentahoJcrConstants pentahoJcrConstants, ITenant tenant) throws RepositoryException {
        Node tenantRootFolderNode = null;
        try {
            tenantRootFolderNode = (Node)session.getItem(ServerRepositoryPaths.getTenantRootFolderPath(tenant));
        }
        catch (PathNotFoundException e) {
            Assert.state((boolean)false, (String)Messages.getInstance().getString("JcrRoleAuthorizationPolicyRoleBindingDao.ERROR_0002_REPO_NOT_INITIALIZED"));
        }
        Node authzFolderNode = tenantRootFolderNode.addNode(".authz", pentahoJcrConstants.getPHO_NT_INTERNALFOLDER());
        session.save();
        return authzFolderNode;
    }

    public Node createRoleBasedFolderNode(Session session, PentahoJcrConstants pentahoJcrConstants, ITenant tenant) throws RepositoryException {
        Node authzFolderNode = this.createAuthzFolderNode(session, pentahoJcrConstants, tenant);
        Node node = authzFolderNode.addNode("roleBased", pentahoJcrConstants.getPHO_NT_INTERNALFOLDER());
        authzFolderNode.save();
        session.save();
        return node;
    }

    public Node createRuntimeRolesFolderNode(Session session, PentahoJcrConstants pentahoJcrConstants, ITenant tenant) throws RepositoryException {
        Node roleBasedFolderNode = this.createRoleBasedFolderNode(session, pentahoJcrConstants, tenant);
        Node node = roleBasedFolderNode.addNode("runtimeRoles", pentahoJcrConstants.getPHO_NT_INTERNALFOLDER());
        roleBasedFolderNode.save();
        session.save();
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ITenant createTenant(ITenant parentTenant, String tenantName, String tenantAdminRoleName, String authenticatedRoleName, String anonymousRoleName) {
        String parentTenantFolder;
        Tenant newTenant;
        if (parentTenant == null ? this.repositoryFileDao.getFileByAbsolutePath("/" + tenantName) != null : this.repositoryFileDao.getFileByAbsolutePath(parentTenant.getRootFolderAbsolutePath() + "/" + tenantName) != null) {
            return null;
        }
        if (parentTenant == null) {
            newTenant = new Tenant("/" + tenantName, Boolean.valueOf(true));
            parentTenantFolder = "/";
        } else {
            newTenant = new Tenant(parentTenant.getRootFolderAbsolutePath() + "/" + tenantName, Boolean.valueOf(true));
            parentTenantFolder = parentTenant.getRootFolderAbsolutePath();
        }
        String tenantCreatorId = PentahoSessionHolder.getSession().getName();
        RepositoryFile tenantRootFolder = this.createTenantFolder(parentTenant, tenantName, tenantCreatorId);
        this.userRoleDao.createRole((ITenant)newTenant, tenantAdminRoleName, "", new String[0]);
        this.userRoleDao.createRole((ITenant)newTenant, authenticatedRoleName, "", new String[0]);
        this.userRoleDao.createRole((ITenant)newTenant, anonymousRoleName, "", new String[0]);
        this.roleBindingDao.setRoleBindings((ITenant)newTenant, authenticatedRoleName, this.singleTenantAuthenticatedAuthorityRoleBindingList);
        String tenantAdminRoleId = this.tenantedRoleNameResolver.getPrincipleId((ITenant)newTenant, tenantAdminRoleName);
        RepositoryFileSid tenantAdminRoleSid = new RepositoryFileSid(tenantAdminRoleId, RepositoryFileSid.Type.ROLE);
        this.jcrTemplate.save();
        if (parentTenant == null) {
            this.repositoryFileAclDao.addAce(tenantRootFolder.getId(), tenantAdminRoleSid, EnumSet.of(RepositoryFilePermission.ALL));
        } else {
            RepositoryFileAcl acl = this.repositoryFileAclDao.getAcl(tenantRootFolder.getId());
            RepositoryFileAcl.Builder aclBuilder = new RepositoryFileAcl.Builder(acl).ace(tenantAdminRoleSid, EnumSet.of(RepositoryFilePermission.ALL));
            IPentahoSession origPentahoSession = PentahoSessionHolder.getSession();
            Authentication origAuthentication = SecurityContextHolder.getContext().getAuthentication();
            this.login(this.repositoryAdminUsername, tenantAdminRoleId);
            try {
                while (!parentTenantFolder.equals("/")) {
                    Tenant tenant = new Tenant(parentTenantFolder, Boolean.valueOf(true));
                    String parentTenantAdminRoleId = this.tenantedRoleNameResolver.getPrincipleId((ITenant)tenant, tenantAdminRoleName);
                    RepositoryFileSid parentTenantAdminSid = new RepositoryFileSid(parentTenantAdminRoleId, RepositoryFileSid.Type.ROLE);
                    aclBuilder.ace(parentTenantAdminSid, EnumSet.of(RepositoryFilePermission.ALL));
                    parentTenantFolder = FilenameUtils.getFullPathNoEndSeparator((String)parentTenantFolder);
                }
                this.repositoryFileAclDao.updateAcl(aclBuilder.build());
            }
            catch (Throwable th) {
                th.printStackTrace();
            }
            finally {
                PentahoSessionHolder.setSession((IPentahoSession)origPentahoSession);
                SecurityContextHolder.getContext().setAuthentication(origAuthentication);
            }
        }
        try {
            RepositoryFileSid fileOwnerSid = new RepositoryFileSid(tenantCreatorId);
            this.createInitialTenantFolders((ITenant)newTenant, tenantRootFolder, fileOwnerSid);
        }
        catch (Exception ex) {
            throw new RuntimeException("Error creating initial tenant folders", ex);
        }
        return newTenant;
    }

    protected IPentahoSession createAuthenticatedPentahoSession(String tenantId, String userName) {
        StandaloneSession pentahoSession = new StandaloneSession(userName);
        pentahoSession.setAuthenticated(tenantId, userName);
        return pentahoSession;
    }

    protected void login(String username, String tenantAdminRoleId) {
        StandaloneSession pentahoSession = new StandaloneSession(username);
        pentahoSession.setAuthenticated(null, username);
        PentahoSessionHolder.setSession((IPentahoSession)pentahoSession);
        String password = "ignored";
        ArrayList<SimpleGrantedAuthority> authList = new ArrayList<SimpleGrantedAuthority>();
        authList.add(new SimpleGrantedAuthority(tenantAdminRoleId));
        User userDetails = new User(username, "ignored", true, true, true, true, authList);
        UsernamePasswordAuthenticationToken auth = new UsernamePasswordAuthenticationToken((Object)userDetails, (Object)"ignored", authList);
        PentahoSessionHolder.setSession((IPentahoSession)pentahoSession);
        SecurityContextHolder.getContext().setAuthentication((Authentication)auth);
    }

    public void deleteTenants(final List<ITenant> tenants) {
        this.jcrTemplate.execute(new JcrCallback(){

            public Object doInJcr(Session session) {
                try {
                    RepositoryTenantManager.this.deleteTenants(session, tenants);
                }
                catch (RepositoryException e) {
                    e.printStackTrace();
                }
                return null;
            }
        });
    }

    public void deleteTenant(final ITenant tenant) {
        this.jcrTemplate.execute(new JcrCallback(){

            public Object doInJcr(Session session) {
                try {
                    RepositoryTenantManager.this.deleteTenant(session, tenant);
                }
                catch (RepositoryException e) {
                    e.printStackTrace();
                }
                return null;
            }
        });
    }

    public void enableTenant(final ITenant tenant, final boolean enable) {
        this.jcrTemplate.execute(new JcrCallback(){

            public Object doInJcr(Session session) {
                try {
                    RepositoryTenantManager.this.enableTenant(session, tenant, enable);
                }
                catch (RepositoryException e) {
                    e.printStackTrace();
                }
                return null;
            }
        });
    }

    @Override
    public RepositoryFile getTenantRootFolder(ITenant tenant) {
        Map<String, Serializable> metadata;
        RepositoryFile rootFolder = this.repositoryFileDao.getFileByAbsolutePath(tenant.getRootFolderAbsolutePath());
        if (!(rootFolder == null || (metadata = this.repositoryFileDao.getFileMetadata(rootFolder.getId())).containsKey("isTenantRoot") && ((Boolean)metadata.get("isTenantRoot")).booleanValue())) {
            rootFolder = null;
        }
        return rootFolder;
    }

    public void enableTenants(final List<ITenant> tenants, final boolean enable) {
        this.jcrTemplate.execute(new JcrCallback(){

            public Object doInJcr(Session session) {
                try {
                    RepositoryTenantManager.this.enableTenants(session, tenants, enable);
                }
                catch (RepositoryException e) {
                    e.printStackTrace();
                }
                return null;
            }
        });
    }

    public List<ITenant> getChildTenants(final ITenant parentTenant, final boolean includeDisabledTenants) {
        return (List)this.jcrTemplate.execute(new JcrCallback(){

            public Object doInJcr(Session session) {
                List<Object> childTenants = null;
                try {
                    childTenants = RepositoryTenantManager.this.getChildTenants(session, parentTenant, includeDisabledTenants);
                }
                catch (RepositoryException e) {
                    childTenants = new ArrayList();
                    e.printStackTrace();
                }
                return childTenants;
            }
        });
    }

    public List<ITenant> getChildTenants(final ITenant parentTenant) {
        return (List)this.jcrTemplate.execute(new JcrCallback(){

            public Object doInJcr(Session session) {
                List<Object> childTenants = null;
                try {
                    childTenants = RepositoryTenantManager.this.getChildTenants(session, parentTenant);
                }
                catch (RepositoryException e) {
                    childTenants = new ArrayList();
                    e.printStackTrace();
                }
                return childTenants;
            }
        });
    }

    public void updateTentant(String tenantPath, Map<String, Serializable> tenantInfo) {
    }

    String getParentPath(String parentPath) {
        if (parentPath != null && parentPath.length() > 0) {
            return ServerRepositoryPaths.getPentahoRootFolderPath() + "/" + parentPath + "/";
        }
        return ServerRepositoryPaths.getPentahoRootFolderPath() + "/";
    }

    String getTenantPath(String parentPath, String tenantName) {
        return this.getParentPath(parentPath) + tenantName;
    }

    public ITenant getTenant(final String tenantId) {
        return (ITenant)this.jcrTemplate.execute(new JcrCallback(){

            public Object doInJcr(Session session) throws IOException, RepositoryException {
                return RepositoryTenantManager.this.getTenant(session, tenantId);
            }
        });
    }

    public ITenant getTenantByRootFolderPath(final String tenantRootFolderPath) {
        return (ITenant)this.jcrTemplate.execute(new JcrCallback(){

            public Object doInJcr(Session session) throws IOException, RepositoryException {
                return RepositoryTenantManager.this.getTenant(session, tenantRootFolderPath);
            }
        });
    }

    public boolean isSubTenant(final ITenant parentTenant, final ITenant descendantTenant) {
        return (Boolean)this.jcrTemplate.execute(new JcrCallback(){

            public Object doInJcr(Session session) throws IOException, RepositoryException {
                return RepositoryTenantManager.this.isSubTenant(session, parentTenant, descendantTenant);
            }
        });
    }

    public IUserRoleDao getUserRoleDao() {
        return this.userRoleDao;
    }

    private RepositoryFile createPublicFolder(ITenant tenant, RepositoryFile tenantRootFolder, RepositoryFileSid fileOwnerSid) {
        String tenantAdminRoleId = this.tenantedRoleNameResolver.getPrincipleId(tenant, this.tenantAdminRoleName);
        RepositoryFileSid tenantAdminRoleSid = new RepositoryFileSid(tenantAdminRoleId, RepositoryFileSid.Type.ROLE);
        String tenantAuthenticatedRoleId = this.tenantedRoleNameResolver.getPrincipleId(tenant, this.tenantAuthenticatedRoleName);
        RepositoryFileSid tenantAuthenticatedRoleSid = new RepositoryFileSid(tenantAuthenticatedRoleId, RepositoryFileSid.Type.ROLE);
        RepositoryFile publicFolder = this.repositoryFileDao.createFolder(tenantRootFolder.getId(), new RepositoryFile.Builder(ServerRepositoryPaths.getTenantPublicFolderName()).folder(true).title(Messages.getInstance().getString("RepositoryTenantManager.publicFolderDisplayName")).build(), new RepositoryFileAcl.Builder(fileOwnerSid).ace(tenantAdminRoleSid, EnumSet.of(RepositoryFilePermission.ALL)).ace(tenantAuthenticatedRoleSid, EnumSet.of(RepositoryFilePermission.READ)).build(), null);
        return publicFolder;
    }

    private RepositoryFile createHomeFolder(ITenant tenant, RepositoryFile tenantRootFolder, RepositoryFileSid fileOwnerSid) {
        String tenantAdminRoleId = this.tenantedRoleNameResolver.getPrincipleId(tenant, this.tenantAdminRoleName);
        RepositoryFileSid tenantAdminRoleSid = new RepositoryFileSid(tenantAdminRoleId, RepositoryFileSid.Type.ROLE);
        String tenantAuthenticatedRoleId = this.tenantedRoleNameResolver.getPrincipleId(tenant, this.tenantAuthenticatedRoleName);
        RepositoryFileSid tenantAuthenticatedRoleSid = new RepositoryFileSid(tenantAuthenticatedRoleId, RepositoryFileSid.Type.ROLE);
        RepositoryFile homeFolder = this.repositoryFileDao.createFolder(tenantRootFolder.getId(), new RepositoryFile.Builder(ServerRepositoryPaths.getTenantHomeFolderName()).folder(true).title(Messages.getInstance().getString("RepositoryTenantManager.usersFolderDisplayName")).build(), new RepositoryFileAcl.Builder(fileOwnerSid).ace(tenantAdminRoleSid, EnumSet.of(RepositoryFilePermission.ALL)).ace(tenantAuthenticatedRoleSid, EnumSet.of(RepositoryFilePermission.READ)).build(), null);
        return homeFolder;
    }

    private RepositoryFile createEtcFolder(ITenant tenant, RepositoryFile tenantRootFolder, RepositoryFileSid fileOwnerSid) {
        String tenantAuthenticatedRoleId = this.tenantedRoleNameResolver.getPrincipleId(tenant, this.tenantAuthenticatedRoleName);
        RepositoryFileSid tenantAuthenticatedRoleSid = new RepositoryFileSid(tenantAuthenticatedRoleId, RepositoryFileSid.Type.ROLE);
        String tenantAdminRoleId = this.tenantedRoleNameResolver.getPrincipleId(tenant, this.tenantAdminRoleName);
        RepositoryFileSid tenantAdminRoleSid = new RepositoryFileSid(tenantAdminRoleId, RepositoryFileSid.Type.ROLE);
        RepositoryFile etcFolder = this.repositoryFileDao.createFolder(tenantRootFolder.getId(), new RepositoryFile.Builder(ServerRepositoryPaths.getTenantEtcFolderName()).folder(true).build(), new RepositoryFileAcl.Builder(fileOwnerSid).entriesInheriting(true).ace(tenantAuthenticatedRoleSid, EnumSet.of(RepositoryFilePermission.READ)).ace(tenantAdminRoleSid, EnumSet.of(RepositoryFilePermission.ALL)).build(), null);
        RepositoryFile pdiFolder = this.repositoryFileDao.createFolder(etcFolder.getId(), new RepositoryFile.Builder("pdi").folder(true).build(), new RepositoryFileAcl.Builder(fileOwnerSid).entriesInheriting(true).build(), null);
        this.repositoryFileDao.createFolder(pdiFolder.getId(), new RepositoryFile.Builder("databases").folder(true).build(), new RepositoryFileAcl.Builder(fileOwnerSid).entriesInheriting(true).build(), null);
        this.repositoryFileDao.createFolder(pdiFolder.getId(), new RepositoryFile.Builder("slaveServers").folder(true).build(), new RepositoryFileAcl.Builder(fileOwnerSid).entriesInheriting(true).build(), null);
        this.repositoryFileDao.createFolder(pdiFolder.getId(), new RepositoryFile.Builder("clusterSchemas").folder(true).build(), new RepositoryFileAcl.Builder(fileOwnerSid).entriesInheriting(true).build(), null);
        this.repositoryFileDao.createFolder(pdiFolder.getId(), new RepositoryFile.Builder("partitionSchemas").folder(true).build(), new RepositoryFileAcl.Builder(fileOwnerSid).entriesInheriting(true).build(), null);
        this.repositoryFileDao.createFolder(etcFolder.getId(), new RepositoryFile.Builder("metastore").folder(true).build(), new RepositoryFileAcl.Builder(fileOwnerSid).entriesInheriting(true).build(), null);
        return etcFolder;
    }

    protected void createInitialTenantFolders(ITenant tenant, RepositoryFile tenantRootFolder, RepositoryFileSid fileOwnerSid) throws RepositoryException {
        this.createPublicFolder(tenant, tenantRootFolder, fileOwnerSid);
        RepositoryFile etcFolder = this.createEtcFolder(tenant, tenantRootFolder, fileOwnerSid);
        this.createHomeFolder(tenant, tenantRootFolder, fileOwnerSid);
        this.setAsSystemFolder(etcFolder.getId());
    }
}

