/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security.authorization.acl;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jcr.RepositoryException;
import org.apache.commons.collections4.map.LRUMap;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.cache.GrowingLRUMap;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.security.authorization.AccessControlModifications;
import org.apache.jackrabbit.core.security.authorization.acl.ACLProvider;
import org.apache.jackrabbit.core.security.authorization.acl.CachingEntryCollector;
import org.apache.jackrabbit.core.security.authorization.acl.EntryCollector;
import org.apache.jackrabbit.core.security.authorization.acl.PentahoEntryCollector;
import org.pentaho.platform.api.engine.ICacheManager;
import org.pentaho.platform.api.engine.ILogoutListener;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachingPentahoEntryCollector
extends PentahoEntryCollector {
    private static final Logger log = LoggerFactory.getLogger(CachingEntryCollector.class);
    public static final String ENTRY_COLLECTOR = "ENTRY_COLLECTOR";
    private final ICacheManager cacheManager;
    private final Map<IPentahoSession, ConcurrentMap<NodeId, FutureEntries>> futuresBySession = Collections.synchronizedMap(new LRUMap(512, 128));
    private static final Pattern SESSION_KEY_PATTERN = Pattern.compile("[^\\t]*\\t(.*)");

    public CachingPentahoEntryCollector(SessionImpl systemSession, NodeId rootID, Map configuration) throws RepositoryException {
        super(systemSession, rootID, configuration);
        PentahoSystem.addLogoutListener((ILogoutListener)new ILogoutListener(){

            public void onLogout(IPentahoSession iPentahoSession) {
                log.debug("Flushing ACL Entries due to logout for session: " + iPentahoSession.getName());
                CachingPentahoEntryCollector.this.flushCachesOfSession(iPentahoSession);
            }
        });
        this.cacheManager = PentahoSystem.getCacheManager(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushCachesOfSession(IPentahoSession iPentahoSession) {
        this.cacheManager.removeFromSessionCache(iPentahoSession, ENTRY_COLLECTOR);
        Map<IPentahoSession, ConcurrentMap<NodeId, FutureEntries>> map = this.futuresBySession;
        synchronized (map) {
            if (this.futuresBySession.containsKey(iPentahoSession)) {
                this.futuresBySession.get(iPentahoSession).clear();
                this.futuresBySession.remove(iPentahoSession);
            }
        }
    }

    private EntryCache getCache() {
        IPentahoSession session = PentahoSessionHolder.getSession();
        EntryCache cache = (EntryCache)this.cacheManager.getFromSessionCache(session, ENTRY_COLLECTOR);
        if (cache == null) {
            cache = new EntryCache();
            this.cacheManager.putInSessionCache(session, ENTRY_COLLECTOR, (Object)cache);
        }
        return cache;
    }

    private ConcurrentMap<NodeId, FutureEntries> getFutures() {
        IPentahoSession session = PentahoSessionHolder.getSession();
        if (this.futuresBySession.containsKey(session)) {
            return this.futuresBySession.get(session);
        }
        ConcurrentHashMap<NodeId, FutureEntries> futures = new ConcurrentHashMap<NodeId, FutureEntries>();
        this.futuresBySession.put(session, futures);
        return futures;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void close() {
        super.close();
        this.performAgainstAllInCache(new CacheCallable(){

            @Override
            public void call(EntryCache cache) {
                cache.clear();
            }
        });
        Map<IPentahoSession, ConcurrentMap<NodeId, FutureEntries>> map = this.futuresBySession;
        synchronized (map) {
            for (Map.Entry<IPentahoSession, ConcurrentMap<NodeId, FutureEntries>> entry : this.futuresBySession.entrySet()) {
                entry.getValue().clear();
            }
            this.futuresBySession.clear();
        }
    }

    @Override
    protected PentahoEntryCollector.PentahoEntries getEntries(NodeImpl node) throws RepositoryException {
        NodeId nodeId = node.getNodeId();
        EntryCollector.Entries entries = this.getCache().get(nodeId);
        if (entries == null) {
            entries = this.updateCache(node);
        }
        return entries instanceof PentahoEntryCollector.PentahoEntries ? (PentahoEntryCollector.PentahoEntries)entries : new PentahoEntryCollector.PentahoEntries(entries);
    }

    protected EntryCollector.Entries getEntries(NodeId nodeId) throws RepositoryException {
        EntryCollector.Entries entries = this.getCache().get(nodeId);
        if (entries == null) {
            NodeImpl n = this.getNodeById(nodeId);
            entries = this.updateCache(n);
        }
        return entries;
    }

    private EntryCollector.Entries internalUpdateCache(NodeImpl node) throws RepositoryException {
        PentahoEntryCollector.PentahoEntries entries = super.getEntries(node);
        if (this.isRootId(node.getNodeId()) && this.getCache().specialCasesRoot() || !entries.isEmpty()) {
            this.getCache().put(node.getNodeId(), entries);
        }
        return entries;
    }

    private EntryCollector.Entries updateCache(NodeImpl node) throws RepositoryException {
        return this.throttledUpdateCache(node);
    }

    private EntryCollector.Entries throttledUpdateCache(NodeImpl node) throws RepositoryException {
        NodeId id = node.getNodeId();
        FutureEntries fe = null;
        FutureEntries nfe = new FutureEntries();
        boolean found = true;
        fe = this.getFutures().putIfAbsent(id, nfe);
        if (fe == null) {
            found = false;
            fe = nfe;
        }
        if (found) {
            return fe.get();
        }
        try {
            EntryCollector.Entries e = this.internalUpdateCache(node);
            this.getFutures().remove(id);
            fe.setResult(e);
            return e;
        }
        catch (Throwable problem) {
            this.getFutures().remove(id);
            fe.setProblem(problem);
            if (problem instanceof RepositoryException) {
                throw (RepositoryException)problem;
            }
            throw new RuntimeException(problem);
        }
    }

    private NodeId getNextID(NodeImpl node) throws RepositoryException {
        NodeImpl n = node;
        NodeId nextId = null;
        while (nextId == null && !this.isRootId(n.getNodeId())) {
            NodeId parentId = n.getParentId();
            if (this.getCache().containsKey(parentId)) {
                nextId = parentId;
                continue;
            }
            NodeImpl parent = (NodeImpl)n.getParent();
            if (CachingPentahoEntryCollector.hasEntries(parent)) {
                nextId = parentId;
                continue;
            }
            n = parent;
        }
        return nextId;
    }

    private boolean isRootId(NodeId nodeId) {
        return this.rootID.equals((Object)nodeId);
    }

    private static boolean hasEntries(NodeImpl n) throws RepositoryException {
        if (ACLProvider.isAccessControlled((NodeImpl)n)) {
            NodeImpl aclNode = n.getNode(N_POLICY);
            return aclNode.hasNodes();
        }
        return false;
    }

    private void performAgainstAllInCache(CacheCallable callable) {
        Set allKeysFromRegionCache = this.cacheManager.getAllKeysFromRegionCache("SESSION");
        for (Object compositeKey : allKeysFromRegionCache) {
            Object fromRegionCache;
            String key;
            Matcher matcher = SESSION_KEY_PATTERN.matcher(compositeKey.toString());
            if (!matcher.matches() || !ENTRY_COLLECTOR.equals(key = matcher.toMatchResult().group(1)) || !EntryCache.class.isAssignableFrom((fromRegionCache = this.cacheManager.getFromRegionCache("SESSION", compositeKey)).getClass())) continue;
            callable.call((EntryCache)fromRegionCache);
        }
    }

    @Override
    public void notifyListeners(AccessControlModifications modifications) {
        for (Object key : modifications.getNodeIdentifiers()) {
            if (!(key instanceof NodeId)) {
                log.warn("Cannot process AC modificationMap entry. Keys must be NodeId.");
                continue;
            }
            final NodeId nodeId = (NodeId)key;
            int type = modifications.getType((Object)nodeId);
            if ((type & 1) == 1) {
                log.debug("Policy added, clearing the cache");
                this.performAgainstAllInCache(new CacheCallable(){

                    @Override
                    public void call(EntryCache cache) {
                        cache.clear();
                    }
                });
                break;
            }
            if ((type & 2) == 2) {
                this.performAgainstAllInCache(new CacheCallable(){

                    @Override
                    public void call(EntryCache cache) {
                        cache.remove(nodeId, true);
                    }
                });
                continue;
            }
            if ((type & 4) == 4) {
                this.performAgainstAllInCache(new CacheCallable(){

                    @Override
                    public void call(EntryCache cache) {
                        cache.remove(nodeId, false);
                    }
                });
                continue;
            }
            if ((type & 8) != 8) continue;
            log.debug("Move operation, clearing the cache");
            this.performAgainstAllInCache(new CacheCallable(){

                @Override
                public void call(EntryCache cache) {
                    cache.clear();
                }
            });
            break;
        }
        super.notifyListeners(modifications);
    }

    private class EntryCache {
        private final Map<NodeId, EntryCollector.Entries> cache;
        private EntryCollector.Entries rootEntries;
        private boolean specialCaseRoot = true;

        public EntryCache() {
            int maxsize = 5000;
            String propname = "org.apache.jackrabbit.core.security.authorization.acl.CachingEntryCollector.maxsize";
            try {
                maxsize = Integer.parseInt(System.getProperty(propname, Integer.toString(maxsize)));
            }
            catch (NumberFormatException ex) {
                log.debug("Parsing system property " + propname + " with value: " + System.getProperty(propname), (Throwable)ex);
            }
            log.info("Creating cache with max size of: " + maxsize);
            this.cache = new GrowingLRUMap(1024, maxsize);
            String propsrname = "org.apache.jackrabbit.core.security.authorization.acl.CachingEntryCollector.scroot";
            this.specialCaseRoot = Boolean.parseBoolean(System.getProperty(propsrname, "true"));
            log.info("Root is special-cased: " + this.specialCaseRoot);
        }

        public boolean specialCasesRoot() {
            return this.specialCaseRoot;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean containsKey(NodeId id) {
            if (this.specialCaseRoot && CachingPentahoEntryCollector.this.isRootId(id)) {
                return this.rootEntries != null;
            }
            Map<NodeId, EntryCollector.Entries> map = this.cache;
            synchronized (map) {
                return this.cache.containsKey(id);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            this.rootEntries = null;
            Map<NodeId, EntryCollector.Entries> map = this.cache;
            synchronized (map) {
                this.cache.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public EntryCollector.Entries get(NodeId id) {
            EntryCollector.Entries result;
            if (this.specialCaseRoot && CachingPentahoEntryCollector.this.isRootId(id)) {
                result = this.rootEntries;
            } else {
                Map<NodeId, EntryCollector.Entries> map = this.cache;
                synchronized (map) {
                    result = this.cache.get(id);
                }
            }
            if (result != null) {
                log.debug("Cache hit for nodeId {}", (Object)id);
            } else {
                log.debug("Cache miss for nodeId {}", (Object)id);
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void put(NodeId id, EntryCollector.Entries entries) {
            log.debug("Updating cache for nodeId {}", (Object)id);
            if (id.equals((Object)entries.getNextId())) {
                throw new IllegalArgumentException("Trying to update cache entry for " + id + " with a circular reference");
            }
            if (this.specialCaseRoot && CachingPentahoEntryCollector.this.isRootId(id)) {
                this.rootEntries = entries;
            } else {
                Map<NodeId, EntryCollector.Entries> map = this.cache;
                synchronized (map) {
                    this.cache.put(id, entries);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove(NodeId id, boolean adjustNextIds) {
            log.debug("Removing nodeId {} from cache", (Object)id);
            Map<NodeId, EntryCollector.Entries> map = this.cache;
            synchronized (map) {
                EntryCollector.Entries result;
                if (this.specialCaseRoot && CachingPentahoEntryCollector.this.isRootId(id)) {
                    result = this.rootEntries;
                    this.rootEntries = null;
                } else {
                    result = this.cache.remove(id);
                }
                if (adjustNextIds && result != null) {
                    NodeId nextId = result.getNextId();
                    for (EntryCollector.Entries entry : this.cache.values()) {
                        if (!id.equals((Object)entry.getNextId())) continue;
                        if (id.equals((Object)nextId)) {
                            throw new IllegalArgumentException("Trying to update cache entry for " + id + " with a circular reference");
                        }
                        entry.setNextId(nextId);
                    }
                }
            }
        }
    }

    private class FutureEntries {
        private boolean ready = false;
        private EntryCollector.Entries result = null;
        private Throwable problem = null;

        private FutureEntries() {
        }

        public synchronized EntryCollector.Entries get() throws RepositoryException {
            while (!this.ready) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.problem != null) {
                if (this.problem instanceof RepositoryException) {
                    throw new RepositoryException(this.problem);
                }
                throw new RuntimeException(this.problem);
            }
            return this.result;
        }

        public synchronized void setResult(EntryCollector.Entries e) {
            this.result = e;
            this.ready = true;
            this.notifyAll();
        }

        public synchronized void setProblem(Throwable t) {
            this.problem = t;
            this.ready = true;
            this.notifyAll();
        }
    }

    private static interface CacheCallable {
        public void call(EntryCache var1);
    }
}

