/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.repo.timeout;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicBoolean;
import org.pentaho.di.repository.RepositoryMeta;
import org.pentaho.di.ui.repo.controller.RepositoryConnectController;
import org.pentaho.di.ui.repo.dialog.RepositoryConnectionDialog;
import org.pentaho.di.ui.spoon.Spoon;

public class SessionTimeoutHandler {
    private static Class<?> PKG = SessionTimeoutHandler.class;
    private static final int STACK_ELEMENTS_TO_SKIP = 3;
    private static final String EXCEPTION_CLASS_NAME = "ClientTransportException";
    private final RepositoryConnectController repositoryConnectController;
    private final AtomicBoolean needToLogin = new AtomicBoolean(false);
    private final AtomicBoolean reinvoke = new AtomicBoolean(false);

    public SessionTimeoutHandler(RepositoryConnectController repositoryConnectController) {
        this.repositoryConnectController = repositoryConnectController;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object handle(Object objectToHandle, Throwable exception, Method method, Object[] args) throws Throwable {
        block9: {
            if (this.lookupForConnectTimeoutError(exception) && !this.calledFromThisHandler()) {
                try {
                    return method.invoke(objectToHandle, args);
                }
                catch (InvocationTargetException ex2) {
                    if (!this.lookupForConnectTimeoutError(ex2)) {
                        throw ex2.getCause();
                    }
                    this.needToLogin.set(true);
                    SessionTimeoutHandler sessionTimeoutHandler = this;
                    synchronized (sessionTimeoutHandler) {
                        if (this.needToLogin.get()) {
                            boolean result = this.showLoginScreen(this.repositoryConnectController);
                            this.needToLogin.set(false);
                            if (result) {
                                this.reinvoke.set(true);
                                return method.invoke(objectToHandle, args);
                            }
                            this.reinvoke.set(false);
                        }
                    }
                    if (!this.reinvoke.get()) break block9;
                    return method.invoke(objectToHandle, args);
                }
            }
        }
        throw exception;
    }

    boolean showLoginScreen(RepositoryConnectController repositoryConnectController) {
        RepositoryConnectionDialog loginDialog = new RepositoryConnectionDialog(this.getSpoon().getShell());
        RepositoryMeta repositoryMeta = repositoryConnectController.getConnectedRepository();
        repositoryConnectController.setRelogin(true);
        return loginDialog.createDialog(repositoryMeta.getName());
    }

    boolean lookupForConnectTimeoutError(Throwable root) {
        while (root != null) {
            if (EXCEPTION_CLASS_NAME.equals(root.getClass().getSimpleName())) {
                String errorMessage = root.getMessage();
                return errorMessage.contains("401");
            }
            root = root.getCause();
        }
        return false;
    }

    boolean calledFromThisHandler() {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        for (int i = 3; i < stackTrace.length; ++i) {
            if (!stackTrace[i].getClassName().equals(SessionTimeoutHandler.class.getCanonicalName())) continue;
            return true;
        }
        return false;
    }

    private Spoon getSpoon() {
        return Spoon.getInstance();
    }
}

