/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.repo.timeout;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.List;
import org.apache.commons.lang.ClassUtils;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.repository.IRepositoryService;
import org.pentaho.di.repository.ReconnectableRepository;
import org.pentaho.di.ui.repo.controller.RepositoryConnectController;
import org.pentaho.di.ui.repo.timeout.MetaStoreSessionTimeoutHandler;
import org.pentaho.di.ui.repo.timeout.RepositoryServiceSessionTimeoutHandler;
import org.pentaho.di.ui.repo.timeout.SessionTimeoutHandler;
import org.pentaho.metastore.api.IMetaStore;

public class RepositorySessionTimeoutHandler
implements InvocationHandler {
    private static final String CONNECT_METHOD_NAME = "connect";
    private static final String GET_META_STORE_METHOD_NAME = "getMetaStore";
    private static final String GET_SERVICE_METHOD_NAME = "getService";
    private static final int SERVICE_CLASS_ARGUMENT = 0;
    private final ReconnectableRepository repository;
    private final SessionTimeoutHandler sessionTimeoutHandler;
    private IMetaStore metaStoreInstance;

    public RepositorySessionTimeoutHandler(ReconnectableRepository repository, RepositoryConnectController repositoryConnectController) {
        this.repository = repository;
        this.sessionTimeoutHandler = new SessionTimeoutHandler(repositoryConnectController);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            String methodName = method.getName();
            if (GET_SERVICE_METHOD_NAME.equals(methodName)) {
                return this.wrapRepositoryServiceWithTimeoutHandler((Class)args[0]);
            }
            if (GET_META_STORE_METHOD_NAME.equals(methodName)) {
                return this.metaStoreInstance;
            }
            Object result = method.invoke((Object)this.repository, args);
            if (CONNECT_METHOD_NAME.equals(methodName)) {
                IMetaStore metaStore = this.repository.getMetaStore();
                this.metaStoreInstance = RepositorySessionTimeoutHandler.wrapMetastoreWithTimeoutHandler(metaStore, this.sessionTimeoutHandler);
            }
            return result;
        }
        catch (InvocationTargetException ex) {
            if (this.connectedToRepository()) {
                return this.sessionTimeoutHandler.handle(this.repository, ex.getCause(), method, args);
            }
            throw ex.getCause();
        }
    }

    boolean connectedToRepository() {
        return this.repository.isConnected();
    }

    IRepositoryService wrapRepositoryServiceWithTimeoutHandler(Class<? extends IRepositoryService> clazz) throws KettleException {
        IRepositoryService service = this.repository.getService(clazz);
        RepositoryServiceSessionTimeoutHandler timeoutHandler = new RepositoryServiceSessionTimeoutHandler(service, this.sessionTimeoutHandler);
        return RepositorySessionTimeoutHandler.wrapObjectWithTimeoutHandler(service, timeoutHandler);
    }

    static IMetaStore wrapMetastoreWithTimeoutHandler(IMetaStore metaStore, SessionTimeoutHandler sessionTimeoutHandler) {
        MetaStoreSessionTimeoutHandler metaStoreSessionTimeoutHandler = new MetaStoreSessionTimeoutHandler(metaStore, sessionTimeoutHandler);
        return RepositorySessionTimeoutHandler.wrapObjectWithTimeoutHandler(metaStore, metaStoreSessionTimeoutHandler);
    }

    static <T> T wrapObjectWithTimeoutHandler(T objectToWrap, InvocationHandler timeoutHandler) {
        List objectIntrerfaces = ClassUtils.getAllInterfaces(objectToWrap.getClass());
        Class[] objectIntrerfacesArray = objectIntrerfaces.toArray(new Class[objectIntrerfaces.size()]);
        return (T)Proxy.newProxyInstance(objectToWrap.getClass().getClassLoader(), objectIntrerfacesArray, timeoutHandler);
    }
}

