/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.repo.dialog;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.MessageBox;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.ui.core.FormDataBuilder;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.repo.controller.RepositoryConnectController;
import org.pentaho.di.ui.repo.dialog.BaseRepoFormComposite;

public class KettleDatabaseRepoFormComposite
extends BaseRepoFormComposite {
    private Combo dbListCombo;
    private Runnable dbListRefresh;
    private static final Class<?> PKG = KettleDatabaseRepoFormComposite.class;

    public KettleDatabaseRepoFormComposite(Composite parent, int style) {
        super(parent, style);
    }

    @Override
    protected Control uiAfterDisplayName() {
        PropsUI props = PropsUI.getInstance();
        Label lLoc = new Label((Composite)this, 0);
        lLoc.setText(BaseMessages.getString(PKG, (String)"repositories.create.label", (String[])new String[0]));
        lLoc.setLayoutData((Object)new FormDataBuilder().left(0, 0).right(100, 0).top((Control)this.txtDisplayName, 15).result());
        props.setLook((Control)lLoc);
        this.dbListCombo = new Combo((Composite)this, 8);
        if (!RepositoryConnectController.getInstance().getDatabases().isEmpty()) {
            ArrayList<String> listData = this.convertJSONArrayToList(RepositoryConnectController.getInstance().getDatabases());
            this.dbListCombo.setItems(listData.toArray(new String[listData.size()]));
        }
        this.dbListCombo.setLayoutData((Object)new FormDataBuilder().left(0, 0).top((Control)lLoc, 5).width(300).result());
        this.dbListCombo.addModifyListener(this.lsMod);
        props.setLook((Control)this.dbListCombo);
        Button createDbConBtn = new Button((Composite)this, 8);
        createDbConBtn.setText(BaseMessages.getString(PKG, (String)"repositories.create.label", (String[])new String[0]));
        createDbConBtn.setLayoutData((Object)new FormDataBuilder().left((Control)this.dbListCombo, 5).top((Control)lLoc, 5).result());
        props.setLook((Control)createDbConBtn);
        Button updateDbConBtn = new Button((Composite)this, 8);
        updateDbConBtn.setText(BaseMessages.getString(PKG, (String)"repositories.edit.label", (String[])new String[0]));
        updateDbConBtn.setLayoutData((Object)new FormDataBuilder().left((Control)createDbConBtn, 5).top((Control)lLoc, 5).result());
        props.setLook((Control)updateDbConBtn);
        updateDbConBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (KettleDatabaseRepoFormComposite.this.dbListCombo.getSelectionIndex() > -1) {
                    if (!Utils.isEmpty((CharSequence)KettleDatabaseRepoFormComposite.this.dbListCombo.getItem(KettleDatabaseRepoFormComposite.this.dbListCombo.getSelectionIndex()))) {
                        RepositoryConnectController.getInstance().editDatabaseConnection(KettleDatabaseRepoFormComposite.this.dbListCombo.getItem(KettleDatabaseRepoFormComposite.this.dbListCombo.getSelectionIndex()));
                    } else {
                        KettleDatabaseRepoFormComposite.this.messageBoxService(" Select a DB connection to edit!");
                    }
                } else {
                    KettleDatabaseRepoFormComposite.this.messageBoxService(" Select a DB connection to edit!");
                }
                KettleDatabaseRepoFormComposite.this.dbListRefresh.run();
            }
        });
        Button deleteDbConBtn = new Button((Composite)this, 8);
        deleteDbConBtn.setText(BaseMessages.getString(PKG, (String)"repositories.delete.label", (String[])new String[0]));
        deleteDbConBtn.setLayoutData((Object)new FormDataBuilder().left((Control)updateDbConBtn, 5).top((Control)lLoc, 5).result());
        props.setLook((Control)deleteDbConBtn);
        deleteDbConBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (KettleDatabaseRepoFormComposite.this.dbListCombo.getSelectionIndex() > -1) {
                    if (!Utils.isEmpty((CharSequence)KettleDatabaseRepoFormComposite.this.dbListCombo.getItem(KettleDatabaseRepoFormComposite.this.dbListCombo.getSelectionIndex()))) {
                        String deleteMessage = String.format("Are you sure you wish to remove the '%s' DB connection?", KettleDatabaseRepoFormComposite.this.dbListCombo.getItem(KettleDatabaseRepoFormComposite.this.dbListCombo.getSelectionIndex()));
                        MessageBox delBox = new MessageBox(KettleDatabaseRepoFormComposite.this.getParent().getShell(), 200);
                        delBox.setText(BaseMessages.getString((Class)PKG, (String)"repositories.deldbconn.label", (String[])new String[0]));
                        delBox.setMessage(deleteMessage);
                        if (64 == delBox.open()) {
                            RepositoryConnectController.getInstance().deleteDatabaseConnection(KettleDatabaseRepoFormComposite.this.dbListCombo.getItem(KettleDatabaseRepoFormComposite.this.dbListCombo.getSelectionIndex()));
                        }
                    } else {
                        KettleDatabaseRepoFormComposite.this.messageBoxService(" Select a DB connection to delete!");
                    }
                } else {
                    KettleDatabaseRepoFormComposite.this.messageBoxService(" Select a DB connection to delete!");
                }
                KettleDatabaseRepoFormComposite.this.dbListRefresh.run();
            }
        });
        createDbConBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                RepositoryConnectController.getInstance().createConnection();
                KettleDatabaseRepoFormComposite.this.dbListRefresh.run();
            }
        });
        this.dbListRefresh = () -> {
            ArrayList<String> listData = this.convertJSONArrayToList(RepositoryConnectController.getInstance().getDatabases());
            this.dbListCombo.setItems(listData.toArray(new String[listData.size()]));
        };
        return createDbConBtn;
    }

    private ArrayList<String> convertJSONArrayToList(JSONArray jsonArray) {
        ArrayList<String> listData = new ArrayList<String>();
        if (!jsonArray.isEmpty()) {
            for (int i = 0; i < jsonArray.size(); ++i) {
                listData.add(((JSONObject)jsonArray.get(i)).get((Object)"name").toString());
            }
        }
        return listData;
    }

    @Override
    public Map<String, Object> toMap() {
        Map<String, Object> ret = super.toMap();
        ret.put("id", "KettleDatabaseRepository");
        ret.put("databaseConnection", this.dbListCombo.getItem(this.dbListCombo.getSelectionIndex()));
        return ret;
    }

    @Override
    public void populate(JSONObject source) {
        super.populate(source);
        this.dbListCombo.setText((String)source.getOrDefault((Object)"databaseConnection", (Object)""));
    }

    @Override
    protected boolean validateSaveAllowed() {
        return super.validateSaveAllowed() && this.dbListCombo.getSelectionIndex() > -1 && !Utils.isEmpty((CharSequence)this.dbListCombo.getSelection().toString());
    }

    private MessageBox messageBoxService(String msgText) {
        MessageBox messageBox = new MessageBox(this.getParent().getShell(), 33);
        messageBox.setMessage(msgText);
        messageBox.open();
        return messageBox;
    }
}

