/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.repo.dialog;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.json.simple.JSONObject;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.ui.core.FormDataBuilder;
import org.pentaho.di.ui.core.PropsUI;

public abstract class BaseRepoFormComposite
extends Composite {
    protected static final int MEDIUM_WIDTH = 300;
    protected static final int LABEL_CONTROL_MARGIN = 5;
    protected static final int CONTROL_MARGIN = 15;
    protected Button btnSave;
    protected Text txtDisplayName;
    protected Text txtDescription;
    protected Button chkDefault;
    protected String originalName;
    protected PropsUI props;
    private static final Class<?> PKG = BaseRepoFormComposite.class;
    protected boolean changed = false;
    protected ModifyListener lsMod = e -> {
        this.changed = true;
        this.setSaveButtonEnabled();
    };

    protected BaseRepoFormComposite(Composite parent, int style) {
        super(parent, style);
        this.props = PropsUI.getInstance();
        this.props.setLook((Control)this);
        FormLayout layout = new FormLayout();
        this.setLayout((Layout)layout);
        Label lDispName = new Label((Composite)this, 0);
        lDispName.setText(BaseMessages.getString(PKG, (String)"repositories.displayname.label", (String[])new String[0]));
        lDispName.setLayoutData((Object)new FormDataBuilder().left(0, 0).right(100, 0).result());
        this.props.setLook((Control)lDispName);
        this.txtDisplayName = new Text((Composite)this, 2048);
        this.props.setLook((Control)this.txtDisplayName);
        this.txtDisplayName.setLayoutData((Object)new FormDataBuilder().left(0, 0).top((Control)lDispName, 5).width(300).result());
        this.txtDisplayName.addModifyListener(this.lsMod);
        Label lDescription = new Label((Composite)this, 0);
        lDescription.setText(BaseMessages.getString(PKG, (String)"repositories.description.label", (String[])new String[0]));
        lDescription.setLayoutData((Object)new FormDataBuilder().left(0, 0).right(100, 0).top(this.uiAfterDisplayName(), 15).result());
        this.props.setLook((Control)lDescription);
        this.txtDescription = new Text((Composite)this, 2562);
        this.txtDescription.setLayoutData((Object)new FormDataBuilder().left(0, 0).top((Control)lDescription, 5).width(300).height(100).result());
        this.txtDescription.addModifyListener(this.lsMod);
        this.props.setLook((Control)this.txtDescription);
        this.chkDefault = new Button((Composite)this, 32);
        this.chkDefault.setText(BaseMessages.getString(PKG, (String)"repositories.launchonstartup.label", (String[])new String[0]));
        this.chkDefault.setLayoutData((Object)new FormDataBuilder().left(0, 0).right(100, 0).top((Control)this.txtDescription, 15).result());
        this.props.setLook((Control)this.chkDefault);
        this.chkDefault.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BaseRepoFormComposite.this.lsMod.modifyText(null);
            }
        });
    }

    protected Control uiAfterDisplayName() {
        return this.txtDisplayName;
    }

    public void populate(JSONObject source) {
        String displayName = (String)source.getOrDefault((Object)"displayName", (Object)"");
        this.txtDisplayName.setText(displayName);
        this.originalName = displayName;
        this.txtDescription.setText((String)source.getOrDefault((Object)"description", (Object)""));
        this.chkDefault.setSelection(((Boolean)source.getOrDefault((Object)"isDefault", (Object)false)).booleanValue());
    }

    public void updateSaveButton(Button btnSave) {
        this.btnSave = btnSave;
        this.changed = false;
        this.setSaveButtonEnabled();
    }

    protected void setSaveButtonEnabled() {
        if (this.btnSave != null) {
            this.btnSave.setEnabled(this.changed && this.validateSaveAllowed());
        }
    }

    protected boolean validateSaveAllowed() {
        return !Utils.isEmpty((CharSequence)this.txtDisplayName.getText());
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> res = new HashMap<String, Object>();
        if (!Utils.isEmpty((CharSequence)this.originalName)) {
            res.put("originalName", this.originalName);
        }
        res.put("displayName", this.txtDisplayName.getText());
        res.put("description", this.txtDescription.getText());
        res.put("isDefault", this.chkDefault.getSelection());
        return res;
    }
}

