/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.access.AS400Message;
import com.ibm.as400.vaccess.ErrorEventSupport;
import com.ibm.as400.vaccess.ErrorListener;
import com.ibm.as400.vaccess.MessagePropertiesPane;
import com.ibm.as400.vaccess.MessageUtilities;
import com.ibm.as400.vaccess.ResourceLoader;
import com.ibm.as400.vaccess.VAction;
import com.ibm.as400.vaccess.VObject;
import com.ibm.as400.vaccess.VObjectEventSupport;
import com.ibm.as400.vaccess.VObjectListener;
import com.ibm.as400.vaccess.VPropertiesPane;
import com.ibm.as400.vaccess.WorkingEventSupport;
import com.ibm.as400.vaccess.WorkingListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import javax.swing.Icon;

public class VMessage
implements VObject,
Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private static final String description_ = ResourceLoader.getText("MESSAGE_DESCRIPTION");
    private static final Icon icon16_ = ResourceLoader.getIcon("VMessage16.gif", description_);
    private static final Icon icon32_ = ResourceLoader.getIcon("VMessage32.gif", description_);
    private AS400Message message_ = null;
    private transient VPropertiesPane propertiesPane_;
    private transient ErrorEventSupport errorEventSupport_;
    private transient VObjectEventSupport objectEventSupport_;
    private transient WorkingEventSupport workingEventSupport_;
    public static final Object ID_PROPERTY = "ID";
    public static final Object SEVERITY_PROPERTY = "Severity";
    public static final Object TEXT_PROPERTY = "Text";
    public static final Object TYPE_PROPERTY = "Type";

    VMessage(AS400Message aS400Message) {
        if (aS400Message == null) {
            throw new NullPointerException("message");
        }
        this.message_ = aS400Message;
        this.initializeTransient();
    }

    public void addErrorListener(ErrorListener errorListener) {
        this.errorEventSupport_.addErrorListener(errorListener);
    }

    public void addVObjectListener(VObjectListener vObjectListener) {
        this.objectEventSupport_.addVObjectListener(vObjectListener);
    }

    public void addWorkingListener(WorkingListener workingListener) {
        this.workingEventSupport_.addWorkingListener(workingListener);
    }

    public VAction[] getActions() {
        return null;
    }

    public VAction getDefaultAction() {
        return null;
    }

    public Icon getIcon(int n, boolean bl) {
        if (n == 32) {
            return icon32_;
        }
        return icon16_;
    }

    public VPropertiesPane getPropertiesPane() {
        return this.propertiesPane_;
    }

    public synchronized Object getPropertyValue(Object object) {
        if (object == VObject.NAME_PROPERTY) {
            return this;
        }
        if (object == VObject.DESCRIPTION_PROPERTY) {
            return description_;
        }
        if (object == ID_PROPERTY) {
            return this.message_.getID();
        }
        if (object == TEXT_PROPERTY) {
            return this.message_.getText();
        }
        if (object == SEVERITY_PROPERTY) {
            return new Integer(this.message_.getSeverity());
        }
        if (object == TYPE_PROPERTY) {
            return MessageUtilities.getTypeText(this.message_.getType());
        }
        return null;
    }

    public String getText() {
        String string = this.message_.getID();
        if (string == null) {
            return "";
        }
        return string;
    }

    private void initializeTransient() {
        this.errorEventSupport_ = new ErrorEventSupport(this);
        this.objectEventSupport_ = new VObjectEventSupport(this);
        this.workingEventSupport_ = new WorkingEventSupport(this);
        this.propertiesPane_ = new MessagePropertiesPane(this, this.message_);
        this.propertiesPane_.addErrorListener(this.errorEventSupport_);
        this.propertiesPane_.addVObjectListener(this.objectEventSupport_);
        this.propertiesPane_.addWorkingListener(this.workingEventSupport_);
    }

    public void load() {
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.initializeTransient();
    }

    public void removeErrorListener(ErrorListener errorListener) {
        this.errorEventSupport_.removeErrorListener(errorListener);
    }

    public void removeVObjectListener(VObjectListener vObjectListener) {
        this.objectEventSupport_.removeVObjectListener(vObjectListener);
    }

    public void removeWorkingListener(WorkingListener workingListener) {
        this.workingEventSupport_.removeWorkingListener(workingListener);
    }

    public String toString() {
        String string = this.message_.getID();
        if (string == null) {
            return "";
        }
        return string;
    }
}

