/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.micro;

import com.ibm.as400.access.Trace;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;

class MicroDataOutputStream {
    private static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    DataOutputStream out_;

    public MicroDataOutputStream(OutputStream outputStream) throws IOException {
        this.out_ = new DataOutputStream(outputStream);
    }

    public void flush() throws IOException {
        this.out_.flush();
    }

    public void writeBoolean(boolean bl) throws IOException {
        if (Trace.isTraceOn()) {
            Trace.log(6, Thread.currentThread().getName() + " out < " + bl);
        }
        this.out_.writeBoolean(bl);
    }

    public void writeByte(byte by) throws IOException {
        if (Trace.isTraceOn()) {
            Trace.log(6, Thread.currentThread().getName() + " out < " + by);
        }
        this.out_.writeByte(by);
    }

    public void writeBytes(byte[] byArray) throws IOException {
        if (Trace.isTraceOn()) {
            Trace.log(6, "  " + Thread.currentThread().getName() + " out < ", byArray);
        }
        this.out_.write(byArray, 0, byArray.length);
    }

    public void writeDouble(double d) throws IOException {
        if (Trace.isTraceOn()) {
            Trace.log(6, Thread.currentThread().getName() + " out < " + d);
        }
        this.out_.writeDouble(d);
    }

    public void writeFloat(float f) throws IOException {
        if (Trace.isTraceOn()) {
            Trace.log(6, Thread.currentThread().getName() + " out < " + f);
        }
        this.out_.writeFloat(f);
    }

    public void writeInt(int n) throws IOException {
        if (Trace.isTraceOn()) {
            Trace.log(6, Thread.currentThread().getName() + " out < " + Integer.toHexString(n));
        }
        this.out_.writeInt(n);
    }

    public void writeLong(long l) throws IOException {
        if (Trace.isTraceOn()) {
            Trace.log(6, Thread.currentThread().getName() + " out < " + l);
        }
        this.out_.writeLong(l);
    }

    public void writeShort(short s) throws IOException {
        if (Trace.isTraceOn()) {
            Trace.log(6, Thread.currentThread().getName() + " out < " + s);
        }
        this.out_.writeShort(s);
    }

    public void writeString(String string) throws IOException {
        this.writeUTF(string);
    }

    public void writeUTF(String string) throws IOException {
        if (Trace.isTraceOn()) {
            Trace.log(6, Thread.currentThread().getName() + " out < " + string);
        }
        this.out_.writeUTF(string);
    }
}

