/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.step.mqtt;

import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.step.mqtt.MQTTConsumerMeta;
import org.pentaho.di.trans.step.mqtt.MQTTStreamSource;
import org.pentaho.di.trans.streaming.common.BaseStreamStep;
import org.pentaho.di.trans.streaming.common.FixedTimeStreamWindow;

public class MQTTConsumer
extends BaseStreamStep
implements StepInterface {
    private static final Class<?> PKG = MQTTConsumer.class;

    public MQTTConsumer(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public boolean init(StepMetaInterface stepMetaInterface, StepDataInterface stepDataInterface) {
        boolean init = super.init(stepMetaInterface, stepDataInterface);
        MQTTConsumerMeta mqttConsumerMeta = (MQTTConsumerMeta)this.variablizedStepMeta;
        try {
            RowMeta rowMeta = mqttConsumerMeta.getRowMeta(this.getStepname(), (VariableSpace)this);
            this.window = new FixedTimeStreamWindow(this.getSubtransExecutor(), (RowMetaInterface)rowMeta, this.getDuration(), this.getBatchSize(), this.getParallelism());
            this.source = new MQTTStreamSource(mqttConsumerMeta, this);
        }
        catch (Exception e) {
            this.getLogChannel().logError(BaseMessages.getString(PKG, (String)"MQTTInput.Error.FailureGettingFields", (String[])new String[0]), (Throwable)e);
            init = false;
        }
        return init;
    }
}

