/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.support.encryption;

import java.math.BigInteger;
import java.util.ArrayList;
import org.pentaho.di.core.encryption.TwoWayPasswordEncoderInterface;
import org.pentaho.support.encryption.PasswordEncoderException;
import org.pentaho.support.utils.StringUtil;

public class KettleTwoWayPasswordEncoder
implements TwoWayPasswordEncoderInterface {
    private static final KettleTwoWayPasswordEncoder instance = new KettleTwoWayPasswordEncoder();
    private static final int RADIX = 16;
    private String Seed;
    public static final String PASSWORD_ENCRYPTED_PREFIX = "Encrypted ";

    public KettleTwoWayPasswordEncoder() {
        String envSeed;
        this.Seed = envSeed = System.getProperty("KETTLE_TWO_WAY_PASSWORD_ENCODER_SEED", "0933910847463829827159347601486730416058");
    }

    @Override
    public void init() throws PasswordEncoderException {
    }

    @Override
    public String encode(String rawPassword) {
        return this.encode(rawPassword, true);
    }

    @Override
    public String encode(String rawPassword, boolean includePrefix) {
        if (includePrefix) {
            return this.encryptPasswordIfNotUsingVariablesInternal(rawPassword);
        }
        return this.encryptPasswordInternal(rawPassword);
    }

    @Override
    public String decode(String encodedPassword) {
        if (encodedPassword != null && encodedPassword.startsWith(PASSWORD_ENCRYPTED_PREFIX)) {
            encodedPassword = encodedPassword.substring(PASSWORD_ENCRYPTED_PREFIX.length());
        }
        return this.decryptPasswordInternal(encodedPassword);
    }

    @Override
    public String decode(String encodedPassword, boolean optionallyEncrypted) {
        if (encodedPassword == null) {
            return null;
        }
        if (optionallyEncrypted) {
            if (encodedPassword.startsWith(PASSWORD_ENCRYPTED_PREFIX)) {
                encodedPassword = encodedPassword.substring(PASSWORD_ENCRYPTED_PREFIX.length());
                return this.decryptPasswordInternal(encodedPassword);
            }
            return encodedPassword;
        }
        return this.decryptPasswordInternal(encodedPassword);
    }

    protected String encryptPasswordInternal(String password) {
        if (password == null) {
            return "";
        }
        if (password.length() == 0) {
            return "";
        }
        BigInteger bi_passwd = new BigInteger(password.getBytes());
        BigInteger bi_r0 = new BigInteger(this.getSeed());
        BigInteger bi_r1 = bi_r0.xor(bi_passwd);
        return bi_r1.toString(16);
    }

    protected String decryptPasswordInternal(String encrypted) {
        if (encrypted == null) {
            return "";
        }
        if (encrypted.length() == 0) {
            return "";
        }
        BigInteger bi_confuse = new BigInteger(this.getSeed());
        try {
            BigInteger bi_r1 = new BigInteger(encrypted, 16);
            BigInteger bi_r0 = bi_r1.xor(bi_confuse);
            return new String(bi_r0.toByteArray());
        }
        catch (Exception e) {
            return "";
        }
    }

    protected String getSeed() {
        return this.Seed;
    }

    @Override
    public String[] getPrefixes() {
        return new String[]{PASSWORD_ENCRYPTED_PREFIX};
    }

    protected final String encryptPasswordIfNotUsingVariablesInternal(String password) {
        String encrPassword = "";
        ArrayList<String> varList = new ArrayList<String>();
        StringUtil.getUsedVariables(password, varList, true);
        encrPassword = varList.isEmpty() ? PASSWORD_ENCRYPTED_PREFIX + this.encryptPasswordInternal(password) : password;
        return encrPassword;
    }

    protected final String decryptPasswordOptionallyEncryptedInternal(String password) {
        if (!StringUtil.isEmpty(password) && password.startsWith(PASSWORD_ENCRYPTED_PREFIX)) {
            return this.decryptPasswordInternal(password.substring(PASSWORD_ENCRYPTED_PREFIX.length()));
        }
        return password;
    }
}

