/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.exceloutput;

import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Locale;
import jxl.Cell;
import jxl.Sheet;
import jxl.Workbook;
import jxl.WorkbookSettings;
import jxl.biff.DisplayFormat;
import jxl.biff.StringHelper;
import jxl.format.CellFormat;
import jxl.format.Colour;
import jxl.format.UnderlineStyle;
import jxl.read.biff.BiffException;
import jxl.write.DateFormat;
import jxl.write.DateFormats;
import jxl.write.DateTime;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.NumberFormat;
import jxl.write.WritableCell;
import jxl.write.WritableCellFormat;
import jxl.write.WritableFont;
import jxl.write.WritableImage;
import org.apache.commons.vfs2.FileObject;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.ResultFile;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.exceloutput.ExcelField;
import org.pentaho.di.trans.steps.exceloutput.ExcelFontMap;
import org.pentaho.di.trans.steps.exceloutput.ExcelOutputData;
import org.pentaho.di.trans.steps.exceloutput.ExcelOutputMeta;

public class ExcelOutput
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = ExcelOutputMeta.class;
    private ExcelOutputMeta meta;
    private ExcelOutputData data;

    public ExcelOutput(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        boolean splitFile;
        this.meta = (ExcelOutputMeta)smi;
        this.data = (ExcelOutputData)sdi;
        Object[] r = this.getRow();
        if (this.first && r != null) {
            this.data.previousMeta = this.getInputRowMeta().clone();
            if (this.meta.isAutoSizeColumns()) {
                this.data.fieldsWidth = this.meta.getOutputFields() != null && this.meta.getOutputFields().length > 0 ? new int[this.meta.getOutputFields().length] : new int[this.data.previousMeta.size()];
            }
            if (this.meta.isDoNotOpenNewFileInit() && !this.openNewFile()) {
                this.logError("Couldn't open file " + this.buildFilename());
                return false;
            }
            this.data.oneFileOpened = true;
            if (this.meta.isHeaderEnabled() && !this.data.headerWrote) {
                this.writeHeader();
                this.data.headerWrote = true;
            }
        }
        boolean bl = splitFile = this.meta.getSplitEvery() > 0 && this.getLinesOutput() % (long)this.meta.getSplitEvery() == 0L;
        if (this.getLinesOutput() > 0L && splitFile && r != null) {
            if (this.data.oneFileOpened) {
                this.closeFile();
            }
            if (!this.openNewFile()) {
                this.logError("Unable to open new file (split #" + this.data.splitnr + "...");
                this.setErrors(1L);
                return false;
            }
            if (this.meta.isHeaderEnabled() && !this.data.headerWrote) {
                this.writeHeader();
                this.data.headerWrote = true;
            }
        }
        if (r == null) {
            this.setOutputDone();
            return false;
        }
        boolean result = this.writeRowToFile(r);
        if (!result) {
            this.setErrors(1L);
            this.stopAll();
            return false;
        }
        this.putRow(this.data.previousMeta, r);
        if (this.checkFeedback(this.getLinesOutput()) && this.log.isBasic()) {
            this.logBasic("linenr " + this.getLinesOutput());
        }
        return result;
    }

    private boolean writeRowToFile(Object[] r) {
        try {
            int i;
            if (this.first) {
                this.first = false;
                this.data.fieldnrs = new int[this.meta.getOutputFields().length];
                for (i = 0; i < this.meta.getOutputFields().length; ++i) {
                    this.data.fieldnrs[i] = this.data.previousMeta.indexOfValue(this.meta.getOutputFields()[i].getName());
                    if (this.data.fieldnrs[i] >= 0) continue;
                    this.logError("Field [" + this.meta.getOutputFields()[i].getName() + "] couldn't be found in the input stream!");
                    this.setErrors(1L);
                    this.stopAll();
                    return false;
                }
            }
            if (this.meta.getOutputFields() == null || this.meta.getOutputFields().length == 0) {
                for (i = 0; i < this.data.previousMeta.size(); ++i) {
                    Object v = r[i];
                    if (this.writeField(v, this.data.previousMeta.getValueMeta(i), null, i)) continue;
                    return false;
                }
                this.data.positionX = 0;
                ++this.data.positionY;
            } else {
                for (i = 0; i < this.meta.getOutputFields().length; ++i) {
                    Object v = r[this.data.fieldnrs[i]];
                    if (this.writeField(v, this.data.previousMeta.getValueMeta(this.data.fieldnrs[i]), this.meta.getOutputFields()[i], i)) continue;
                    return false;
                }
                this.data.positionX = 0;
                ++this.data.positionY;
            }
        }
        catch (Exception e) {
            this.logError("Error writing line :" + e.toString());
            return false;
        }
        this.incrementLinesOutput();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean createParentFolder(FileObject file) {
        boolean retval = true;
        FileObject parentfolder = null;
        try {
            parentfolder = file.getParent();
            if (parentfolder.exists()) {
                if (this.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"ExcelOutput.Log.ParentFolderExist", (String[])new String[]{parentfolder.getName().toString()}));
                }
            } else {
                if (this.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"ExcelOutput.Log.ParentFolderNotExist", (String[])new String[]{parentfolder.getName().toString()}));
                }
                if (this.meta.isCreateParentFolder()) {
                    parentfolder.createFolder();
                    if (this.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"ExcelOutput.Log.ParentFolderCreated", (String[])new String[]{parentfolder.getName().toString()}));
                    }
                } else {
                    retval = false;
                    this.logError(BaseMessages.getString(PKG, (String)"ExcelOutput.Error.CanNotFoundParentFolder", (String[])new String[]{parentfolder.getName().toString(), file.getName().toString()}));
                }
            }
        }
        catch (Exception e) {
            retval = false;
            this.logError(BaseMessages.getString(PKG, (String)"ExcelOutput.Log.CouldNotCreateParentFolder", (String[])new String[]{parentfolder.getName().toString()}));
        }
        finally {
            if (parentfolder != null) {
                try {
                    parentfolder.close();
                }
                catch (Exception exception) {}
            }
        }
        return retval;
    }

    private boolean writeField(Object v, ValueMetaInterface vMeta, ExcelField excelField, int column) {
        return this.writeField(v, vMeta, excelField, column, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean writeField(Object v, ValueMetaInterface vMeta, ExcelField excelField, int column, boolean isHeader) {
        try {
            WritableCellFormat cellFormat;
            String hashName = vMeta.getName();
            if (isHeader) {
                hashName = "____header_field____";
            }
            if ((cellFormat = this.data.formats.get(hashName)) == null && this.meta.isTemplateEnabled() && !isHeader) {
                try {
                    CellFormat format;
                    if (column < this.data.templateColumns && (format = this.data.sheet.getColumnView(column).getFormat()) != null) {
                        cellFormat = new WritableCellFormat(format);
                        this.data.formats.put(hashName, cellFormat);
                    }
                }
                catch (RuntimeException format) {
                    // empty catch block
                }
            }
            if (this.meta.isAutoSizeColumns()) {
                int vlen = vMeta.getName().length();
                if (!isHeader && v != null) {
                    vlen = v.toString().trim().length();
                }
                if (vlen > 0 && vlen > this.data.fieldsWidth[column]) {
                    this.data.fieldsWidth[column] = vlen + 1;
                }
            }
            if (isHeader) {
                int rowNumber = this.data.sheet.getColumn(this.data.positionX).length;
                this.data.sheet.addCell((WritableCell)new Label(this.data.positionX, rowNumber, vMeta.getName(), (CellFormat)this.data.headerCellFormat));
                if (cellFormat != null) return true;
                this.data.formats.put(hashName, this.data.headerCellFormat);
                return true;
            }
            this.data.positionY = this.data.sheet.getColumn(this.data.positionX).length;
            switch (vMeta.getType()) {
                case 3: {
                    if (v != null && vMeta.getDate(v) != null) {
                        if (cellFormat == null) {
                            if (excelField != null && excelField.getFormat() != null) {
                                DateFormat dateFormat = new DateFormat(excelField.getFormat());
                                if (this.data.writableFont != null) {
                                    cellFormat = new WritableCellFormat(this.data.writableFont, (DisplayFormat)dateFormat);
                                    if (this.data.rowFontBackgoundColour != null) {
                                        cellFormat.setBackground(this.data.rowFontBackgoundColour);
                                    }
                                } else {
                                    cellFormat = new WritableCellFormat((DisplayFormat)dateFormat);
                                }
                            } else if (this.data.writableFont != null) {
                                cellFormat = new WritableCellFormat(this.data.writableFont, DateFormats.FORMAT9);
                                if (this.data.rowFontBackgoundColour != null) {
                                    cellFormat.setBackground(this.data.rowFontBackgoundColour);
                                }
                            } else {
                                cellFormat = new WritableCellFormat(DateFormats.FORMAT9);
                            }
                            this.data.formats.put(hashName, cellFormat);
                        }
                        DateTime dateTime = new DateTime(this.data.positionX, this.data.positionY, vMeta.getDate(v), (CellFormat)cellFormat);
                        this.data.sheet.addCell((WritableCell)dateTime);
                        return true;
                    } else {
                        if (this.meta.isNullBlank()) return true;
                        this.data.sheet.addCell((WritableCell)new Label(this.data.positionX, this.data.positionY, ""));
                        return true;
                    }
                }
                default: {
                    if (cellFormat == null) {
                        cellFormat = new WritableCellFormat(this.data.writableFont);
                        if (this.data.rowFontBackgoundColour != null) {
                            cellFormat.setBackground(this.data.rowFontBackgoundColour);
                        }
                        this.data.formats.put(hashName, cellFormat);
                    }
                    if (v != null) {
                        Label label = new Label(this.data.positionX, this.data.positionY, vMeta.getString(v), (CellFormat)cellFormat);
                        this.data.sheet.addCell((WritableCell)label);
                        return true;
                    } else {
                        if (this.meta.isNullBlank()) return true;
                        this.data.sheet.addCell((WritableCell)new Label(this.data.positionX, this.data.positionY, ""));
                        return true;
                    }
                }
                case 1: 
                case 5: 
                case 6: {
                    if (v != null) {
                        if (cellFormat == null) {
                            String format = excelField != null && excelField.getFormat() != null ? excelField.getFormat() : "###,###.00";
                            NumberFormat numberFormat = new NumberFormat(format);
                            if (this.data.writableFont != null) {
                                cellFormat = new WritableCellFormat(this.data.writableFont, (DisplayFormat)numberFormat);
                                if (this.data.rowFontBackgoundColour != null) {
                                    cellFormat.setBackground(this.data.rowFontBackgoundColour);
                                }
                            } else {
                                cellFormat = new WritableCellFormat((DisplayFormat)numberFormat);
                            }
                            this.data.formats.put(vMeta.getName(), cellFormat);
                        }
                        Number number = new Number(this.data.positionX, this.data.positionY, vMeta.getNumber(v).doubleValue(), (CellFormat)cellFormat);
                        this.data.sheet.addCell((WritableCell)number);
                        return true;
                    } else {
                        if (this.meta.isNullBlank()) return true;
                        this.data.sheet.addCell((WritableCell)new Label(this.data.positionX, this.data.positionY, ""));
                    }
                    return true;
                }
            }
        }
        catch (Exception e) {
            this.logError("Error writing field (" + this.data.positionX + "," + this.data.positionY + ") : " + e.toString());
            this.logError(Const.getStackTracker((Throwable)e));
            boolean bl = false;
            return bl;
        }
        finally {
            ++this.data.positionX;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean writeHeader() {
        boolean retval = false;
        try {
            if (this.meta.getOutputFields() != null && this.meta.getOutputFields().length > 0) {
                for (int i = 0; i < this.meta.getOutputFields().length; ++i) {
                    String fieldName = this.meta.getOutputFields()[i].getName();
                    ValueMetaString vMeta = new ValueMetaString(fieldName);
                    this.writeField(fieldName, (ValueMetaInterface)vMeta, null, i, true);
                }
            } else if (this.data.previousMeta != null) {
                for (int i = 0; i < this.data.previousMeta.size(); ++i) {
                    String fieldName = this.data.previousMeta.getFieldNames()[i];
                    ValueMetaString vMeta = new ValueMetaString(fieldName);
                    this.writeField(fieldName, (ValueMetaInterface)vMeta, null, i, true);
                }
            }
        }
        catch (Exception e) {
            this.logError("Error writing header line: " + e.toString());
            this.logError(Const.getStackTracker((Throwable)e));
            retval = true;
        }
        finally {
            this.data.positionX = 0;
            ++this.data.positionY;
        }
        return retval;
    }

    public String buildFilename() {
        return this.meta.buildFilename((VariableSpace)this, this.getCopy(), this.data.splitnr);
    }

    public boolean openNewFile() {
        boolean retval = false;
        try {
            this.data.realFilename = this.buildFilename();
            this.data.file = KettleVFS.getFileObject((String)this.data.realFilename, (VariableSpace)this.getTransMeta());
            if (this.meta.isCreateParentFolder() && !this.createParentFolder(this.data.file)) {
                return retval;
            }
            this.data.realFilename = KettleVFS.getFilename((FileObject)this.data.file);
            this.addFilenameToResult();
            if (this.log.isDebug()) {
                this.logDebug(BaseMessages.getString(PKG, (String)"ExcelOutput.Log.OpeningFile", (String[])new String[]{this.data.realFilename}));
            }
            String sheetName = "Sheet1";
            if (!Utils.isEmpty((CharSequence)this.data.realSheetname)) {
                sheetName = this.data.realSheetname;
            }
            File targetFile = new File(KettleVFS.getFilename((FileObject)this.data.file));
            if (!this.meta.isTemplateEnabled()) {
                if (this.meta.isAppend() && targetFile.exists()) {
                    Workbook targetFileWorkbook = Workbook.getWorkbook((File)targetFile);
                    this.data.workbook = Workbook.createWorkbook((File)targetFile, (Workbook)targetFileWorkbook);
                    this.meta.setHeaderEnabled(false);
                } else {
                    this.data.outputStream = KettleVFS.getOutputStream((FileObject)this.data.file, (boolean)false);
                    this.data.workbook = Workbook.createWorkbook((OutputStream)this.data.outputStream, (WorkbookSettings)this.data.ws);
                }
                this.data.sheet = this.data.workbook.getSheet(sheetName);
                if (null == this.data.sheet) {
                    this.data.sheet = this.data.workbook.createSheet(sheetName, this.data.workbook.getNumberOfSheets());
                    this.meta.setHeaderEnabled(true);
                }
            } else {
                String templateFilename = this.environmentSubstitute(this.meta.getTemplateFileName());
                try (FileObject templateFile = KettleVFS.getFileObject((String)templateFilename, (VariableSpace)this.getTransMeta());){
                    Workbook templateWorkbook = Workbook.getWorkbook((InputStream)KettleVFS.getInputStream((FileObject)templateFile), (WorkbookSettings)this.data.ws);
                    if (this.meta.isAppend() && targetFile.exists() && this.isTemplateContained(templateWorkbook, targetFile)) {
                        Workbook targetFileWorkbook = Workbook.getWorkbook((File)targetFile);
                        this.data.workbook = Workbook.createWorkbook((File)targetFile, (Workbook)targetFileWorkbook);
                        this.meta.setHeaderEnabled(false);
                    } else {
                        this.data.outputStream = KettleVFS.getOutputStream((FileObject)this.data.file, (boolean)false);
                        this.data.workbook = Workbook.createWorkbook((OutputStream)this.data.outputStream, (Workbook)templateWorkbook);
                    }
                    this.data.sheet = this.data.workbook.getSheet(sheetName);
                    if (null == this.data.sheet) {
                        this.logError("WorkSheet Name is null or different from that of Template WorkSheet Name");
                        this.data.workbook.copySheet(0, sheetName, this.data.workbook.getNumberOfSheets());
                        this.data.sheet = this.data.workbook.getSheet(sheetName);
                        this.meta.setHeaderEnabled(true);
                    }
                }
            }
            if (this.meta.isSheetProtected()) {
                this.data.sheet.getSettings().setProtected(true);
                String realPassword = Utils.resolvePassword((VariableSpace)this.variables, (String)this.meta.getPassword());
                this.data.sheet.getSettings().setPassword(realPassword);
            }
            this.data.positionX = 0;
            this.data.positionY = this.meta.isTemplateEnabled() && this.meta.isTemplateAppend() ? this.data.sheet.getColumn(this.data.positionX).length : 0;
            if (this.data.headerImage != null) {
                this.data.sheet.addImage(this.data.headerImage);
                this.data.positionY = (int)((long)this.data.positionY + Math.round(this.data.headerImageHeight));
            }
            if (this.data.Headerrowheight > 0 && this.data.Headerrowheight != 255) {
                this.data.sheet.setRowView(this.data.positionY, this.data.Headerrowheight);
            }
            try {
                this.setFonts();
            }
            catch (Exception we) {
                this.logError("Error preparing fonts, colors for header and rows: " + we.toString());
                return retval;
            }
            this.data.headerWrote = false;
            ++this.data.splitnr;
            this.data.oneFileOpened = true;
            if (this.log.isDebug()) {
                this.logDebug(BaseMessages.getString(PKG, (String)"ExcelOutput.Log.FileOpened", (String[])new String[]{this.data.file.toString()}));
            }
            retval = true;
        }
        catch (Exception e) {
            this.logError("Error opening new file", e);
            this.setErrors(1L);
        }
        return retval;
    }

    private boolean isTemplateContained(Workbook templateWorkbook, File targetFile) throws IOException, BiffException {
        int targetWorkbookNumberOfSheets;
        Workbook targetFileWorkbook = Workbook.getWorkbook((File)targetFile);
        int templateWorkbookNumberOfSheets = templateWorkbook.getNumberOfSheets();
        if (templateWorkbookNumberOfSheets > (targetWorkbookNumberOfSheets = targetFileWorkbook.getNumberOfSheets())) {
            return false;
        }
        for (int worksheetNumber = 0; worksheetNumber < templateWorkbookNumberOfSheets; ++worksheetNumber) {
            int targetWorkbookSheetRows;
            int targetWorkbookSheetColumns;
            Sheet templateWorkbookSheet = templateWorkbook.getSheet(worksheetNumber);
            Sheet targetWorkbookSheet = targetFileWorkbook.getSheet(worksheetNumber);
            int templateWorkbookSheetColumns = templateWorkbookSheet.getColumns();
            if (templateWorkbookSheetColumns > (targetWorkbookSheetColumns = targetWorkbookSheet.getColumns())) {
                return false;
            }
            int templateWorkbookSheetRows = templateWorkbookSheet.getRows();
            if (templateWorkbookSheetRows > (targetWorkbookSheetRows = targetWorkbookSheet.getRows())) {
                return false;
            }
            for (int currentRowNumber = 0; currentRowNumber < templateWorkbookSheetRows; ++currentRowNumber) {
                Cell[] targetWorkbookSheetRow;
                Cell[] templateWorkbookSheetRow = templateWorkbookSheet.getRow(currentRowNumber);
                if (templateWorkbookSheetRow.length > (targetWorkbookSheetRow = targetWorkbookSheet.getRow(currentRowNumber)).length) {
                    return false;
                }
                for (int currentCellNumber = 0; currentCellNumber < templateWorkbookSheetRow.length; ++currentCellNumber) {
                    Cell templateWorksheetCell = templateWorkbookSheetRow[currentCellNumber];
                    Cell targetWorksheetCell = targetWorkbookSheetRow[currentCellNumber];
                    if (templateWorksheetCell.getContents().equals(targetWorksheetCell.getContents())) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private boolean closeFile() {
        boolean retval = false;
        String filename = null;
        try {
            if (this.meta.isFooterEnabled()) {
                this.writeHeader();
            }
            if (this.data.workbook != null) {
                if (this.data.fieldsWidth != null) {
                    if (this.meta.isAutoSizeColumns()) {
                        int nrfields = this.data.fieldsWidth.length;
                        for (int i = 0; i < nrfields; ++i) {
                            this.data.sheet.setColumnView(i, this.data.fieldsWidth[i]);
                        }
                    }
                    this.data.fieldsWidth = null;
                }
                this.data.ws.setWriteAccess(this.reEncodeWriteAccessIfNecessary(this.data.ws.getWriteAccess()));
                this.data.workbook.write();
                this.data.workbook.close();
                this.data.workbook = null;
                if (this.data.outputStream != null) {
                    this.data.outputStream.close();
                    this.data.outputStream = null;
                }
                if (this.data.sheet != null) {
                    this.data.sheet = null;
                }
                if (this.data.file != null) {
                    filename = this.data.file.toString();
                    this.data.file.close();
                    this.data.file = null;
                }
            }
            this.data.formats.clear();
            if (this.log.isDebug()) {
                this.logDebug(BaseMessages.getString(PKG, (String)"ExcelOutput.Log.FileClosed", (String[])new String[]{filename}));
            }
            retval = true;
            this.data.oneFileOpened = false;
        }
        catch (Exception e) {
            this.logError("Unable to close openFile file : " + this.data.file.toString(), e);
            this.setErrors(1L);
        }
        return retval;
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (ExcelOutputMeta)smi;
        this.data = (ExcelOutputData)sdi;
        if (super.init(smi, sdi)) {
            this.data.splitnr = 0;
            this.data.realSheetname = this.environmentSubstitute(this.meta.getSheetname());
            this.data.ws = new WorkbookSettings();
            if (this.meta.isUseTempFiles()) {
                this.data.ws.setUseTemporaryFileDuringWrite(true);
                String realdir = this.environmentSubstitute(this.meta.getTempDirectory());
                if (!Utils.isEmpty((CharSequence)realdir)) {
                    File file = new File(realdir);
                    if (!file.exists()) {
                        this.logError(BaseMessages.getString(PKG, (String)"ExcelInputLog.TempDirectoryNotExist", (String[])new String[]{realdir}));
                        return false;
                    }
                    this.data.ws.setTemporaryFileDuringWriteDirectory(file);
                }
            }
            this.data.ws.setLocale(Locale.getDefault());
            this.data.Headerrowheight = Const.toInt((String)this.environmentSubstitute(this.meta.getHeaderRowHeight()), (int)-1);
            this.data.realHeaderImage = this.environmentSubstitute(this.meta.getHeaderImage());
            if (!Utils.isEmpty((CharSequence)this.meta.getEncoding())) {
                this.data.ws.setEncoding(this.meta.getEncoding());
            }
            if (!this.meta.isDoNotOpenNewFileInit()) {
                this.data.oneFileOpened = true;
                if (this.openNewFile()) {
                    return true;
                }
                this.logError("Couldn't open file " + this.meta.getFileName());
                this.setErrors(1L);
                this.stopAll();
            } else {
                return true;
            }
        }
        return false;
    }

    private void addFilenameToResult() throws KettleException {
        try {
            if (this.meta.isAddToResultFiles()) {
                ResultFile resultFile = new ResultFile(0, this.data.file, this.getTransMeta().getName(), this.getStepname());
                resultFile.setComment("This file was created with an Excel output step by Pentaho Data Integration");
                this.addResultFile(resultFile);
            }
        }
        catch (Exception e) {
            throw new KettleException("Unable to add filename to the result", (Throwable)e);
        }
    }

    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (ExcelOutputMeta)smi;
        this.data = (ExcelOutputData)sdi;
        if (this.data.oneFileOpened) {
            this.closeFile();
        }
        if (this.data.file != null) {
            try {
                this.data.file.close();
                this.data.file = null;
            }
            catch (Exception e) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"ExcelOutput.Log.UnableToCloseFileDuringDispose", (String[])new String[]{this.data.file.getPublicURIString()}), new Object[]{e});
            }
        }
        this.data.fieldsWidth = null;
        this.data.headerImage = null;
        this.data.writableFont = null;
        this.data.ws = null;
        super.dispose(smi, sdi);
    }

    private void setFonts() throws Exception {
        int headerFontSize = Const.toInt((String)this.environmentSubstitute(this.meta.getHeaderFontSize()), (int)10);
        WritableFont.FontName headerFontName = ExcelFontMap.getFontName(this.meta.getHeaderFontName());
        UnderlineStyle underline = ExcelFontMap.getUnderlineStyle(this.meta.getHeaderFontUnderline());
        WritableFont writableHeaderFont = null;
        writableHeaderFont = this.meta.isHeaderFontBold() ? new WritableFont(headerFontName, headerFontSize, WritableFont.BOLD, this.meta.isHeaderFontItalic(), underline) : new WritableFont(headerFontName, headerFontSize, WritableFont.NO_BOLD, this.meta.isHeaderFontItalic(), underline);
        Colour fontHeaderColour = ExcelFontMap.getColour(this.meta.getHeaderFontColor(), Colour.BLACK);
        if (!fontHeaderColour.equals(Colour.BLACK)) {
            writableHeaderFont.setColour(fontHeaderColour);
        }
        this.data.headerCellFormat = new WritableCellFormat(writableHeaderFont);
        if (this.meta.getHeaderBackGroundColor() != 0) {
            this.data.headerCellFormat.setBackground(ExcelFontMap.getColour(this.meta.getHeaderBackGroundColor(), null));
        }
        this.data.headerCellFormat = ExcelFontMap.getAlignment(this.meta.getHeaderAlignment(), this.data.headerCellFormat);
        this.data.headerCellFormat = ExcelFontMap.getOrientation(this.meta.getHeaderFontOrientation(), this.data.headerCellFormat);
        if (!Utils.isEmpty((CharSequence)this.data.realHeaderImage)) {
            InputStream imageStream = null;
            try (FileObject imageFile = KettleVFS.getFileObject((String)this.data.realHeaderImage);){
                if (!imageFile.exists()) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"ExcelInputLog.ImageFileNotExists", (String[])new String[]{this.data.realHeaderImage}));
                }
                this.data.realHeaderImage = KettleVFS.getFilename((FileObject)imageFile);
                Dimension m = ExcelFontMap.getImageDimension(this.data.realHeaderImage);
                this.data.headerImageWidth = m.getWidth() * 0.016;
                this.data.headerImageHeight = m.getHeight() * 0.0625;
                byte[] imageData = new byte[(int)imageFile.getContent().getSize()];
                imageStream = KettleVFS.getInputStream((FileObject)imageFile);
                imageStream.read(imageData);
                this.data.headerImage = new WritableImage(0.0, 0.0, this.data.headerImageWidth, this.data.headerImageHeight, imageData);
            }
            catch (Exception e) {
                throw new KettleException((Throwable)e);
            }
        }
        int rowFontSize = Const.toInt((String)this.environmentSubstitute(this.meta.getRowFontSize()), (int)10);
        WritableFont.FontName rowFontName = ExcelFontMap.getFontName(this.meta.getRowFontName());
        this.data.writableFont = new WritableFont(rowFontName, rowFontSize, WritableFont.NO_BOLD, false, UnderlineStyle.NO_UNDERLINE);
        Colour rowFontColour = ExcelFontMap.getColour(this.meta.getRowFontColor(), Colour.BLACK);
        if (!fontHeaderColour.equals(Colour.BLACK)) {
            this.data.writableFont.setColour(rowFontColour);
        }
        if (this.meta.getRowBackGroundColor() != 0) {
            this.data.rowFontBackgoundColour = ExcelFontMap.getColour(this.meta.getRowBackGroundColor(), null);
        }
    }

    private String reEncodeWriteAccessIfNecessary(String writeAccess) {
        if (writeAccess == null || writeAccess.length() == 0) {
            return writeAccess;
        }
        byte[] data = new byte[112];
        try {
            StringHelper.getBytes((String)writeAccess, (byte[])data, (int)0);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            try {
                return new String(writeAccess.getBytes("UnicodeLittle"), System.getProperty("file.encoding")).substring(2);
            }
            catch (UnsupportedEncodingException e1) {
                this.logError(Const.getStackTracker((Throwable)e));
            }
        }
        return writeAccess;
    }
}

