/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.common;

import java.io.PrintWriter;
import java.lang.reflect.Executable;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Log;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.ucp.ConnectionAffinityCallback;
import oracle.ucp.ConnectionFactoryAdapter;
import oracle.ucp.ConnectionLabelingCallback;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.UniversalConnectionPool;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.UniversalConnectionPoolLifeCycleState;
import oracle.ucp.UniversalConnectionPoolStatistics;
import oracle.ucp.UniversalPooledConnection;
import oracle.ucp.admin.UniversalConnectionPoolManagerBase;
import oracle.ucp.common.AbandonedConnectionTimerTask;
import oracle.ucp.common.Clock;
import oracle.ucp.common.ConnectionHarvestingTimerTask;
import oracle.ucp.common.ConnectionSource;
import oracle.ucp.common.Core;
import oracle.ucp.common.Counter;
import oracle.ucp.common.FailoverEvent;
import oracle.ucp.common.FailoverEventHandlerTask;
import oracle.ucp.common.Failoverable;
import oracle.ucp.common.Limits;
import oracle.ucp.common.PeakIntegerCounter;
import oracle.ucp.common.PeakLongCounter;
import oracle.ucp.common.TimeToLiveConnectionTimerTask;
import oracle.ucp.common.Topology;
import oracle.ucp.logging.ClioSupport;
import oracle.ucp.util.TimerHandle;
import oracle.ucp.util.UCPErrorHandler;
import oracle.ucp.util.UCPTaskBase;
import oracle.ucp.util.UCPTimerTaskImpl;
import oracle.ucp.util.UniqueIdentifier;

@DefaultLogger(value="oracle.ucp.common")
@Supports(value={Feature.CHECK_IN, Feature.CHECK_OUT})
public abstract class UniversalConnectionPoolBase
implements UniversalConnectionPool,
Failoverable {
    public static final int DEFAULT_INITIAL_POOL_SIZE = 0;
    public static final int DEFAULT_MIN_POOL_SIZE = 0;
    public static final int DEFAULT_MAX_POOL_SIZE = Integer.MAX_VALUE;
    public static final int DEFAULT_MAX_CONNECTIONS_PER_SERVICE = Integer.MAX_VALUE;
    public static final int DEFAULT_INACTIVE_CONNECTION_TIMEOUT = 0;
    public static final int DEFAULT_TIMEOUT_CHECK_INTERVAL = 30;
    public static final int DEFAULT_ABANDONED_CONNECTION_TIMEOUT = 0;
    public static final int DEFAULT_CONNECTION_WAIT_TIMEOUT = 3;
    public static final int DEFAULT_TIME_TO_LIVE_CONNECTION_TIMEOUT = 0;
    public static final boolean DEFAULT_VALIDATE_BORROWED_CONNECTION = false;
    public static final int DEFAULT_SECONDS_TO_TRUST_IDLE_CONNECTION = 0;
    public static final int DEFAULT_CONNECTION_HARVEST_TRIGGER_COUNT = Integer.MAX_VALUE;
    public static final int DEFAULT_CONNECTION_HARVEST_MAX_COUNT = 1;
    public static final int DEFAULT_QUERY_TIMEOUT = 60;
    public static final int DEFAULT_MAX_CONNECTIONS_PER_SHARD = Integer.MAX_VALUE;
    public static final String DEFAULT_POOLNAME_PREFIX;
    protected AtomicReference<UniversalConnectionPoolLifeCycleState> m_lifeCycleState = new AtomicReference<UniversalConnectionPoolLifeCycleState>(UniversalConnectionPoolLifeCycleState.LIFE_CYCLE_STOPPED);
    private AtomicInteger m_initialPoolSize = new AtomicInteger(0);
    private AtomicInteger m_minPoolSize = new AtomicInteger(0);
    private final AtomicInteger m_maxPoolSize = new AtomicInteger(Integer.MAX_VALUE);
    private final AtomicInteger maxConnectionsPerService = new AtomicInteger(Integer.MAX_VALUE);
    private final AtomicInteger m_inactiveConnectionTimeout = new AtomicInteger(0);
    private final AtomicInteger m_timeoutCheckInterval = new AtomicInteger(30);
    private final AtomicInteger m_abandonedConnectionTimeout = new AtomicInteger(0);
    private final AtomicInteger m_connectionWaitTimeout = new AtomicInteger(3);
    final AtomicInteger m_numConnectionsCreated = new AtomicInteger(0);
    final AtomicInteger m_numConnectionsClosed = new AtomicInteger(0);
    private final AtomicInteger m_timeToLiveConnectionTimeout = new AtomicInteger(0);
    private final AtomicBoolean m_validateConnectionOnBorrow = new AtomicBoolean(false);
    private final AtomicInteger m_connectionHarvestTriggerCount = new AtomicInteger(Integer.MAX_VALUE);
    private final AtomicLong m_maxConnectionReuseTime = new AtomicLong(0L);
    private final AtomicInteger m_maxConnectionReuseCount = new AtomicInteger(0);
    private final AtomicInteger m_connectionHarvestMaxCount = new AtomicInteger(1);
    private final ConnectionFactoryAdapter m_connectionFactoryAdapter;
    private final AtomicReference<ConnectionRetrievalInfo> m_defaultConnectionRetrievalInfo = new AtomicReference<Object>(null);
    protected final AtomicReference<ConnectionLabelingCallback> m_connectionLabelingCallback = new AtomicReference<Object>(null);
    protected final AtomicReference<ConnectionAffinityCallback> m_connectionAffinityCallback = new AtomicReference<Object>(null);
    private final AtomicReference<TimerHandle> m_abandonedConnectionTimer = new AtomicReference<Object>(null);
    private final AtomicReference<TimerHandle> m_inactiveConnectionTimer = new AtomicReference<Object>(null);
    private final AtomicReference<TimerHandle> m_timeToLiveConnectionTimer = new AtomicReference<Object>(null);
    private final AtomicReference<TimerHandle> m_connectionHarvestTimer = new AtomicReference<Object>(null);
    private final AtomicBoolean m_failoverEnabled = new AtomicBoolean(false);
    private final AtomicBoolean failoverExplicitlySet = new AtomicBoolean(false);
    private AtomicReference<String> m_poolName = new AtomicReference<String>(new UniqueIdentifier(DEFAULT_POOLNAME_PREFIX).toString());
    private final AtomicInteger m_abandonedConnectionsCount = new AtomicInteger(0);
    final AtomicLong m_cumulativeReturnedConnectionsCount = new AtomicLong(0L);
    final AtomicLong m_cumulativeBorrowedConnectionsCount = new AtomicLong(0L);
    final AtomicLong m_cumulativeSuccessfulConnectionWaitCount = new AtomicLong(0L);
    final AtomicLong m_cumulativeFailedConnectionWaitCount = new AtomicLong(0L);
    final PeakIntegerCounter m_peakBorrowedConnectionsCount = new PeakIntegerCounter();
    AtomicInteger m_cumulativeConnectionsCreated = new AtomicInteger();
    final AtomicLong m_cumulativeSuccessfulConnectionWaitTime = new AtomicLong(0L);
    final AtomicLong m_cumulativeFailedConnectionWaitTime = new AtomicLong(0L);
    PeakLongCounter m_peakConnectionWaitTime = new PeakLongCounter();
    final AtomicInteger m_pendingRequestsCount = new AtomicInteger(0);
    final AtomicLong m_cumulativeConnectionUseTime = new AtomicLong(0L);
    protected final AtomicLong borrowedAccumulator = new AtomicLong(0L);
    protected final AtomicLong borrowedSamples = new AtomicLong(0L);
    private final AtomicReference<TimerHandle> m_averageBorrowedConnectionsTimer = new AtomicReference<Object>(null);
    private AtomicReference<TimerHandle> m_replaceNonReusableConnectionsTimer = new AtomicReference<Object>(null);
    public static final int THREAD_POOL_SIZE = 24;
    private static final AtomicInteger m_poolsRunning;
    private AtomicInteger connectionLabelingHighCost = new AtomicInteger(Integer.MAX_VALUE);
    private AtomicInteger highCostConnectionReuseThreshold = new AtomicInteger(0);
    private final AtomicInteger m_secondsToTrustIdleConnection = new AtomicInteger(0);
    private final AtomicInteger connectionRepurposeThreshold = new AtomicInteger(0);
    private final AtomicInteger maxConnectionsPerShard = new AtomicInteger(Integer.MAX_VALUE);
    private final AtomicBoolean shareable = new AtomicBoolean(false);
    private Limits limits = new Limits(){
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;
        private static Executable $$$methodRef$$$5;
        private static Logger $$$loggerRef$$$5;
        private static Executable $$$methodRef$$$6;
        private static Logger $$$loggerRef$$$6;

        @Override
        public int getMin() {
            return UniversalConnectionPoolBase.this.m_minPoolSize.get();
        }

        @Override
        public int getInitial() {
            return UniversalConnectionPoolBase.this.m_initialPoolSize.get();
        }

        @Override
        public int getMax() {
            return UniversalConnectionPoolBase.this.m_maxPoolSize.get();
        }

        @Override
        public int getRepurposeThreshold() {
            return UniversalConnectionPoolBase.this.connectionRepurposeThreshold.get();
        }

        @Override
        public int getMaxPerService() {
            return UniversalConnectionPoolBase.this.maxConnectionsPerService.get();
        }

        @Override
        public int getMaxPerShard() {
            return UniversalConnectionPoolBase.this.maxConnectionsPerShard.get();
        }

        static {
            try {
                $$$methodRef$$$6 = 1.class.getDeclaredConstructor(UniversalConnectionPoolBase.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$5 = 1.class.getDeclaredMethod("getMaxPerShard", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$4 = 1.class.getDeclaredMethod("getMaxPerService", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$3 = 1.class.getDeclaredMethod("getRepurposeThreshold", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$2 = 1.class.getDeclaredMethod("getMax", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$1 = 1.class.getDeclaredMethod("getInitial", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$0 = 1.class.getDeclaredMethod("getMin", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        }
    };
    protected final Lock availLock = new ReentrantLock();
    protected final Condition availCondition = this.availLock.newCondition();
    protected final Counter totalConnectionsCount = new Counter(){
        private final AtomicInteger counter = new AtomicInteger(0);
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;
        private static Executable $$$methodRef$$$5;
        private static Logger $$$loggerRef$$$5;

        @Override
        public int getAndIncrement() {
            int count = this.counter.getAndIncrement();
            if (count > UniversalConnectionPoolBase.this.limits.getMax()) {
                UniversalConnectionPoolBase.this.core.kickAdjuster();
            }
            try {
                UniversalConnectionPoolBase.this.availLock.lock();
                UniversalConnectionPoolBase.this.availCondition.signal();
            }
            finally {
                UniversalConnectionPoolBase.this.availLock.unlock();
            }
            return count;
        }

        @Override
        public int decrementAndGet() {
            int count = this.counter.decrementAndGet();
            if (count < UniversalConnectionPoolBase.this.limits.getMin()) {
                UniversalConnectionPoolBase.this.core.kickAdjuster();
            }
            try {
                UniversalConnectionPoolBase.this.availLock.lock();
                UniversalConnectionPoolBase.this.availCondition.signal();
            }
            finally {
                UniversalConnectionPoolBase.this.availLock.unlock();
            }
            return count;
        }

        @Override
        public int getAndDecrement() {
            int count = this.counter.getAndDecrement();
            if (count < UniversalConnectionPoolBase.this.limits.getMin()) {
                UniversalConnectionPoolBase.this.core.kickAdjuster();
            }
            try {
                UniversalConnectionPoolBase.this.availLock.lock();
                UniversalConnectionPoolBase.this.availCondition.signal();
            }
            finally {
                UniversalConnectionPoolBase.this.availLock.unlock();
            }
            return count;
        }

        @Override
        public int incrementAndGet() {
            int count = this.counter.incrementAndGet();
            if (count > UniversalConnectionPoolBase.this.limits.getMax()) {
                UniversalConnectionPoolBase.this.core.kickAdjuster();
            }
            try {
                UniversalConnectionPoolBase.this.availLock.lock();
                UniversalConnectionPoolBase.this.availCondition.signal();
            }
            finally {
                UniversalConnectionPoolBase.this.availLock.unlock();
            }
            return count;
        }

        @Override
        public int get() {
            return this.counter.get();
        }

        static {
            try {
                $$$methodRef$$$5 = 2.class.getDeclaredConstructor(UniversalConnectionPoolBase.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$4 = 2.class.getDeclaredMethod("get", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$3 = 2.class.getDeclaredMethod("incrementAndGet", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$2 = 2.class.getDeclaredMethod("getAndDecrement", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$1 = 2.class.getDeclaredMethod("decrementAndGet", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$0 = 2.class.getDeclaredMethod("getAndIncrement", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        }
    };
    protected final Counter borrowedConnectionsCount = new Counter(){
        private final AtomicInteger counter = new AtomicInteger(0);
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;
        private static Executable $$$methodRef$$$5;
        private static Logger $$$loggerRef$$$5;

        @Override
        public int getAndIncrement() {
            return this.counter.getAndIncrement();
        }

        @Override
        public int decrementAndGet() {
            return this.counter.decrementAndGet();
        }

        @Override
        public int getAndDecrement() {
            return this.counter.getAndDecrement();
        }

        @Override
        public int incrementAndGet() {
            return this.counter.incrementAndGet();
        }

        @Override
        public int get() {
            return this.counter.get();
        }

        static {
            try {
                $$$methodRef$$$5 = 3.class.getDeclaredConstructor(UniversalConnectionPoolBase.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$4 = 3.class.getDeclaredMethod("get", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$3 = 3.class.getDeclaredMethod("incrementAndGet", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$2 = 3.class.getDeclaredMethod("getAndDecrement", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$1 = 3.class.getDeclaredMethod("decrementAndGet", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$0 = 3.class.getDeclaredMethod("getAndIncrement", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        }
    };
    private String onsConfig;
    protected final Core core;
    private AtomicInteger queryTimeout = new AtomicInteger(60);
    private AtomicInteger loginTimeout = new AtomicInteger();
    protected PrintWriter logWriter = null;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;
    private static Executable $$$methodRef$$$31;
    private static Logger $$$loggerRef$$$31;
    private static Executable $$$methodRef$$$32;
    private static Logger $$$loggerRef$$$32;
    private static Executable $$$methodRef$$$33;
    private static Logger $$$loggerRef$$$33;
    private static Executable $$$methodRef$$$34;
    private static Logger $$$loggerRef$$$34;
    private static Executable $$$methodRef$$$35;
    private static Logger $$$loggerRef$$$35;
    private static Executable $$$methodRef$$$36;
    private static Logger $$$loggerRef$$$36;
    private static Executable $$$methodRef$$$37;
    private static Logger $$$loggerRef$$$37;
    private static Executable $$$methodRef$$$38;
    private static Logger $$$loggerRef$$$38;
    private static Executable $$$methodRef$$$39;
    private static Logger $$$loggerRef$$$39;
    private static Executable $$$methodRef$$$40;
    private static Logger $$$loggerRef$$$40;
    private static Executable $$$methodRef$$$41;
    private static Logger $$$loggerRef$$$41;
    private static Executable $$$methodRef$$$42;
    private static Logger $$$loggerRef$$$42;
    private static Executable $$$methodRef$$$43;
    private static Logger $$$loggerRef$$$43;
    private static Executable $$$methodRef$$$44;
    private static Logger $$$loggerRef$$$44;
    private static Executable $$$methodRef$$$45;
    private static Logger $$$loggerRef$$$45;
    private static Executable $$$methodRef$$$46;
    private static Logger $$$loggerRef$$$46;
    private static Executable $$$methodRef$$$47;
    private static Logger $$$loggerRef$$$47;
    private static Executable $$$methodRef$$$48;
    private static Logger $$$loggerRef$$$48;
    private static Executable $$$methodRef$$$49;
    private static Logger $$$loggerRef$$$49;
    private static Executable $$$methodRef$$$50;
    private static Logger $$$loggerRef$$$50;
    private static Executable $$$methodRef$$$51;
    private static Logger $$$loggerRef$$$51;
    private static Executable $$$methodRef$$$52;
    private static Logger $$$loggerRef$$$52;
    private static Executable $$$methodRef$$$53;
    private static Logger $$$loggerRef$$$53;
    private static Executable $$$methodRef$$$54;
    private static Logger $$$loggerRef$$$54;
    private static Executable $$$methodRef$$$55;
    private static Logger $$$loggerRef$$$55;
    private static Executable $$$methodRef$$$56;
    private static Logger $$$loggerRef$$$56;
    private static Executable $$$methodRef$$$57;
    private static Logger $$$loggerRef$$$57;
    private static Executable $$$methodRef$$$58;
    private static Logger $$$loggerRef$$$58;
    private static Executable $$$methodRef$$$59;
    private static Logger $$$loggerRef$$$59;
    private static Executable $$$methodRef$$$60;
    private static Logger $$$loggerRef$$$60;
    private static Executable $$$methodRef$$$61;
    private static Logger $$$loggerRef$$$61;
    private static Executable $$$methodRef$$$62;
    private static Logger $$$loggerRef$$$62;
    private static Executable $$$methodRef$$$63;
    private static Logger $$$loggerRef$$$63;
    private static Executable $$$methodRef$$$64;
    private static Logger $$$loggerRef$$$64;
    private static Executable $$$methodRef$$$65;
    private static Logger $$$loggerRef$$$65;
    private static Executable $$$methodRef$$$66;
    private static Logger $$$loggerRef$$$66;
    private static Executable $$$methodRef$$$67;
    private static Logger $$$loggerRef$$$67;
    private static Executable $$$methodRef$$$68;
    private static Logger $$$loggerRef$$$68;
    private static Executable $$$methodRef$$$69;
    private static Logger $$$loggerRef$$$69;
    private static Executable $$$methodRef$$$70;
    private static Logger $$$loggerRef$$$70;
    private static Executable $$$methodRef$$$71;
    private static Logger $$$loggerRef$$$71;
    private static Executable $$$methodRef$$$72;
    private static Logger $$$loggerRef$$$72;
    private static Executable $$$methodRef$$$73;
    private static Logger $$$loggerRef$$$73;
    private static Executable $$$methodRef$$$74;
    private static Logger $$$loggerRef$$$74;
    private static Executable $$$methodRef$$$75;
    private static Logger $$$loggerRef$$$75;
    private static Executable $$$methodRef$$$76;
    private static Logger $$$loggerRef$$$76;
    private static Executable $$$methodRef$$$77;
    private static Logger $$$loggerRef$$$77;
    private static Executable $$$methodRef$$$78;
    private static Logger $$$loggerRef$$$78;
    private static Executable $$$methodRef$$$79;
    private static Logger $$$loggerRef$$$79;
    private static Executable $$$methodRef$$$80;
    private static Logger $$$loggerRef$$$80;
    private static Executable $$$methodRef$$$81;
    private static Logger $$$loggerRef$$$81;
    private static Executable $$$methodRef$$$82;
    private static Logger $$$loggerRef$$$82;
    private static Executable $$$methodRef$$$83;
    private static Logger $$$loggerRef$$$83;
    private static Executable $$$methodRef$$$84;
    private static Logger $$$loggerRef$$$84;
    private static Executable $$$methodRef$$$85;
    private static Logger $$$loggerRef$$$85;
    private static Executable $$$methodRef$$$86;
    private static Logger $$$loggerRef$$$86;
    private static Executable $$$methodRef$$$87;
    private static Logger $$$loggerRef$$$87;
    private static Executable $$$methodRef$$$88;
    private static Logger $$$loggerRef$$$88;
    private static Executable $$$methodRef$$$89;
    private static Logger $$$loggerRef$$$89;
    private static Executable $$$methodRef$$$90;
    private static Logger $$$loggerRef$$$90;
    private static Executable $$$methodRef$$$91;
    private static Logger $$$loggerRef$$$91;
    private static Executable $$$methodRef$$$92;
    private static Logger $$$loggerRef$$$92;
    private static Executable $$$methodRef$$$93;
    private static Logger $$$loggerRef$$$93;
    private static Executable $$$methodRef$$$94;
    private static Logger $$$loggerRef$$$94;
    private static Executable $$$methodRef$$$95;
    private static Logger $$$loggerRef$$$95;
    private static Executable $$$methodRef$$$96;
    private static Logger $$$loggerRef$$$96;
    private static Executable $$$methodRef$$$97;
    private static Logger $$$loggerRef$$$97;
    private static Executable $$$methodRef$$$98;
    private static Logger $$$loggerRef$$$98;
    private static Executable $$$methodRef$$$99;
    private static Logger $$$loggerRef$$$99;
    private static Executable $$$methodRef$$$100;
    private static Logger $$$loggerRef$$$100;
    private static Executable $$$methodRef$$$101;
    private static Logger $$$loggerRef$$$101;
    private static Executable $$$methodRef$$$102;
    private static Logger $$$loggerRef$$$102;
    private static Executable $$$methodRef$$$103;
    private static Logger $$$loggerRef$$$103;
    private static Executable $$$methodRef$$$104;
    private static Logger $$$loggerRef$$$104;
    private static Executable $$$methodRef$$$105;
    private static Logger $$$loggerRef$$$105;
    private static Executable $$$methodRef$$$106;
    private static Logger $$$loggerRef$$$106;
    private static Executable $$$methodRef$$$107;
    private static Logger $$$loggerRef$$$107;
    private static Executable $$$methodRef$$$108;
    private static Logger $$$loggerRef$$$108;
    private static Executable $$$methodRef$$$109;
    private static Logger $$$loggerRef$$$109;
    private static Executable $$$methodRef$$$110;
    private static Logger $$$loggerRef$$$110;
    private static Executable $$$methodRef$$$111;
    private static Logger $$$loggerRef$$$111;
    private static Executable $$$methodRef$$$112;
    private static Logger $$$loggerRef$$$112;
    private static Executable $$$methodRef$$$113;
    private static Logger $$$loggerRef$$$113;
    private static Executable $$$methodRef$$$114;
    private static Logger $$$loggerRef$$$114;
    private static Executable $$$methodRef$$$115;
    private static Logger $$$loggerRef$$$115;
    private static Executable $$$methodRef$$$116;
    private static Logger $$$loggerRef$$$116;
    private static Executable $$$methodRef$$$117;
    private static Logger $$$loggerRef$$$117;
    private static Executable $$$methodRef$$$118;
    private static Logger $$$loggerRef$$$118;
    private static Executable $$$methodRef$$$119;
    private static Logger $$$loggerRef$$$119;
    private static Executable $$$methodRef$$$120;
    private static Logger $$$loggerRef$$$120;
    private static Executable $$$methodRef$$$121;
    private static Logger $$$loggerRef$$$121;
    private static Executable $$$methodRef$$$122;
    private static Logger $$$loggerRef$$$122;
    private static Executable $$$methodRef$$$123;
    private static Logger $$$loggerRef$$$123;
    private static Executable $$$methodRef$$$124;
    private static Logger $$$loggerRef$$$124;
    private static Executable $$$methodRef$$$125;
    private static Logger $$$loggerRef$$$125;
    private static Executable $$$methodRef$$$126;
    private static Logger $$$loggerRef$$$126;
    private static Executable $$$methodRef$$$127;
    private static Logger $$$loggerRef$$$127;
    private static Executable $$$methodRef$$$128;
    private static Logger $$$loggerRef$$$128;
    private static Executable $$$methodRef$$$129;
    private static Logger $$$loggerRef$$$129;
    private static Executable $$$methodRef$$$130;
    private static Logger $$$loggerRef$$$130;
    private static Executable $$$methodRef$$$131;
    private static Logger $$$loggerRef$$$131;
    private static Executable $$$methodRef$$$132;
    private static Logger $$$loggerRef$$$132;
    private static Executable $$$methodRef$$$133;
    private static Logger $$$loggerRef$$$133;
    private static Executable $$$methodRef$$$134;
    private static Logger $$$loggerRef$$$134;
    private static Executable $$$methodRef$$$135;
    private static Logger $$$loggerRef$$$135;
    private static Executable $$$methodRef$$$136;
    private static Logger $$$loggerRef$$$136;

    void onAvailable() {
    }

    UniversalConnectionPoolBase(ConnectionFactoryAdapter connectionFactoryAdapter) throws UniversalConnectionPoolException {
        if (connectionFactoryAdapter == null) {
            UCPErrorHandler.throwUniversalConnectionPoolException(104);
        }
        this.m_connectionFactoryAdapter = connectionFactoryAdapter;
        this.m_connectionFactoryAdapter.setUniversalConnectionPool(this);
        this.core = new Core();
        this.core.plugConnectionSource(new Topology(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;
            private static Executable $$$methodRef$$$3;
            private static Logger $$$loggerRef$$$3;
            private static Executable $$$methodRef$$$4;
            private static Logger $$$loggerRef$$$4;
            private static Executable $$$methodRef$$$5;
            private static Logger $$$loggerRef$$$5;
            private static Executable $$$methodRef$$$6;
            private static Logger $$$loggerRef$$$6;
            private static Executable $$$methodRef$$$7;
            private static Logger $$$loggerRef$$$7;
            private static Executable $$$methodRef$$$8;
            private static Logger $$$loggerRef$$$8;
            private static Executable $$$methodRef$$$9;
            private static Logger $$$loggerRef$$$9;

            @Override
            protected ConnectionFactoryAdapter getConnectionFactoryAdapter() {
                return UniversalConnectionPoolBase.this.m_connectionFactoryAdapter;
            }

            @Override
            public boolean failoverEnabled() {
                return UniversalConnectionPoolBase.this.isFailoverExplicitlySet() ? UniversalConnectionPoolBase.this.isFailoverEnabled() : this.isFANHeuristicallyEnabled();
            }

            @Override
            protected String getONSConfig() {
                return UniversalConnectionPoolBase.this.getONSConfiguration();
            }

            @Override
            protected AtomicInteger connectionsCreated() {
                return UniversalConnectionPoolBase.this.m_numConnectionsCreated;
            }

            @Override
            protected AtomicInteger connectionsClosed() {
                return UniversalConnectionPoolBase.this.m_numConnectionsClosed;
            }

            @Override
            protected AtomicLong cumulativeConnectionUseTime() {
                return UniversalConnectionPoolBase.this.m_cumulativeConnectionUseTime;
            }

            @Override
            public Counter totalCount() {
                return UniversalConnectionPoolBase.this.totalConnectionsCount;
            }

            @Override
            public Counter borrowedCount() {
                return UniversalConnectionPoolBase.this.borrowedConnectionsCount;
            }

            @Override
            public Limits limits() {
                return UniversalConnectionPoolBase.this.limits;
            }

            static {
                try {
                    $$$methodRef$$$9 = 4.class.getDeclaredConstructor(UniversalConnectionPoolBase.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$8 = 4.class.getDeclaredMethod("limits", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$7 = 4.class.getDeclaredMethod("borrowedCount", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$6 = 4.class.getDeclaredMethod("totalCount", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$5 = 4.class.getDeclaredMethod("cumulativeConnectionUseTime", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$4 = 4.class.getDeclaredMethod("connectionsClosed", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$3 = 4.class.getDeclaredMethod("connectionsCreated", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$2 = 4.class.getDeclaredMethod("getONSConfig", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$1 = 4.class.getDeclaredMethod("failoverEnabled", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$0 = 4.class.getDeclaredMethod("getConnectionFactoryAdapter", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            }
        });
        this.core.plugLimits(this.limits);
    }

    public String getONSConfiguration() {
        return this.onsConfig;
    }

    public void setONSConfiguration(String onsConfig) {
        if (null == onsConfig) {
            onsConfig = "";
        }
        this.onsConfig = onsConfig;
    }

    @Override
    public abstract UniversalPooledConnection borrowConnection(ConnectionRetrievalInfo var1) throws UniversalConnectionPoolException;

    protected abstract UniversalPooledConnection createOnePooledConnection(ConnectionRetrievalInfo var1) throws UniversalConnectionPoolException;

    @Override
    public abstract void returnConnection(UniversalPooledConnection var1) throws UniversalConnectionPoolException;

    @Override
    public abstract void closeConnection(UniversalPooledConnection var1) throws UniversalConnectionPoolException;

    @Override
    public abstract void purge() throws UniversalConnectionPoolException;

    @Override
    public abstract void refresh() throws UniversalConnectionPoolException;

    @Override
    public abstract void recycle() throws UniversalConnectionPoolException;

    @Override
    public void reconfigure(Properties props) throws UniversalConnectionPoolException {
    }

    @Override
    public void start() throws UniversalConnectionPoolException {
        boolean bl;
        boolean bl2 = bl = (0x6000000000000L & TraceControllerImpl.feature) != 0L;
        if (!this.isLifecycleStopped() && !this.isLifecycleFailed()) {
            UCPErrorHandler.throwUniversalConnectionPoolException(60);
        }
        this.setLifecycleStarting();
        if (1 == m_poolsRunning.incrementAndGet()) {
            UniversalConnectionPoolManagerBase.getTaskManager().start();
            UniversalConnectionPoolManagerBase.getTimerManager().start();
            Clock.start();
        }
        if (this.getConnectionRetrievalInfo() == null) {
            this.setLifecycleFailed();
            UCPErrorHandler.throwUniversalConnectionPoolException(203);
        }
        try {
            this.core.start(this.getConnectionRetrievalInfo());
            this.setConnectionRetrievalInfo(this.core.connectionSource().defaultCri());
            this.initAbandonedConnectionTimeoutTimer();
            this.initInactiveConnectionTimeoutTimer();
            this.initTimeToLiveConnectionTimeoutTimer();
            this.initConnectionHarvestingTimer();
            this.initReplaceNonReusableConnectionsTimer();
            this.validatePoolSizes();
            this.core.initialize();
        }
        catch (UniversalConnectionPoolException e) {
            block10: {
                this.setLifecycleFailed();
                if (bl) {
                    this.ilogThrowing($$$loggerRef$$$4, UniversalConnectionPoolBase.class, $$$methodRef$$$4, this, e);
                }
                try {
                    this.purge();
                }
                catch (Exception e1) {
                    if (!bl) break block10;
                    this.ilogThrowing($$$loggerRef$$$4, UniversalConnectionPoolBase.class, $$$methodRef$$$4, this, e1);
                }
            }
            this.disableAbandonedConnectionTimeoutTimer();
            this.disableInactiveConnectionTimeoutTimer();
            this.disableTimeToLiveConnectionTimeoutTimer();
            this.disableConnectionHarvestingTimer();
            this.cancelReplaceNonReusableConnectionsTimer();
            this.core.stop();
            this.failoverExplicitlySet.set(false);
            if (1 == m_poolsRunning.getAndDecrement()) {
                Clock.stop();
                UniversalConnectionPoolManagerBase.getTaskManager().stop();
                UniversalConnectionPoolManagerBase.getTimerManager().stop();
                m_poolsRunning.set(0);
            }
            throw e;
        }
        this.setLifecycleRunning();
        if (bl) {
            this.ilogFine($$$loggerRef$$$4, UniversalConnectionPoolBase.class, $$$methodRef$$$4, this, "pool started");
        }
    }

    @Override
    public void stop() throws UniversalConnectionPoolException {
        boolean bl;
        boolean bl2 = bl = (0x6000000000000L & TraceControllerImpl.feature) != 0L;
        if (this.isLifecycleStopped()) {
            return;
        }
        boolean wasRunning = this.isLifecycleRunning();
        this.setLifecycleStopping();
        try {
            this.purge();
        }
        catch (UniversalConnectionPoolException e) {
            this.setLifecycleFailed();
            throw e;
        }
        finally {
            this.disableAbandonedConnectionTimeoutTimer();
            this.disableInactiveConnectionTimeoutTimer();
            this.disableTimeToLiveConnectionTimeoutTimer();
            this.disableConnectionHarvestingTimer();
            this.cancelReplaceNonReusableConnectionsTimer();
            this.resetNonCumulativePoolStatistics();
        }
        this.core.stop();
        this.failoverExplicitlySet.set(false);
        if (wasRunning && 1 == m_poolsRunning.getAndDecrement()) {
            Clock.stop();
            UniversalConnectionPoolManagerBase.getTaskManager().stop();
            UniversalConnectionPoolManagerBase.getTimerManager().stop();
            m_poolsRunning.set(0);
        }
        this.setLifecycleStopped();
        this.resetNonCumulativePoolStatistics();
        if (bl) {
            this.ilogFine($$$loggerRef$$$5, UniversalConnectionPoolBase.class, $$$methodRef$$$5, this, "pool stopped");
        }
    }

    protected void resetAllPoolStatistics() {
        boolean bl = (0x6000000000000L & TraceControllerImpl.feature) != 0L;
        this.m_numConnectionsCreated.set(0);
        this.m_numConnectionsClosed.set(0);
        this.m_abandonedConnectionsCount.set(0);
        this.m_peakBorrowedConnectionsCount.set(0);
        this.m_peakConnectionWaitTime.set(0L);
        this.m_pendingRequestsCount.set(0);
        this.m_cumulativeReturnedConnectionsCount.set(0L);
        this.m_cumulativeBorrowedConnectionsCount.set(0L);
        this.m_cumulativeSuccessfulConnectionWaitCount.set(0L);
        this.m_cumulativeFailedConnectionWaitCount.set(0L);
        this.m_cumulativeSuccessfulConnectionWaitTime.set(0L);
        this.m_cumulativeFailedConnectionWaitTime.set(0L);
        this.m_cumulativeConnectionUseTime.set(0L);
        this.m_cumulativeConnectionsCreated.set(0);
        this.borrowedAccumulator.set(0L);
        this.borrowedSamples.set(0L);
        if (bl) {
            this.ilogFinest($$$loggerRef$$$6, UniversalConnectionPoolBase.class, $$$methodRef$$$6, this, "reset");
        }
    }

    protected void resetNonCumulativePoolStatistics() {
        boolean bl = (0x6000000000000L & TraceControllerImpl.feature) != 0L;
        this.m_numConnectionsCreated.set(0);
        this.m_numConnectionsClosed.set(0);
        this.m_abandonedConnectionsCount.set(0);
        this.m_peakBorrowedConnectionsCount.set(0);
        this.m_peakConnectionWaitTime.set(0L);
        this.m_pendingRequestsCount.set(0);
        this.borrowedAccumulator.set(0L);
        this.borrowedSamples.set(0L);
        if (bl) {
            this.ilogFinest($$$loggerRef$$$7, UniversalConnectionPoolBase.class, $$$methodRef$$$7, this, "reset");
        }
    }

    @Override
    public String getName() {
        return this.m_poolName.get();
    }

    @Override
    public void setName(String name) {
        this.m_poolName.set(name);
    }

    @Override
    public int getInitialPoolSize() {
        return this.m_initialPoolSize.get();
    }

    @Override
    public void setInitialPoolSize(int initialPoolSize) throws UniversalConnectionPoolException {
        if (initialPoolSize < 0) {
            UCPErrorHandler.throwUniversalConnectionPoolException(6);
        }
        this.m_initialPoolSize.set(initialPoolSize);
    }

    @Override
    public int getMinPoolSize() {
        return this.m_minPoolSize.get();
    }

    @Override
    public void setMinPoolSize(int minPoolSize) throws UniversalConnectionPoolException {
        if (minPoolSize < 0) {
            UCPErrorHandler.throwUniversalConnectionPoolException(6);
        }
        this.m_minPoolSize.set(minPoolSize);
    }

    @Override
    public int getMaxPoolSize() {
        return this.m_maxPoolSize.get();
    }

    @Override
    public void setMaxPoolSize(int maxPoolSize) throws UniversalConnectionPoolException {
        if (maxPoolSize < 0) {
            UCPErrorHandler.throwUniversalConnectionPoolException(6);
        }
        this.m_maxPoolSize.set(maxPoolSize);
        this.core.adjustMaxLimit();
    }

    /*
     * WARNING - void declaration
     */
    protected void closePhysicalConnection(Object object) {
        boolean bl = (0x6000000000000L & TraceControllerImpl.feature) != 0L;
        try {
            void physicalConnection;
            this.m_connectionFactoryAdapter.closeConnection(physicalConnection);
        }
        catch (UniversalConnectionPoolException e) {
            if (bl) {
                this.ilogThrowing($$$loggerRef$$$16, UniversalConnectionPoolBase.class, $$$methodRef$$$16, this, e);
            }
        }
        finally {
            if (this.isLifecycleRunning()) {
                this.incrementConnectionsClosedCount();
            } else if (bl) {
                this.ilogFinest($$$loggerRef$$$16, UniversalConnectionPoolBase.class, $$$methodRef$$$16, this, "pool is not running");
            }
        }
    }

    @Override
    public int getInactiveConnectionTimeout() {
        return this.m_inactiveConnectionTimeout.get();
    }

    private void initInactiveConnectionTimeoutTimer() throws UniversalConnectionPoolException {
        boolean bl = (0x6000000000000L & TraceControllerImpl.feature) != 0L;
        int timeoutCheck = this.m_timeoutCheckInterval.get();
        if (timeoutCheck > 0 && this.m_inactiveConnectionTimeout.get() > 0 && this.m_inactiveConnectionTimer.compareAndSet(null, UniversalConnectionPoolManagerBase.getTimerManager().scheduleAtFixedRate(new UCPTimerTaskImpl(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;

            @Override
            public void run() {
                UniversalConnectionPoolManagerBase.getTaskManager().submitTask(new UCPTaskBase<Object>(){
                    private static Executable $$$methodRef$$$0;
                    private static Logger $$$loggerRef$$$0;
                    private static Executable $$$methodRef$$$1;
                    private static Logger $$$loggerRef$$$1;

                    @Override
                    public void run() {
                        UniversalConnectionPoolBase.this.core.closeAvailableInactive(UniversalConnectionPoolBase.this.m_inactiveConnectionTimeout.get() * 1000);
                    }

                    static {
                        try {
                            $$$methodRef$$$1 = 1.class.getDeclaredConstructor(5.class);
                        }
                        catch (Throwable throwable) {}
                        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                        try {
                            $$$methodRef$$$0 = 1.class.getDeclaredMethod("run", new Class[0]);
                        }
                        catch (Throwable throwable) {}
                        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                    }
                });
            }

            static {
                try {
                    $$$methodRef$$$1 = 5.class.getDeclaredConstructor(UniversalConnectionPoolBase.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$0 = 5.class.getDeclaredMethod("run", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            }
        }, 0L, timeoutCheck * 1000)) && bl) {
            this.ilogFinest($$$loggerRef$$$18, UniversalConnectionPoolBase.class, $$$methodRef$$$18, this, "scheduled");
        }
    }

    private void disableInactiveConnectionTimeoutTimer() {
        boolean bl = (0x6000000000000L & TraceControllerImpl.feature) != 0L;
        TimerHandle timerToCancel = this.m_inactiveConnectionTimer.getAndSet(null);
        if (timerToCancel != null) {
            timerToCancel.cancel();
            if (bl) {
                this.ilogFinest($$$loggerRef$$$19, UniversalConnectionPoolBase.class, $$$methodRef$$$19, this, "canceled");
            }
        }
    }

    @Override
    public void setInactiveConnectionTimeout(int inactiveConnectionTimeout) throws UniversalConnectionPoolException {
        int formerValue;
        if (inactiveConnectionTimeout < 0) {
            UCPErrorHandler.throwUniversalConnectionPoolException(6);
        }
        if ((formerValue = this.m_inactiveConnectionTimeout.getAndSet(inactiveConnectionTimeout)) != inactiveConnectionTimeout) {
            this.disableInactiveConnectionTimeoutTimer();
            if (inactiveConnectionTimeout > 0 && this.isLifecycleRunning()) {
                this.initInactiveConnectionTimeoutTimer();
            }
        }
    }

    protected TimerHandle getInactiveConnectionTimer() {
        return this.m_inactiveConnectionTimer.get();
    }

    @Override
    public int getConnectionWaitTimeout() {
        return this.m_connectionWaitTimeout.get();
    }

    @Override
    public void setConnectionWaitTimeout(int waitTimeout) throws UniversalConnectionPoolException {
        if (waitTimeout < 0) {
            UCPErrorHandler.throwUniversalConnectionPoolException(6);
        }
        this.m_connectionWaitTimeout.set(waitTimeout);
    }

    @Override
    public int getTimeToLiveConnectionTimeout() {
        return this.m_timeToLiveConnectionTimeout.get();
    }

    void processTimeToLiveTimeout() {
        final int ttl = this.m_timeToLiveConnectionTimeout.get();
        if (ttl > 0) {
            UniversalConnectionPoolManagerBase.getTaskManager().submitTask(new UCPTaskBase<Object>(){
                private static Executable $$$methodRef$$$0;
                private static Logger $$$loggerRef$$$0;
                private static Executable $$$methodRef$$$1;
                private static Logger $$$loggerRef$$$1;

                @Override
                public void run() {
                    UniversalConnectionPoolBase.this.core.returnTTLed(ttl * 1000);
                }

                static {
                    try {
                        $$$methodRef$$$1 = 6.class.getDeclaredConstructor(UniversalConnectionPoolBase.class, Integer.TYPE);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                    try {
                        $$$methodRef$$$0 = 6.class.getDeclaredMethod("run", new Class[0]);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                }
            });
        }
    }

    private void initTimeToLiveConnectionTimeoutTimer() throws UniversalConnectionPoolException {
        boolean bl = (0x6000000000000L & TraceControllerImpl.feature) != 0L;
        int timeoutCheck = this.m_timeoutCheckInterval.get();
        if (timeoutCheck > 0 && this.m_timeToLiveConnectionTimeout.get() > 0 && this.m_timeToLiveConnectionTimer.compareAndSet(null, UniversalConnectionPoolManagerBase.getTimerManager().scheduleAtFixedRate(new TimeToLiveConnectionTimerTask(this), 0L, timeoutCheck * 1000)) && bl) {
            this.ilogFinest($$$loggerRef$$$26, UniversalConnectionPoolBase.class, $$$methodRef$$$26, this, "scheduled");
        }
    }

    private void disableTimeToLiveConnectionTimeoutTimer() {
        boolean bl = (0x6000000000000L & TraceControllerImpl.feature) != 0L;
        TimerHandle timerToCancel = this.m_timeToLiveConnectionTimer.getAndSet(null);
        if (null != timerToCancel) {
            timerToCancel.cancel();
            if (bl) {
                this.ilogFinest($$$loggerRef$$$27, UniversalConnectionPoolBase.class, $$$methodRef$$$27, this, "canceled");
            }
        }
    }

    @Override
    public void setTimeToLiveConnectionTimeout(int timeToLiveConnectionTimeout) throws UniversalConnectionPoolException {
        int prevValue;
        if (timeToLiveConnectionTimeout < 0) {
            UCPErrorHandler.throwUniversalConnectionPoolException(6);
        }
        if ((prevValue = this.m_timeToLiveConnectionTimeout.getAndSet(timeToLiveConnectionTimeout)) != timeToLiveConnectionTimeout) {
            this.disableTimeToLiveConnectionTimeoutTimer();
            if (timeToLiveConnectionTimeout != 0 && this.isLifecycleRunning()) {
                this.initTimeToLiveConnectionTimeoutTimer();
            }
        }
    }

    protected TimerHandle getTimeToLiveConnectionTimer() {
        return this.m_timeToLiveConnectionTimer.get();
    }

    @Override
    public int getTimeoutCheckInterval() {
        return this.m_timeoutCheckInterval.get();
    }

    @Override
    public void setTimeoutCheckInterval(int timeoutCheckInterval) throws UniversalConnectionPoolException {
        int prevValue;
        if (timeoutCheckInterval < 0) {
            UCPErrorHandler.throwUniversalConnectionPoolException(6);
        }
        if ((prevValue = this.m_timeoutCheckInterval.getAndSet(timeoutCheckInterval)) != timeoutCheckInterval) {
            this.disableAbandonedConnectionTimeoutTimer();
            this.disableInactiveConnectionTimeoutTimer();
            this.disableTimeToLiveConnectionTimeoutTimer();
            this.disableConnectionHarvestingTimer();
            if (timeoutCheckInterval != 0 && this.isLifecycleRunning()) {
                this.initAbandonedConnectionTimeoutTimer();
                this.initInactiveConnectionTimeoutTimer();
                this.initTimeToLiveConnectionTimeoutTimer();
                this.initConnectionHarvestingTimer();
            }
        }
    }

    @Override
    public boolean getValidateConnectionOnBorrow() {
        return this.m_validateConnectionOnBorrow.get();
    }

    @Override
    public void setValidateConnectionOnBorrow(boolean validateConnectionOnBorrow) {
        this.m_validateConnectionOnBorrow.set(validateConnectionOnBorrow);
    }

    @Override
    public int getSecondsToTrustIdleConnection() {
        return this.m_secondsToTrustIdleConnection.get();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setSecondsToTrustIdleConnection(int n) throws UniversalConnectionPoolException {
        void secondsToTrustIdleConnection;
        boolean bl;
        boolean bl2 = bl = (0x6000000000000L & TraceControllerImpl.feature) != 0L;
        if (!(secondsToTrustIdleConnection == false || this.getValidateConnectionOnBorrow() && secondsToTrustIdleConnection >= 0)) {
            UCPErrorHandler.throwUniversalConnectionPoolException(6);
        }
        if (bl) {
            this.ilogFinest($$$loggerRef$$$35, UniversalConnectionPoolBase.class, $$$methodRef$$$35, this, "set: secondsToTrustIdleConnection");
        }
        this.m_secondsToTrustIdleConnection.set((int)secondsToTrustIdleConnection);
    }

    @Override
    public int getConnectionHarvestTriggerCount() {
        return this.m_connectionHarvestTriggerCount.get();
    }

    @Override
    public void setConnectionHarvestTriggerCount(int connectionHarvestTriggerCount) throws UniversalConnectionPoolException {
        int prevValue;
        if (connectionHarvestTriggerCount < 0) {
            UCPErrorHandler.throwUniversalConnectionPoolException(6);
        }
        if (connectionHarvestTriggerCount != (prevValue = this.m_connectionHarvestTriggerCount.getAndSet(connectionHarvestTriggerCount))) {
            this.disableConnectionHarvestingTimer();
            if (this.m_connectionHarvestTriggerCount.get() >= 0 && this.m_connectionHarvestTriggerCount.get() < Integer.MAX_VALUE && this.isLifecycleRunning()) {
                this.initConnectionHarvestingTimer();
            }
        }
    }

    @Override
    public int getConnectionHarvestMaxCount() {
        return this.m_connectionHarvestMaxCount.get();
    }

    @Override
    public void setConnectionHarvestMaxCount(int connectionHarvestMaxCount) throws UniversalConnectionPoolException {
        if (connectionHarvestMaxCount < 1) {
            UCPErrorHandler.throwUniversalConnectionPoolException(6);
        }
        this.m_connectionHarvestMaxCount.set(connectionHarvestMaxCount);
    }

    int getConnectionsCreatedCount() {
        return this.m_numConnectionsCreated.get();
    }

    protected void incrementConnectionsCreatedCount() {
        this.m_numConnectionsCreated.incrementAndGet();
    }

    int getConnectionsClosedCount() {
        return this.m_numConnectionsClosed.get();
    }

    protected void incrementConnectionsClosedCount() {
        this.m_numConnectionsClosed.incrementAndGet();
    }

    @Override
    public int getAvailableConnectionsCount() {
        return this.totalConnectionsCount.get() - this.borrowedConnectionsCount.get();
    }

    @Override
    public int getBorrowedConnectionsCount() {
        return this.borrowedConnectionsCount.get();
    }

    public int getTotalConnectionsCount() {
        return this.totalConnectionsCount.get();
    }

    @Override
    public abstract UniversalConnectionPoolStatistics getStatistics();

    @Override
    public UniversalConnectionPoolLifeCycleState getLifeCycleState() {
        return this.m_lifeCycleState.get();
    }

    public ConnectionFactoryAdapter getConnectionFactoryAdapter() {
        return this.m_connectionFactoryAdapter;
    }

    @Override
    public ConnectionRetrievalInfo getConnectionRetrievalInfo() {
        return this.m_defaultConnectionRetrievalInfo.get();
    }

    @Override
    public void setConnectionRetrievalInfo(ConnectionRetrievalInfo defaultCRI) {
        this.m_defaultConnectionRetrievalInfo.set(defaultCRI);
    }

    public String getServiceName() {
        return this.core.connectionSource().defaultServiceName();
    }

    @Override
    public void registerConnectionLabelingCallback(ConnectionLabelingCallback cbk) throws UniversalConnectionPoolException {
        if (!this.m_connectionLabelingCallback.compareAndSet(null, cbk)) {
            UCPErrorHandler.throwUniversalConnectionPoolException(91);
        }
    }

    @Override
    public void removeConnectionLabelingCallback() throws UniversalConnectionPoolException {
        this.m_connectionLabelingCallback.set(null);
    }

    @Override
    public void registerConnectionAffinityCallback(ConnectionAffinityCallback cbk) throws UniversalConnectionPoolException {
        this.m_connectionAffinityCallback.set(cbk);
    }

    @Override
    public void removeConnectionAffinityCallback() throws UniversalConnectionPoolException {
        this.m_connectionAffinityCallback.set(null);
    }

    public ConnectionAffinityCallback getConnectionAffinityCallback() {
        return this.m_connectionAffinityCallback.get();
    }

    @Override
    public int getAbandonedConnectionTimeout() {
        return this.m_abandonedConnectionTimeout.get();
    }

    void processAbandonedConnections() {
        final int abandonedTimeout = this.m_abandonedConnectionTimeout.get();
        if (abandonedTimeout > 0) {
            UniversalConnectionPoolManagerBase.getTaskManager().submitTask(new UCPTaskBase<Object>(){
                private static Executable $$$methodRef$$$0;
                private static Logger $$$loggerRef$$$0;
                private static Executable $$$methodRef$$$1;
                private static Logger $$$loggerRef$$$1;

                @Override
                public void run() {
                    UniversalConnectionPoolBase.this.core.returnAbandoned(abandonedTimeout * 1000);
                }

                static {
                    try {
                        $$$methodRef$$$1 = 7.class.getDeclaredConstructor(UniversalConnectionPoolBase.class, Integer.TYPE);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                    try {
                        $$$methodRef$$$0 = 7.class.getDeclaredMethod("run", new Class[0]);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                }
            });
        }
    }

    private void initAbandonedConnectionTimeoutTimer() throws UniversalConnectionPoolException {
        int timeoutCheck = this.m_timeoutCheckInterval.get();
        if (timeoutCheck > 0 && this.m_abandonedConnectionTimeout.get() > 0) {
            this.m_abandonedConnectionTimer.compareAndSet(null, UniversalConnectionPoolManagerBase.getTimerManager().scheduleAtFixedRate(new AbandonedConnectionTimerTask(this), 0L, timeoutCheck * 1000));
        }
    }

    protected void validatePoolSizes() throws UniversalConnectionPoolException {
        int initialPoolSize = this.m_initialPoolSize.get();
        int minPoolSize = this.m_minPoolSize.get();
        int maxPoolSize = this.m_maxPoolSize.get();
        if (initialPoolSize < 0 || minPoolSize < 0 || minPoolSize > maxPoolSize || maxPoolSize < 0) {
            UCPErrorHandler.throwUniversalConnectionPoolException(6);
        }
        if (0 == maxPoolSize) {
            UCPErrorHandler.throwUniversalConnectionPoolException(59);
        }
    }

    private void disableAbandonedConnectionTimeoutTimer() {
        boolean bl = (0x6000000000000L & TraceControllerImpl.feature) != 0L;
        TimerHandle timerToCancel = this.m_abandonedConnectionTimer.getAndSet(null);
        if (null != timerToCancel) {
            timerToCancel.cancel();
            if (bl) {
                this.ilogFinest($$$loggerRef$$$61, UniversalConnectionPoolBase.class, $$$methodRef$$$61, this, "disabled");
            }
        }
    }

    @Override
    public void setAbandonedConnectionTimeout(int abandonedConnectionTimeout) throws UniversalConnectionPoolException {
        int prevValue;
        if (abandonedConnectionTimeout < 0) {
            UCPErrorHandler.throwUniversalConnectionPoolException(6);
        }
        if (abandonedConnectionTimeout != (prevValue = this.m_abandonedConnectionTimeout.getAndSet(abandonedConnectionTimeout))) {
            this.disableAbandonedConnectionTimeoutTimer();
            if (abandonedConnectionTimeout > 0 && this.isLifecycleRunning()) {
                this.initAbandonedConnectionTimeoutTimer();
            }
        }
    }

    protected TimerHandle getAbandonedConnectionTimer() {
        return this.m_abandonedConnectionTimer.get();
    }

    abstract void processConnectionHarvesting();

    private void initConnectionHarvestingTimer() throws UniversalConnectionPoolException {
        boolean bl = (0x6000000000000L & TraceControllerImpl.feature) != 0L;
        int connectionHarvestTriggerCount = this.m_connectionHarvestTriggerCount.get();
        int timeoutCheck = this.m_timeoutCheckInterval.get();
        if (timeoutCheck > 0 && connectionHarvestTriggerCount >= 0 && connectionHarvestTriggerCount < Integer.MAX_VALUE) {
            if (this.m_connectionHarvestTimer.compareAndSet(null, UniversalConnectionPoolManagerBase.getTimerManager().scheduleAtFixedRate(new ConnectionHarvestingTimerTask(this), 0L, timeoutCheck * 1000))) {
                // empty if block
            }
            if (bl) {
                this.ilogFinest($$$loggerRef$$$64, UniversalConnectionPoolBase.class, $$$methodRef$$$64, this, "scheduled");
            }
        }
    }

    private void disableConnectionHarvestingTimer() {
        boolean bl = (0x6000000000000L & TraceControllerImpl.feature) != 0L;
        TimerHandle timerToCancel = this.m_connectionHarvestTimer.getAndSet(null);
        if (null != timerToCancel) {
            timerToCancel.cancel();
            if (bl) {
                this.ilogFinest($$$loggerRef$$$65, UniversalConnectionPoolBase.class, $$$methodRef$$$65, this, "cancelled");
            }
        }
    }

    private void initReplaceNonReusableConnectionsTimer() {
        boolean bl = (0x6000000000000L & TraceControllerImpl.feature) != 0L;
        long reuseTime = this.m_maxConnectionReuseTime.get();
        long timerInterval = reuseTime / 4L + reuseTime % 4L;
        if (reuseTime > 0L && this.m_replaceNonReusableConnectionsTimer.compareAndSet(null, UniversalConnectionPoolManagerBase.getTimerManager().scheduleAtFixedRate(new UCPTimerTaskImpl(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;

            @Override
            public void run() {
                UniversalConnectionPoolManagerBase.getTaskManager().submitTask(new UCPTaskBase<Object>(){
                    private static Executable $$$methodRef$$$0;
                    private static Logger $$$loggerRef$$$0;
                    private static Executable $$$methodRef$$$1;
                    private static Logger $$$loggerRef$$$1;

                    @Override
                    public void run() {
                        UniversalConnectionPoolBase.this.core.replaceNonReusable();
                    }

                    static {
                        try {
                            $$$methodRef$$$1 = 1.class.getDeclaredConstructor(8.class);
                        }
                        catch (Throwable throwable) {}
                        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                        try {
                            $$$methodRef$$$0 = 1.class.getDeclaredMethod("run", new Class[0]);
                        }
                        catch (Throwable throwable) {}
                        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                    }
                });
            }

            static {
                try {
                    $$$methodRef$$$1 = 8.class.getDeclaredConstructor(UniversalConnectionPoolBase.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$0 = 8.class.getDeclaredMethod("run", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            }
        }, 0L, timerInterval * 1000L)) && bl) {
            this.ilogFinest($$$loggerRef$$$66, UniversalConnectionPoolBase.class, $$$methodRef$$$66, this, "scheduled");
        }
    }

    private void cancelReplaceNonReusableConnectionsTimer() {
        boolean bl = (0x6000000000000L & TraceControllerImpl.feature) != 0L;
        TimerHandle timerToCancel = this.m_replaceNonReusableConnectionsTimer.getAndSet(null);
        if (null != timerToCancel) {
            timerToCancel.cancel();
            if (bl) {
                this.ilogFinest($$$loggerRef$$$67, UniversalConnectionPoolBase.class, $$$methodRef$$$67, this, "cancelled");
            }
        }
    }

    protected abstract void setConnectionHarvestable(UniversalPooledConnection var1, boolean var2) throws UniversalConnectionPoolException;

    public boolean isFailoverEnabled() {
        return this.m_failoverEnabled.get();
    }

    protected boolean isFailoverExplicitlySet() {
        return this.failoverExplicitlySet.get();
    }

    protected FailoverEventHandlerTask getFailoverEventHandlerTask() {
        return null;
    }

    public void setFailoverEnabled(boolean failoverEnabled) throws UniversalConnectionPoolException {
        this.m_failoverEnabled.set(failoverEnabled);
        this.failoverExplicitlySet.set(true);
    }

    @Override
    public long getMaxConnectionReuseTime() {
        return this.m_maxConnectionReuseTime.get();
    }

    @Override
    public void setMaxConnectionReuseTime(long maxConnectionReuseTime) throws UniversalConnectionPoolException {
        if (maxConnectionReuseTime < 0L) {
            UCPErrorHandler.throwUniversalConnectionPoolException(6);
        }
        if (maxConnectionReuseTime != this.m_maxConnectionReuseTime.get()) {
            this.cancelReplaceNonReusableConnectionsTimer();
            this.m_maxConnectionReuseTime.set(maxConnectionReuseTime);
            if (maxConnectionReuseTime > 0L && this.isLifecycleRunning()) {
                this.initReplaceNonReusableConnectionsTimer();
            }
        }
    }

    @Override
    public int getMaxConnectionReuseCount() {
        return this.m_maxConnectionReuseCount.get();
    }

    @Override
    public void setMaxConnectionReuseCount(int maxConnectionReuseCount) throws UniversalConnectionPoolException {
        if (maxConnectionReuseCount < 0) {
            UCPErrorHandler.throwUniversalConnectionPoolException(6);
        }
        this.m_maxConnectionReuseCount.set(maxConnectionReuseCount);
    }

    public boolean isRuntimeLoadBalancingEnabled() {
        return false;
    }

    public void setRuntimeLoadBalancingEnabled(boolean RLBEnabled) throws UniversalConnectionPoolException {
    }

    protected abstract void discardUsedConnection(Object var1);

    protected abstract UniversalPooledConnection getUsedConnection(Object var1);

    protected abstract boolean returnUsedPhysicalConnection(Object var1) throws UniversalConnectionPoolException;

    protected abstract boolean closeUsedPhysicalConnection(Object var1) throws UniversalConnectionPoolException;

    @Override
    public void setFailoverInfo(Object info) throws UniversalConnectionPoolException {
    }

    @Override
    public Object getFailoverInfo() {
        return null;
    }

    @Override
    public void handleFailoverEvent(FailoverEvent event) throws UniversalConnectionPoolException {
    }

    public int getAbandonedConnectionsCount() {
        return this.m_abandonedConnectionsCount.get();
    }

    public int getPendingRequestsCount() {
        return this.m_pendingRequestsCount.get();
    }

    public long getCumulativeConnectionReturnedCount() {
        return this.m_cumulativeReturnedConnectionsCount.get();
    }

    public long getCumulativeSuccessfulConnectionWaitCount() {
        return this.m_cumulativeSuccessfulConnectionWaitCount.get();
    }

    public long getCumulativeFailedConnectionWaitCount() {
        return this.m_cumulativeFailedConnectionWaitCount.get();
    }

    public long getCumulativeSuccessfulConnectionWaitTime() {
        return this.m_cumulativeSuccessfulConnectionWaitTime.get();
    }

    public long getCumulativeFailedConnectionWaitTime() {
        return this.m_cumulativeFailedConnectionWaitTime.get();
    }

    public long getCumulativeConnectionBorrowedCount() {
        return this.m_cumulativeBorrowedConnectionsCount.get();
    }

    public long getPeakConnectionWaitTime() {
        return this.m_peakConnectionWaitTime.get();
    }

    public long getCumulativeConnectionUseTime() {
        return this.m_cumulativeConnectionUseTime.get();
    }

    public int getPeakConnectionsCount() {
        return this.m_peakBorrowedConnectionsCount.get();
    }

    public int getCumulativeConnectionsCreated() {
        return this.m_cumulativeConnectionsCreated.get();
    }

    public int getAverageBorrowedConnectionsCount() {
        long accum = new Long(this.borrowedAccumulator.get());
        long samples = new Long(this.borrowedSamples.get());
        return 0L != samples ? new Long(accum / samples).intValue() : 0;
    }

    public boolean isLifecycleRunning() {
        return this.m_lifeCycleState.get() == UniversalConnectionPoolLifeCycleState.LIFE_CYCLE_RUNNING;
    }

    public boolean isLifecycleStarting() {
        return this.m_lifeCycleState.get() == UniversalConnectionPoolLifeCycleState.LIFE_CYCLE_STARTING;
    }

    public boolean isLifecycleStopping() {
        return this.m_lifeCycleState.get() == UniversalConnectionPoolLifeCycleState.LIFE_CYCLE_STOPPING;
    }

    public boolean isLifecycleStopped() {
        return this.m_lifeCycleState.get() == UniversalConnectionPoolLifeCycleState.LIFE_CYCLE_STOPPED;
    }

    public boolean isLifecycleFailed() {
        return this.m_lifeCycleState.get() == UniversalConnectionPoolLifeCycleState.LIFE_CYCLE_FAILED;
    }

    void setLifecycleFailed() {
        this.m_lifeCycleState.set(UniversalConnectionPoolLifeCycleState.LIFE_CYCLE_FAILED);
    }

    private void setLifecycleStarting() {
        this.m_lifeCycleState.set(UniversalConnectionPoolLifeCycleState.LIFE_CYCLE_STARTING);
    }

    private void setLifecycleStopping() {
        this.m_lifeCycleState.set(UniversalConnectionPoolLifeCycleState.LIFE_CYCLE_STOPPING);
    }

    private void setLifecycleRunning() {
        this.m_lifeCycleState.set(UniversalConnectionPoolLifeCycleState.LIFE_CYCLE_RUNNING);
    }

    private void setLifecycleStopped() {
        this.m_lifeCycleState.set(UniversalConnectionPoolLifeCycleState.LIFE_CYCLE_STOPPED);
    }

    protected ConnectionLabelingCallback getConnectionLabelingCallback() {
        return this.m_connectionLabelingCallback.get();
    }

    protected long getCumulativeReturnedConnectionCount() {
        return this.m_cumulativeReturnedConnectionsCount.get();
    }

    @Override
    public int getConnectionLabelingHighCost() {
        return this.connectionLabelingHighCost.get();
    }

    @Override
    public void setConnectionLabelingHighCost(int highCost) throws UniversalConnectionPoolException {
        if (highCost < 0) {
            UCPErrorHandler.throwUniversalConnectionPoolException(6);
        }
        this.connectionLabelingHighCost.set(highCost);
    }

    @Override
    public int getHighCostConnectionReuseThreshold() {
        return this.highCostConnectionReuseThreshold.get();
    }

    @Override
    public void setHighCostConnectionReuseThreshold(int threshold) throws UniversalConnectionPoolException {
        if (threshold < 0) {
            UCPErrorHandler.throwUniversalConnectionPoolException(6);
        }
        this.highCostConnectionReuseThreshold.set(threshold);
    }

    @Override
    public int getMaxConnectionsPerService() {
        return this.maxConnectionsPerService.get();
    }

    @Override
    public void setMaxConnectionsPerService(int maxPerService) throws UniversalConnectionPoolException {
        if (maxPerService < 1) {
            UCPErrorHandler.throwUniversalConnectionPoolException(6);
        }
        if (this.isLifecycleRunning() && maxPerService != this.maxConnectionsPerService.get()) {
            UCPErrorHandler.throwUniversalConnectionPoolException(279);
        }
        this.maxConnectionsPerService.set(maxPerService);
    }

    public void setShareable(boolean shared) {
        this.shareable.set(shared);
    }

    @Override
    public boolean isShareable() {
        return this.shareable.get();
    }

    @Override
    public int getConnectionRepurposeThreshold() {
        return this.connectionRepurposeThreshold.get();
    }

    @Override
    public void setConnectionRepurposeThreshold(Integer threshold) throws UniversalConnectionPoolException {
        if (threshold < 0) {
            UCPErrorHandler.throwUniversalConnectionPoolException(6);
        }
        this.connectionRepurposeThreshold.set(threshold);
    }

    public int getMaxConnectionsPerShard() {
        return this.maxConnectionsPerShard.get();
    }

    public void setMaxConnectionsPerShard(Integer maxConnsPerShard) throws UniversalConnectionPoolException {
        if (maxConnsPerShard < 0) {
            UCPErrorHandler.throwUniversalConnectionPoolException(6);
        }
        this.maxConnectionsPerShard.set(maxConnsPerShard);
    }

    public String getDatabaseTopologyInfo() {
        ConnectionSource cs = this.core.connectionSource();
        if (cs instanceof Topology) {
            return ((Topology)cs).getDatabaseTopologyInfo();
        }
        return "Database topology not collected by UCP yet";
    }

    public String getShardedDatabaseInfo() {
        ConnectionSource cs = this.core.connectionSource();
        if (cs instanceof Topology) {
            return ((Topology)cs).getShardedDatabaseInfo();
        }
        return "No sharded database discovered by UCP";
    }

    public String getShardRoutingCacheInfo() {
        ConnectionSource cs = this.core.connectionSource();
        if (cs instanceof Topology) {
            return ((Topology)cs).getShardRoutingCacheInfo();
        }
        return "No shard routing cache built in UCP";
    }

    public int getQueryTimeout() {
        return this.queryTimeout.get();
    }

    public void setQueryTimeout(int queryTimeout) throws UniversalConnectionPoolException {
        if (queryTimeout < 0) {
            UCPErrorHandler.throwUniversalConnectionPoolException(6);
        }
        this.queryTimeout.set(queryTimeout);
    }

    @Override
    public int getLoginTimeout() {
        return this.loginTimeout.get();
    }

    @Override
    public void setLoginTimeout(int seconds) throws UniversalConnectionPoolException {
        if (seconds < 0) {
            UCPErrorHandler.throwUniversalConnectionPoolException(6);
        }
        this.loginTimeout.set(seconds);
    }

    public PrintWriter getLogWriter() {
        return this.logWriter;
    }

    public void setLogWriter(PrintWriter logWriter) {
        this.logWriter = logWriter;
    }

    @Log
    protected void ilogFinest(Logger logger, Class cls, Executable method, Object receiver, String message) {
        ClioSupport.ilogFinest(logger, cls, method, receiver, message);
        PrintWriter writer = this.getLogWriter();
        if (null != writer) {
            writer.print(message);
        }
    }

    @Log
    protected void ilogFine(Logger logger, Class cls, Executable method, Object receiver, String message) {
        ClioSupport.ilogFine(logger, cls, method, receiver, message);
        PrintWriter writer = this.getLogWriter();
        if (null != writer) {
            writer.print(message);
        }
    }

    @Log
    protected void ilogThrowing(Logger logger, Class cls, Executable method, Object receiver, Throwable throwable) {
        ClioSupport.ilogThrowing(logger, cls, method, receiver, throwable);
        PrintWriter writer = this.getLogWriter();
        if (null != writer) {
            writer.print(throwable.getMessage());
        }
    }

    static {
        try {
            $$$methodRef$$$136 = UniversalConnectionPoolBase.class.getDeclaredConstructor(ConnectionFactoryAdapter.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$136 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$135 = UniversalConnectionPoolBase.class.getDeclaredMethod("access$800", UniversalConnectionPoolBase.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$135 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$134 = UniversalConnectionPoolBase.class.getDeclaredMethod("access$700", UniversalConnectionPoolBase.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$134 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$133 = UniversalConnectionPoolBase.class.getDeclaredMethod("access$600", UniversalConnectionPoolBase.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$133 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$132 = UniversalConnectionPoolBase.class.getDeclaredMethod("access$500", UniversalConnectionPoolBase.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$132 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$131 = UniversalConnectionPoolBase.class.getDeclaredMethod("access$400", UniversalConnectionPoolBase.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$131 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$130 = UniversalConnectionPoolBase.class.getDeclaredMethod("access$300", UniversalConnectionPoolBase.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$130 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$129 = UniversalConnectionPoolBase.class.getDeclaredMethod("access$200", UniversalConnectionPoolBase.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$129 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$128 = UniversalConnectionPoolBase.class.getDeclaredMethod("access$100", UniversalConnectionPoolBase.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$128 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$127 = UniversalConnectionPoolBase.class.getDeclaredMethod("access$000", UniversalConnectionPoolBase.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$127 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$126 = UniversalConnectionPoolBase.class.getDeclaredMethod("setLogWriter", PrintWriter.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$126 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$125 = UniversalConnectionPoolBase.class.getDeclaredMethod("getLogWriter", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$125 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$124 = UniversalConnectionPoolBase.class.getDeclaredMethod("setLoginTimeout", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$124 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$123 = UniversalConnectionPoolBase.class.getDeclaredMethod("getLoginTimeout", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$123 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$122 = UniversalConnectionPoolBase.class.getDeclaredMethod("setQueryTimeout", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$122 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$121 = UniversalConnectionPoolBase.class.getDeclaredMethod("getQueryTimeout", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$121 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$120 = UniversalConnectionPoolBase.class.getDeclaredMethod("getShardRoutingCacheInfo", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$120 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$119 = UniversalConnectionPoolBase.class.getDeclaredMethod("getShardedDatabaseInfo", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$119 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$118 = UniversalConnectionPoolBase.class.getDeclaredMethod("getDatabaseTopologyInfo", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$118 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$117 = UniversalConnectionPoolBase.class.getDeclaredMethod("setMaxConnectionsPerShard", Integer.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$117 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$116 = UniversalConnectionPoolBase.class.getDeclaredMethod("getMaxConnectionsPerShard", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$116 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$115 = UniversalConnectionPoolBase.class.getDeclaredMethod("setConnectionRepurposeThreshold", Integer.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$115 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$114 = UniversalConnectionPoolBase.class.getDeclaredMethod("getConnectionRepurposeThreshold", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$114 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$113 = UniversalConnectionPoolBase.class.getDeclaredMethod("isShareable", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$113 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$112 = UniversalConnectionPoolBase.class.getDeclaredMethod("setShareable", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$112 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$111 = UniversalConnectionPoolBase.class.getDeclaredMethod("setMaxConnectionsPerService", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$111 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$110 = UniversalConnectionPoolBase.class.getDeclaredMethod("getMaxConnectionsPerService", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$110 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$109 = UniversalConnectionPoolBase.class.getDeclaredMethod("setHighCostConnectionReuseThreshold", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$109 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$108 = UniversalConnectionPoolBase.class.getDeclaredMethod("getHighCostConnectionReuseThreshold", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$108 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$107 = UniversalConnectionPoolBase.class.getDeclaredMethod("setConnectionLabelingHighCost", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$107 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$106 = UniversalConnectionPoolBase.class.getDeclaredMethod("getConnectionLabelingHighCost", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$106 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$105 = UniversalConnectionPoolBase.class.getDeclaredMethod("getCumulativeReturnedConnectionCount", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$105 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$104 = UniversalConnectionPoolBase.class.getDeclaredMethod("getConnectionLabelingCallback", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$104 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$103 = UniversalConnectionPoolBase.class.getDeclaredMethod("setLifecycleStopped", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$103 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$102 = UniversalConnectionPoolBase.class.getDeclaredMethod("setLifecycleRunning", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$102 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$101 = UniversalConnectionPoolBase.class.getDeclaredMethod("setLifecycleStopping", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$101 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$100 = UniversalConnectionPoolBase.class.getDeclaredMethod("setLifecycleStarting", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$100 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$99 = UniversalConnectionPoolBase.class.getDeclaredMethod("setLifecycleFailed", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$99 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$98 = UniversalConnectionPoolBase.class.getDeclaredMethod("isLifecycleFailed", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$98 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$97 = UniversalConnectionPoolBase.class.getDeclaredMethod("isLifecycleStopped", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$97 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$96 = UniversalConnectionPoolBase.class.getDeclaredMethod("isLifecycleStopping", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$96 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$95 = UniversalConnectionPoolBase.class.getDeclaredMethod("isLifecycleStarting", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$95 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$94 = UniversalConnectionPoolBase.class.getDeclaredMethod("isLifecycleRunning", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$94 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$93 = UniversalConnectionPoolBase.class.getDeclaredMethod("getAverageBorrowedConnectionsCount", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$93 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$92 = UniversalConnectionPoolBase.class.getDeclaredMethod("getCumulativeConnectionsCreated", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$92 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$91 = UniversalConnectionPoolBase.class.getDeclaredMethod("getPeakConnectionsCount", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$91 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$90 = UniversalConnectionPoolBase.class.getDeclaredMethod("getCumulativeConnectionUseTime", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$90 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$89 = UniversalConnectionPoolBase.class.getDeclaredMethod("getPeakConnectionWaitTime", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$89 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$88 = UniversalConnectionPoolBase.class.getDeclaredMethod("getCumulativeConnectionBorrowedCount", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$88 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$87 = UniversalConnectionPoolBase.class.getDeclaredMethod("getCumulativeFailedConnectionWaitTime", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$87 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$86 = UniversalConnectionPoolBase.class.getDeclaredMethod("getCumulativeSuccessfulConnectionWaitTime", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$86 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$85 = UniversalConnectionPoolBase.class.getDeclaredMethod("getCumulativeFailedConnectionWaitCount", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$85 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$84 = UniversalConnectionPoolBase.class.getDeclaredMethod("getCumulativeSuccessfulConnectionWaitCount", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$84 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$83 = UniversalConnectionPoolBase.class.getDeclaredMethod("getCumulativeConnectionReturnedCount", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$83 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$82 = UniversalConnectionPoolBase.class.getDeclaredMethod("getPendingRequestsCount", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$82 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$81 = UniversalConnectionPoolBase.class.getDeclaredMethod("getAbandonedConnectionsCount", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$81 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$80 = UniversalConnectionPoolBase.class.getDeclaredMethod("handleFailoverEvent", FailoverEvent.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$80 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$79 = UniversalConnectionPoolBase.class.getDeclaredMethod("getFailoverInfo", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$79 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$78 = UniversalConnectionPoolBase.class.getDeclaredMethod("setFailoverInfo", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$78 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$77 = UniversalConnectionPoolBase.class.getDeclaredMethod("setRuntimeLoadBalancingEnabled", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$77 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$76 = UniversalConnectionPoolBase.class.getDeclaredMethod("isRuntimeLoadBalancingEnabled", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$76 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$75 = UniversalConnectionPoolBase.class.getDeclaredMethod("setMaxConnectionReuseCount", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$75 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$74 = UniversalConnectionPoolBase.class.getDeclaredMethod("getMaxConnectionReuseCount", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$74 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$73 = UniversalConnectionPoolBase.class.getDeclaredMethod("setMaxConnectionReuseTime", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$73 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$72 = UniversalConnectionPoolBase.class.getDeclaredMethod("getMaxConnectionReuseTime", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$72 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$71 = UniversalConnectionPoolBase.class.getDeclaredMethod("setFailoverEnabled", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$71 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$70 = UniversalConnectionPoolBase.class.getDeclaredMethod("getFailoverEventHandlerTask", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$70 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$69 = UniversalConnectionPoolBase.class.getDeclaredMethod("isFailoverExplicitlySet", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$69 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$68 = UniversalConnectionPoolBase.class.getDeclaredMethod("isFailoverEnabled", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$68 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$67 = UniversalConnectionPoolBase.class.getDeclaredMethod("cancelReplaceNonReusableConnectionsTimer", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$67 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$66 = UniversalConnectionPoolBase.class.getDeclaredMethod("initReplaceNonReusableConnectionsTimer", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$66 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$65 = UniversalConnectionPoolBase.class.getDeclaredMethod("disableConnectionHarvestingTimer", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$65 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$64 = UniversalConnectionPoolBase.class.getDeclaredMethod("initConnectionHarvestingTimer", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$64 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$63 = UniversalConnectionPoolBase.class.getDeclaredMethod("getAbandonedConnectionTimer", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$63 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$62 = UniversalConnectionPoolBase.class.getDeclaredMethod("setAbandonedConnectionTimeout", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$62 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$61 = UniversalConnectionPoolBase.class.getDeclaredMethod("disableAbandonedConnectionTimeoutTimer", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$61 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$60 = UniversalConnectionPoolBase.class.getDeclaredMethod("validatePoolSizes", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$60 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$59 = UniversalConnectionPoolBase.class.getDeclaredMethod("initAbandonedConnectionTimeoutTimer", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$59 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$58 = UniversalConnectionPoolBase.class.getDeclaredMethod("processAbandonedConnections", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$58 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$57 = UniversalConnectionPoolBase.class.getDeclaredMethod("getAbandonedConnectionTimeout", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$57 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$56 = UniversalConnectionPoolBase.class.getDeclaredMethod("getConnectionAffinityCallback", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$56 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$55 = UniversalConnectionPoolBase.class.getDeclaredMethod("removeConnectionAffinityCallback", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$55 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$54 = UniversalConnectionPoolBase.class.getDeclaredMethod("registerConnectionAffinityCallback", ConnectionAffinityCallback.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$54 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$53 = UniversalConnectionPoolBase.class.getDeclaredMethod("removeConnectionLabelingCallback", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$53 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$52 = UniversalConnectionPoolBase.class.getDeclaredMethod("registerConnectionLabelingCallback", ConnectionLabelingCallback.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$52 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$51 = UniversalConnectionPoolBase.class.getDeclaredMethod("getServiceName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$51 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$50 = UniversalConnectionPoolBase.class.getDeclaredMethod("setConnectionRetrievalInfo", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$50 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$49 = UniversalConnectionPoolBase.class.getDeclaredMethod("getConnectionRetrievalInfo", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$49 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$48 = UniversalConnectionPoolBase.class.getDeclaredMethod("getConnectionFactoryAdapter", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$48 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$47 = UniversalConnectionPoolBase.class.getDeclaredMethod("getLifeCycleState", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$47 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$46 = UniversalConnectionPoolBase.class.getDeclaredMethod("getTotalConnectionsCount", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$46 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$45 = UniversalConnectionPoolBase.class.getDeclaredMethod("getBorrowedConnectionsCount", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$45 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$44 = UniversalConnectionPoolBase.class.getDeclaredMethod("getAvailableConnectionsCount", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$44 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$43 = UniversalConnectionPoolBase.class.getDeclaredMethod("incrementConnectionsClosedCount", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$43 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$42 = UniversalConnectionPoolBase.class.getDeclaredMethod("getConnectionsClosedCount", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$42 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$41 = UniversalConnectionPoolBase.class.getDeclaredMethod("incrementConnectionsCreatedCount", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$41 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$40 = UniversalConnectionPoolBase.class.getDeclaredMethod("getConnectionsCreatedCount", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$40 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$39 = UniversalConnectionPoolBase.class.getDeclaredMethod("setConnectionHarvestMaxCount", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$39 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$38 = UniversalConnectionPoolBase.class.getDeclaredMethod("getConnectionHarvestMaxCount", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$38 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$37 = UniversalConnectionPoolBase.class.getDeclaredMethod("setConnectionHarvestTriggerCount", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$37 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$36 = UniversalConnectionPoolBase.class.getDeclaredMethod("getConnectionHarvestTriggerCount", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$36 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$35 = UniversalConnectionPoolBase.class.getDeclaredMethod("setSecondsToTrustIdleConnection", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$35 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$34 = UniversalConnectionPoolBase.class.getDeclaredMethod("getSecondsToTrustIdleConnection", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$34 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$33 = UniversalConnectionPoolBase.class.getDeclaredMethod("setValidateConnectionOnBorrow", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$33 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$32 = UniversalConnectionPoolBase.class.getDeclaredMethod("getValidateConnectionOnBorrow", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$32 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$31 = UniversalConnectionPoolBase.class.getDeclaredMethod("setTimeoutCheckInterval", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$30 = UniversalConnectionPoolBase.class.getDeclaredMethod("getTimeoutCheckInterval", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$29 = UniversalConnectionPoolBase.class.getDeclaredMethod("getTimeToLiveConnectionTimer", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$28 = UniversalConnectionPoolBase.class.getDeclaredMethod("setTimeToLiveConnectionTimeout", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$27 = UniversalConnectionPoolBase.class.getDeclaredMethod("disableTimeToLiveConnectionTimeoutTimer", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$26 = UniversalConnectionPoolBase.class.getDeclaredMethod("initTimeToLiveConnectionTimeoutTimer", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$25 = UniversalConnectionPoolBase.class.getDeclaredMethod("processTimeToLiveTimeout", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$24 = UniversalConnectionPoolBase.class.getDeclaredMethod("getTimeToLiveConnectionTimeout", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$23 = UniversalConnectionPoolBase.class.getDeclaredMethod("setConnectionWaitTimeout", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$22 = UniversalConnectionPoolBase.class.getDeclaredMethod("getConnectionWaitTimeout", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$21 = UniversalConnectionPoolBase.class.getDeclaredMethod("getInactiveConnectionTimer", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$20 = UniversalConnectionPoolBase.class.getDeclaredMethod("setInactiveConnectionTimeout", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$19 = UniversalConnectionPoolBase.class.getDeclaredMethod("disableInactiveConnectionTimeoutTimer", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$18 = UniversalConnectionPoolBase.class.getDeclaredMethod("initInactiveConnectionTimeoutTimer", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$17 = UniversalConnectionPoolBase.class.getDeclaredMethod("getInactiveConnectionTimeout", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$16 = UniversalConnectionPoolBase.class.getDeclaredMethod("closePhysicalConnection", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$15 = UniversalConnectionPoolBase.class.getDeclaredMethod("setMaxPoolSize", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$14 = UniversalConnectionPoolBase.class.getDeclaredMethod("getMaxPoolSize", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$13 = UniversalConnectionPoolBase.class.getDeclaredMethod("setMinPoolSize", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$12 = UniversalConnectionPoolBase.class.getDeclaredMethod("getMinPoolSize", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$11 = UniversalConnectionPoolBase.class.getDeclaredMethod("setInitialPoolSize", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$10 = UniversalConnectionPoolBase.class.getDeclaredMethod("getInitialPoolSize", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$9 = UniversalConnectionPoolBase.class.getDeclaredMethod("setName", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$8 = UniversalConnectionPoolBase.class.getDeclaredMethod("getName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$7 = UniversalConnectionPoolBase.class.getDeclaredMethod("resetNonCumulativePoolStatistics", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$6 = UniversalConnectionPoolBase.class.getDeclaredMethod("resetAllPoolStatistics", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$5 = UniversalConnectionPoolBase.class.getDeclaredMethod("stop", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$4 = UniversalConnectionPoolBase.class.getDeclaredMethod("start", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$3 = UniversalConnectionPoolBase.class.getDeclaredMethod("reconfigure", Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$2 = UniversalConnectionPoolBase.class.getDeclaredMethod("setONSConfiguration", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$1 = UniversalConnectionPoolBase.class.getDeclaredMethod("getONSConfiguration", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$0 = UniversalConnectionPoolBase.class.getDeclaredMethod("onAvailable", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        DEFAULT_POOLNAME_PREFIX = "UniversalConnectionPool(" + UniversalConnectionPoolBase.class.hashCode() + ")-";
        m_poolsRunning = new AtomicInteger(0);
    }
}

