/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.api.repository2.unified;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class RepositoryRequest {
    private static final Pattern FILES_TYPES_PATTERN = FILES_TYPE_FILTER.getRegExPattern();
    private static final Pattern FILES_MEMBERS_INCLUDE_PATTERN = Pattern.compile("includeMembers=(.+)");
    private static final Pattern FILES_MEMBERS_EXCLUDE_PATTERN = Pattern.compile("excludeMembers=(.+)");
    public static final String PATH_SEPARATOR = "/";
    private String path;
    private boolean showHidden = false;
    private boolean includeAcls = false;
    private boolean includeSystemFolders = true;
    private Integer depth = -1;
    private FILES_TYPE_FILTER types = FILES_TYPE_FILTER.FILES_FOLDERS;
    private Set<String> includeMemberSet = null;
    private Set<String> excludeMemberSet = null;
    private transient String workingFilter;
    private String childNodeFilter;

    public RepositoryRequest() {
    }

    public RepositoryRequest(String path, Boolean showHidden, Integer depth, String legacyFilter) {
        this.path = path;
        this.showHidden = showHidden == null ? false : showHidden;
        this.setDepth(depth);
        this.setLegacyFilter(legacyFilter);
    }

    private void parseOutFileTypes() {
        this.types = FILES_TYPE_FILTER.FILES_FOLDERS;
        StringBuilder strippedFilter = new StringBuilder();
        if (!this.workingFilter.isEmpty()) {
            String[] parts;
            for (String part : parts = this.workingFilter.split("\\|")) {
                Matcher m = FILES_TYPES_PATTERN.matcher(part);
                if (m.matches()) {
                    FILES_TYPE_FILTER newType = FILES_TYPE_FILTER.valueOf(m.group(1));
                    if (newType == null) continue;
                    this.types = newType;
                    if (this.types != FILES_TYPE_FILTER.FILES || this.depth == 1) continue;
                    this.types = FILES_TYPE_FILTER.FILES_FOLDERS;
                    continue;
                }
                this.appendFilter(strippedFilter, part);
            }
        }
        this.workingFilter = strippedFilter.toString();
    }

    private void appendFilter(StringBuilder strippedFilter, String part) {
        if (strippedFilter.length() != 0) {
            strippedFilter.append("|");
        }
        strippedFilter.append(part);
    }

    private void parseOutIncludeExclude() {
        this.includeMemberSet = this.parseOutPattern(FILES_MEMBERS_INCLUDE_PATTERN);
        this.excludeMemberSet = this.parseOutPattern(FILES_MEMBERS_EXCLUDE_PATTERN);
        if (this.includeMemberSet != null && !this.includeMemberSet.isEmpty() && this.excludeMemberSet != null && !this.excludeMemberSet.isEmpty()) {
            throw new RuntimeException("Cannot include and exclude values in the same Legacy Filter");
        }
    }

    private Set<String> parseOutPattern(Pattern pattern) {
        StringBuilder strippedFilter = new StringBuilder();
        String[] parts = this.workingFilter.split("\\|");
        HashSet<String> memberSet = null;
        for (String part : parts) {
            Matcher m = pattern.matcher(part);
            if (m.matches()) {
                String includeMembersStr = m.group(1);
                memberSet = new HashSet<String>(Arrays.asList(includeMembersStr.split(",")));
                continue;
            }
            this.appendFilter(strippedFilter, part);
        }
        this.workingFilter = strippedFilter.toString();
        return memberSet;
    }

    private void setLegacyFilter(String legacyFilter) {
        this.workingFilter = legacyFilter == null || StringUtils.isEmpty((String)legacyFilter) ? "*" : legacyFilter;
        this.parseOutFileTypes();
        this.parseOutIncludeExclude();
        this.childNodeFilter = this.workingFilter.isEmpty() ? null : this.workingFilter;
        this.workingFilter = null;
    }

    public FILES_TYPE_FILTER getTypes() {
        return this.types;
    }

    public void setTypes(FILES_TYPE_FILTER types) {
        this.types = types;
    }

    public Set<String> getIncludeMemberSet() {
        return this.includeMemberSet;
    }

    public void setIncludeMemberSet(Set<String> includeMemberSet) {
        this.includeMemberSet = includeMemberSet;
    }

    public Set<String> getExcludeMemberSet() {
        return this.excludeMemberSet;
    }

    public void setExcludeMemberSet(Set<String> excludeMemberSet) {
        this.excludeMemberSet = excludeMemberSet;
    }

    public boolean isShowHidden() {
        return this.showHidden;
    }

    public boolean isIncludeSystemFolders() {
        return this.includeSystemFolders;
    }

    public void setIncludeSystemFolders(boolean includeSystemFolders) {
        this.includeSystemFolders = includeSystemFolders;
    }

    public void setShowHidden(boolean showHidden) {
        this.showHidden = showHidden;
    }

    public Integer getDepth() {
        return this.depth;
    }

    public void setDepth(Integer depth) {
        if (depth == null) {
            depth = -1;
        }
        this.depth = depth;
    }

    public String getChildNodeFilter() {
        return this.childNodeFilter;
    }

    public void setChildNodeFilter(String childNodeFilter) {
        this.childNodeFilter = childNodeFilter;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public boolean isIncludeAcls() {
        return this.includeAcls;
    }

    public void setIncludeAcls(boolean includeAcls) {
        this.includeAcls = includeAcls;
    }

    public static enum FILES_TYPE_FILTER {
        FILES,
        FOLDERS,
        FILES_FOLDERS;


        public static Pattern getRegExPattern() {
            StringBuilder sb = new StringBuilder("(PLACEHOLDER");
            for (FILES_TYPE_FILTER val : FILES_TYPE_FILTER.values()) {
                sb.append("|").append(val.toString());
            }
            sb.append(")");
            return Pattern.compile(sb.toString());
        }
    }
}

