/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.steps.infobrightoutput;

import com.infobright.etl.model.DataFormat;
import com.infobright.io.InfobrightNamedPipeLoader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.SortedMap;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.annotations.PluginDialog;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.infobrightoutput.InfobrightLoaderMeta;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.widget.TextVar;
import org.pentaho.di.ui.trans.step.BaseStepDialog;

@PluginDialog(id="InfobrightOutput", image="BLKIB.svg", pluginType=PluginDialog.PluginType.STEP, documentationUrl="https://pentaho-community.atlassian.net/wiki/display/EAI/Infobright%20Loader")
public class InfobrightLoaderDialog
extends BaseStepDialog
implements StepDialogInterface {
    private static Class<?> PKG = InfobrightLoaderMeta.class;
    private int middle;
    private CCombo serverConnection;
    private CCombo dataFormatSelect;
    protected BaseStepMeta input;
    private ModifyListener lsMod;
    private InfobrightLoaderMeta meta;
    private TextVar targetSchemaText;
    private TextVar targetTableText;
    private CCombo charsetSelect;
    private TextVar agentPortText;
    private TextVar debugFileText;
    private int verticalPadding = 0;

    public InfobrightLoaderDialog(Shell parent, Object in, TransMeta tr, String sname) {
        super(parent, (BaseStepMeta)in, tr, sname);
        this.input = (BaseStepMeta)in;
        this.meta = (InfobrightLoaderMeta)in;
        this.lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                InfobrightLoaderDialog.this.input.setChanged();
            }
        };
    }

    public String open() {
        this.shell = new Shell(this.getParent(), 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, (StepMetaInterface)this.input);
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"InfobrightLoaderDialog.Shell.Title", (String[])new String[0]));
        this.middle = this.props.getMiddlePct();
        int margin = 4;
        this.wlStepname = new Label((Composite)this.shell, 131072);
        this.wlStepname.setText(BaseMessages.getString(PKG, (String)"InfobrightLoaderDialog.Stepname.Label", (String[])new String[0]));
        this.wlStepname.setLayoutData((Object)this.standardLabelSpacing(null));
        this.props.setLook((Control)this.wlStepname);
        this.wStepname = new Text((Composite)this.shell, 18436);
        this.wStepname.setText(this.stepname);
        this.wStepname.addModifyListener(this.lsMod);
        this.wStepname.setLayoutData((Object)this.standardInputSpacing(null));
        this.props.setLook((Control)this.wStepname);
        Control lastControl = this.addDbConnectionInputs();
        lastControl = this.addCustomInputs(lastControl);
        this.addVerticalPadding(2 * margin);
        this.addDefaultButtons(margin, lastControl);
        this.getData();
        this.input.setChanged(this.changed);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            Display display = this.getParent().getDisplay();
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.stepname;
    }

    protected Control addDbConnectionInputs() {
        ArrayList<String> ibConnections = new ArrayList<String>();
        for (DatabaseMeta dbMeta : this.transMeta.getDatabases()) {
            if (!dbMeta.getDatabaseInterface().isMySQLVariant()) continue;
            ibConnections.add(dbMeta.getName());
        }
        this.serverConnection = this.addStandardSelect(BaseMessages.getString(PKG, (String)"InfobrightLoaderDialog.Connection.Label", (String[])new String[0]), (Control)this.wStepname, ibConnections.toArray(new String[ibConnections.size()]));
        return this.serverConnection;
    }

    protected Control addCustomInputs(Control prevControl) {
        String[] dataformats = new String[DataFormat.values().length];
        int i = 0;
        for (DataFormat format : DataFormat.values()) {
            dataformats[i++] = format.getDisplayText();
        }
        SortedMap<String, Charset> availableCharsetsMap = Charset.availableCharsets();
        String[] availableCharsets = new String[availableCharsetsMap.size()];
        int j = 0;
        for (String charsetName : availableCharsetsMap.keySet()) {
            availableCharsets[j++] = charsetName;
        }
        this.dataFormatSelect = this.addStandardSelect(BaseMessages.getString(PKG, (String)"InfobrightLoaderDialog.Dataformat.Label", (String[])new String[0]), prevControl, dataformats);
        this.targetSchemaText = this.addStandardTextVar(BaseMessages.getString(PKG, (String)"InfobrightLoaderDialog.TargetSchema.Label", (String[])new String[0]), (Control)this.dataFormatSelect);
        this.targetTableText = this.addStandardTextVar(BaseMessages.getString(PKG, (String)"InfobrightLoaderDialog.TargetTable.Label", (String[])new String[0]), (Control)this.targetSchemaText);
        this.charsetSelect = this.addStandardSelect(BaseMessages.getString(PKG, (String)"InfobrightLoaderDialog.Charset.Label", (String[])new String[0]), (Control)this.targetTableText, availableCharsets);
        this.agentPortText = this.addStandardTextVar(BaseMessages.getString(PKG, (String)"InfobrightLoaderDialog.AgentPort.Label", (String[])new String[0]), (Control)this.charsetSelect);
        this.debugFileText = this.addStandardTextVar(BaseMessages.getString(PKG, (String)"InfobrightLoaderDialog.DebugFile.Label", (String[])new String[0]), (Control)this.agentPortText);
        return this.debugFileText;
    }

    protected CCombo addStandardSelect(String labelMessageKey, Control prevControl, String[] choices) {
        int vertPad = this.verticalPadding;
        this.addStandardLabel(labelMessageKey, prevControl);
        this.verticalPadding = vertPad;
        CCombo combo = new CCombo((Composite)this.shell, 2048);
        combo.setItems(choices);
        combo.addModifyListener(this.lsMod);
        combo.setLayoutData((Object)this.standardInputSpacing(prevControl));
        return combo;
    }

    protected TextVar addStandardTextVar(String labelMessageKey, Control prevControl) {
        int vertPad = this.verticalPadding;
        this.addStandardLabel(labelMessageKey, prevControl);
        this.verticalPadding = vertPad;
        TextVar targetControl = new TextVar((VariableSpace)this.transMeta, (Composite)this.shell, 18436);
        targetControl.addModifyListener(this.lsMod);
        targetControl.setLayoutData((Object)this.standardInputSpacing(prevControl));
        return targetControl;
    }

    protected Button addStandardCheckBox(String labelMessageKey, Control prevControl) {
        this.addStandardLabel(labelMessageKey, prevControl);
        Button targetControl = new Button((Composite)this.shell, 32);
        targetControl.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InfobrightLoaderDialog.this.input.setChanged();
            }
        });
        targetControl.setLayoutData((Object)this.standardInputSpacing(prevControl));
        return targetControl;
    }

    private Label addStandardLabel(String messageString, Control previousControl) {
        Label label = new Label((Composite)this.shell, 131072);
        label.setText(messageString);
        label.setLayoutData((Object)this.standardLabelSpacing(previousControl));
        this.props.setLook((Control)label);
        return label;
    }

    private void addVerticalPadding(int amount) {
        this.verticalPadding += amount;
    }

    private FormData standardLabelSpacing(Control control) {
        return this.standardSpacing(control, true);
    }

    private FormData standardInputSpacing(Control control) {
        return this.standardSpacing(control, false);
    }

    private FormData standardSpacing(Control control, boolean isLabel) {
        FormData fd = new FormData();
        fd.left = isLabel ? new FormAttachment(0, 0) : new FormAttachment(this.middle, 0);
        fd.right = isLabel ? new FormAttachment(this.middle, -4) : new FormAttachment(100, 0);
        fd.top = control != null ? new FormAttachment(control, 4 + this.verticalPadding) : new FormAttachment(0, 4 + this.verticalPadding);
        this.verticalPadding = 0;
        return fd;
    }

    private void addDefaultButtons(int margin, Control lastControl) {
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOK, this.wCancel}, margin, lastControl);
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                InfobrightLoaderDialog.this.cancel();
            }
        };
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                InfobrightLoaderDialog.this.ok();
            }
        };
        this.wCancel.addListener(13, this.lsCancel);
        this.wOK.addListener(13, this.lsOK);
        this.lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                InfobrightLoaderDialog.this.ok();
            }
        };
        this.wStepname.addSelectionListener((SelectionListener)this.lsDef);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                InfobrightLoaderDialog.this.cancel();
            }
        });
        this.setSize();
    }

    public void getData() {
        if (this.meta.getDatabaseMeta() != null) {
            this.serverConnection.setText(this.meta.getDatabaseMeta().getName());
        }
        this.dataFormatSelect.setText(this.meta.getInfobrightProductType());
        this.targetSchemaText.setText(Const.NVL((String)this.meta.getSchemaName(), (String)""));
        this.targetTableText.setText(Const.NVL((String)this.meta.getTableName(), (String)""));
        this.charsetSelect.setText(this.meta.getCharset().name());
        this.agentPortText.setText(Integer.toString(this.meta.getAgentPort()));
        this.debugFileText.setText(Const.NVL((String)this.meta.getDebugFile(), (String)""));
        this.wStepname.selectAll();
        this.wStepname.setFocus();
    }

    protected void cancel() {
        this.stepname = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    protected void ok() {
        try {
            this.stepname = this.wStepname.getText();
            this.meta.setDatabaseMeta(this.transMeta.findDatabase(this.serverConnection.getText()));
            this.meta.setSchemaName(this.targetSchemaText.getText());
            this.meta.setTableName(this.targetTableText.getText());
            this.meta.setDataFormat(DataFormat.valueForDisplayName((String)this.dataFormatSelect.getText()));
            String charsetName = this.charsetSelect.getText();
            Charset charset2 = "".equals(charsetName) ? InfobrightNamedPipeLoader.DEFAULT_CHARSET : Charset.forName(charsetName);
            this.meta.setCharset(charset2);
            String agentPortStr = this.agentPortText.getText().trim();
            if ("".equals(agentPortStr)) {
                this.meta.setAgentPort(5555);
            } else {
                this.meta.setAgentPort(Integer.parseInt(agentPortStr));
            }
            this.meta.setDebugFile(this.debugFileText.getText());
            this.dispose();
        }
        catch (Exception e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"InfobrightLoaderDialog.Illegal.Dialog.Settings.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"InfobrightLoaderDialog.Illegal.Dialog.Settings.Message", (String[])new String[0]), e);
        }
    }

    public BaseStepMeta getInput() {
        return this.input;
    }
}

