/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.xul.swt.tab;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.pentaho.xul.swt.tab.TabListener;
import org.pentaho.xul.swt.tab.TabSet;

public class TabItem {
    private TabSet tabset;
    private CTabItem item;
    private String id;
    private String text;
    private Object control;
    private int[] sashWeights;
    private boolean changed;
    private List<TabListener> listeners = new ArrayList<TabListener>();

    public TabItem(TabSet tabset, String text, String id, int[] sashWeights) {
        this.tabset = tabset;
        this.id = id;
        this.sashWeights = sashWeights;
        this.item = this.createTabItem(tabset);
        this.setText(text);
        tabset.addTab(this);
    }

    public CTabItem getSwtTabItem() {
        return this.item;
    }

    public String getText() {
        return this.text;
    }

    public Object getControl() {
        return this.control;
    }

    public void setControl(Control control) {
        this.control = control;
        this.item.setControl(control);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public TabSet getTabset() {
        return this.tabset;
    }

    public void setTabset(TabSet tabset) {
        this.tabset = tabset;
    }

    public void setText(String text) {
        this.text = text;
        this.item.setText(text);
    }

    public boolean isDisposed() {
        return this.item.isDisposed();
    }

    public void dispose() {
        if (!this.isDisposed()) {
            if (this.control instanceof Composite) {
                ((Composite)this.control).dispose();
            }
            this.item.dispose();
            this.tabset.remove(this);
        }
    }

    public void setToolTipText(String tip) {
        this.item.setToolTipText(tip);
    }

    public void setImage(Image image) {
        this.item.setImage(image);
    }

    public void setChanged(boolean changed) {
        this.changed = changed;
        if (changed && this.tabset.getChangedFont() != null) {
            this.item.setFont(this.tabset.getChangedFont());
        } else if (!changed && this.tabset.getUnchangedFont() != null) {
            this.item.setFont(this.tabset.getUnchangedFont());
        }
    }

    public void addListener(TabListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(TabListener listener) {
        this.listeners.remove(listener);
    }

    public void notifySelectListeners() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).tabSelected(this);
        }
    }

    public void notifyDeselectListeners() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).tabDeselected(this);
        }
    }

    public boolean notifyCloseListeners() {
        boolean doit = true;
        for (int i = 0; i < this.listeners.size(); ++i) {
            doit &= this.listeners.get(i).tabClose(this);
        }
        return doit;
    }

    public boolean isChanged() {
        return this.changed;
    }

    protected CTabItem createTabItem(TabSet tabset) {
        return new CTabItem(tabset.getSwtTabset(), 64);
    }

    public int[] getSashWeights() {
        return this.sashWeights;
    }

    public void setSashWeights(int[] guiSizes) {
        this.sashWeights = guiSizes;
    }
}

