/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.step.common;

import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.ui.core.dialog.EnterNumberDialog;
import org.pentaho.di.ui.core.dialog.EnterTextDialog;
import org.pentaho.di.ui.core.dialog.SimpleMessageDialog;
import org.pentaho.di.ui.trans.step.common.GetFieldsCapableStepDialog;

public class GetFieldsSampleDataDialog
extends EnterNumberDialog {
    private static Class<?> PKG = GetFieldsSampleDataDialog.class;
    private static final int SAMPLE_SIZE = 100;
    private static final int SHELL_WIDTH = 300;
    private GetFieldsCapableStepDialog parentDialog;
    private boolean reloadAllFields;

    public GetFieldsSampleDataDialog(Shell parentShell, GetFieldsCapableStepDialog parentDialog, boolean reloadAllFields) {
        super(parentShell, 100, BaseMessages.getString(PKG, (String)"System.GetFields.SampleSize.Dialog.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.GetFields.SampleSize.Dialog.Message", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.GetFields.SampleSize.Dialog.ShowSample.Message", (String[])new String[0]), 300);
        this.parentDialog = parentDialog;
        this.reloadAllFields = reloadAllFields;
    }

    @Override
    protected void ok() {
        try {
            this.samples = Integer.parseInt(this.wNumber.getText());
            this.handleOk(this.samples);
            this.dispose();
        }
        catch (Exception e) {
            MessageBox mb = new MessageBox(this.getParent(), 33);
            mb.setMessage(BaseMessages.getString(PKG, (String)"Dialog.Error.EnterInteger", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)"Dialog.Error.Header", (String[])new String[0]));
            mb.open();
            this.wNumber.selectAll();
        }
    }

    protected void handleOk(int samples) {
        if (samples >= 0) {
            String message = this.parentDialog.loadFields(this.parentDialog.getPopulatedMeta(), samples, this.reloadAllFields);
            if (this.wCheckbox != null && this.wCheckbox.getSelection()) {
                if (StringUtils.isNotBlank((String)message)) {
                    EnterTextDialog etd = new EnterTextDialog(this.parentDialog.getShell(), BaseMessages.getString(PKG, (String)"System.GetFields.ScanResults.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.GetFields.ScanResults.DialogMessage", (String[])new String[0]), message, true);
                    etd.setReadOnly();
                    etd.setModal();
                    etd.open();
                } else {
                    SimpleMessageDialog errorDlg = new SimpleMessageDialog(this.parentDialog.getShell(), BaseMessages.getString(PKG, (String)"System.Dialog.Error.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.GetFields.ScanResults.Error.Message", (String[])new String[0]), 1);
                    errorDlg.open();
                }
            }
        }
    }
}

