/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.spoon.tree;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.swt.graphics.Image;
import org.pentaho.di.base.AbstractMeta;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.ui.core.widget.tree.TreeNode;
import org.pentaho.di.ui.spoon.tree.TreeFolderProvider;

public class RootNode
extends TreeNode {
    private List<TreeFolderProvider> treeFolderProviders = new ArrayList<TreeFolderProvider>();
    private Map<AbstractMeta, TreeNode> abstractMetas = new ConcurrentHashMap<AbstractMeta, TreeNode>();
    private Map<AbstractMeta, String> updates = new ConcurrentHashMap<AbstractMeta, String>();

    public RootNode(String label, Image image, boolean expanded) {
        super(label, image, expanded);
    }

    public void addProvider(TreeFolderProvider treeFolderProvider) {
        this.treeFolderProviders.add(treeFolderProvider);
    }

    public void addProviders(List<TreeFolderProvider> treeFolderProviders) {
        this.treeFolderProviders.addAll(treeFolderProviders);
    }

    public void addAbstractMeta(AbstractMeta abstractMeta, TreeNode treeNode) {
        this.abstractMetas.put(abstractMeta, treeNode);
    }

    public TreeNode create(AbstractMeta abstractMeta, Image image, boolean expanded) {
        TreeNode treeNode = new TreeNode(abstractMeta.getName(), image, expanded);
        this.addChild(treeNode);
        this.addAbstractMeta(abstractMeta, treeNode);
        this.treeFolderProviders.forEach(treeFolderProvider -> treeFolderProvider.create(abstractMeta, treeNode));
        return treeNode;
    }

    public void checkUpdate(AbstractMeta abstractMeta, String filter) {
        TreeNode treeNode = this.abstractMetas.get(abstractMeta);
        if (treeNode != null) {
            for (TreeFolderProvider treeFolderProvider : this.treeFolderProviders) {
                TreeNode childTreeNode = this.getChildTreeNode(treeNode, treeFolderProvider.getTitle());
                if (childTreeNode == null) continue;
                treeFolderProvider.checkUpdate(abstractMeta, childTreeNode, filter);
                if (Utils.isEmpty((CharSequence)filter)) continue;
                childTreeNode.setExpanded(true);
            }
        }
    }

    private TreeNode getChildTreeNode(TreeNode treeNode, String label) {
        for (TreeNode childTreeNode : treeNode.getChildren()) {
            if (!childTreeNode.getLabel().equals(label)) continue;
            return childTreeNode;
        }
        return null;
    }

    public String getNameByType(Class clazz) {
        TreeFolderProvider treeFolderProvider = this.treeFolderProviders.stream().filter(treeFolderProvider1 -> treeFolderProvider1.getType().equals(clazz)).findFirst().orElse(null);
        if (treeFolderProvider != null) {
            return treeFolderProvider.getTitle();
        }
        return null;
    }

    public void remove(AbstractMeta abstractMeta) {
        this.abstractMetas.remove(abstractMeta);
    }

    public TreeNode getTreeNode(AbstractMeta abstractMeta) {
        return this.abstractMetas.get(abstractMeta);
    }

    public void update(String name) {
        this.abstractMetas.keySet().forEach(abstractMeta -> this.updates.put((AbstractMeta)abstractMeta, name));
    }

    public void clearUpdates(AbstractMeta abstractMeta) {
        this.updates.remove(abstractMeta);
    }

    public boolean hasNode(AbstractMeta abstractMeta) {
        return this.abstractMetas.containsKey(abstractMeta);
    }

    public boolean shouldUpdate(AbstractMeta abstractMeta, String name) {
        return this.updates.containsKey(abstractMeta) && this.updates.get(abstractMeta).equalsIgnoreCase(name);
    }
}

