/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.spoon.trans;

import java.awt.Desktop;
import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Props;
import org.pentaho.di.core.logging.HasLogChannelInterface;
import org.pentaho.di.core.logging.KettleLogLayout;
import org.pentaho.di.core.logging.KettleLogStore;
import org.pentaho.di.core.logging.KettleLoggingEvent;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.logging.LogLevel;
import org.pentaho.di.core.logging.LogParentProvidedInterface;
import org.pentaho.di.core.logging.LoggingRegistry;
import org.pentaho.di.core.util.EnvUtil;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.ui.core.ConstUI;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.widget.text.Format;
import org.pentaho.di.ui.core.widget.text.TextFormatter;
import org.pentaho.di.ui.spoon.Spoon;

public class LogBrowser {
    private static Class<?> PKG = Spoon.class;
    private StyledText text;
    private LogParentProvidedInterface logProvider;
    private List<String> childIds = new ArrayList<String>();
    private Date lastLogRegistryChange;
    private AtomicBoolean paused;

    public LogBrowser(StyledText text, LogParentProvidedInterface logProvider) {
        this.text = text;
        this.logProvider = logProvider;
        this.paused = new AtomicBoolean(false);
    }

    public void installLogSniffer() {
        final AtomicInteger lastLogId = new AtomicInteger(-1);
        final AtomicBoolean busy = new AtomicBoolean(false);
        final KettleLogLayout logLayout = new KettleLogLayout(true);
        final Color colorBlue = GUIResource.getInstance().getColorBlue();
        final Color colorRed = GUIResource.getInstance().getColorRed();
        int LOG_LINE_ESTIMATED_SIZE = 150;
        int MAX_NR_LOG_LINES_CHUNK = 150;
        final Timer logRefreshTimer = new Timer("log sniffer Timer");
        TimerTask timerTask = new TimerTask(){

            @Override
            public void run() {
                if (LogBrowser.this.text.isDisposed() || LogBrowser.this.text.getDisplay().isDisposed()) {
                    return;
                }
                LogBrowser.this.text.getDisplay().asyncExec(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        HasLogChannelInterface provider = LogBrowser.this.logProvider.getLogChannelProvider();
                        if (provider != null && !LogBrowser.this.text.isDisposed() && !busy.get() && !LogBrowser.this.paused.get() && LogBrowser.this.text.isVisible()) {
                            int lastNr;
                            busy.set(true);
                            LogChannelInterface logChannel = provider.getLogChannel();
                            String parentLogChannelId = logChannel.getLogChannelId();
                            LoggingRegistry registry = LoggingRegistry.getInstance();
                            Date registryModDate = registry.getLastModificationTime();
                            if (LogBrowser.this.childIds == null || LogBrowser.this.lastLogRegistryChange == null || registryModDate.compareTo(LogBrowser.this.lastLogRegistryChange) > 0) {
                                LogBrowser.this.lastLogRegistryChange = registry.getLastModificationTime();
                                LogBrowser.this.childIds = LoggingRegistry.getInstance().getLogChannelChildren(parentLogChannelId);
                            }
                            if ((lastNr = KettleLogStore.getLastBufferLineNr()) > lastLogId.get()) {
                                lastNr = Math.min(lastNr, lastLogId.get() + 150);
                                List logLines = KettleLogStore.getLogBufferFromTo((List)LogBrowser.this.childIds, (boolean)true, (int)lastLogId.get(), (int)lastNr);
                                StyledText styledText = LogBrowser.this.text;
                                synchronized (styledText) {
                                    for (KettleLoggingEvent event : logLines) {
                                        String line = logLayout.format(event).trim();
                                        int start = LogBrowser.this.text.getText().length();
                                        int length = line.length();
                                        if (length <= 0) continue;
                                        Format format = TextFormatter.getInstance().execute(line);
                                        String theRealText = format.getText();
                                        length = theRealText.length();
                                        LogBrowser.this.text.append(theRealText);
                                        LogBrowser.this.text.append(Const.CR);
                                        for (StyleRange styleRange : format.getStyleRanges()) {
                                            styleRange.start += start;
                                            LogBrowser.this.text.setStyleRange(styleRange);
                                        }
                                        StyleRange styleRange = new StyleRange();
                                        styleRange.start = start;
                                        if (event.getLevel() == LogLevel.ERROR) {
                                            styleRange.foreground = colorRed;
                                            styleRange.length = length;
                                        } else {
                                            styleRange.foreground = colorBlue;
                                            styleRange.length = Math.min(20, length);
                                        }
                                        LogBrowser.this.text.setStyleRange(styleRange);
                                    }
                                }
                                int maxSize = Props.getInstance().getMaxNrLinesInLog() * 150;
                                int size = LogBrowser.this.text.getText().length();
                                if (maxSize > 0 && size > maxSize) {
                                    int dropIndex = LogBrowser.this.text.getText().indexOf(Const.CR, size - maxSize) + Const.CR.length();
                                    LogBrowser.this.text.replaceTextRange(0, dropIndex, "");
                                }
                                LogBrowser.this.text.setSelection(LogBrowser.this.text.getText().length());
                                lastLogId.set(lastNr);
                            }
                            busy.set(false);
                        }
                    }
                });
            }
        };
        logRefreshTimer.schedule(timerTask, Const.toInt((String)EnvUtil.getSystemProperty((String)"KETTLE_LOG_TAB_REFRESH_DELAY"), (int)1000), (long)Const.toInt((String)EnvUtil.getSystemProperty((String)"KETTLE_LOG_TAB_REFRESH_PERIOD"), (int)1000));
        this.text.addListener(3, e -> {
            try {
                int offset = this.text.getOffsetAtLocation(new Point(e.x, e.y));
                StyleRange style = this.text.getStyleRangeAtOffset(offset);
                if (style != null && style.underline && style.underlineStyle == 4 && Desktop.isDesktopSupported()) {
                    Desktop.getDesktop().browse(new URI((String)style.data));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.text.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                logRefreshTimer.cancel();
            }
        });
        final Menu menu = new Menu((Control)this.text);
        MenuItem item = new MenuItem(menu, 0);
        item.setText(BaseMessages.getString(PKG, (String)"LogBrowser.CopySelectionToClipboard.MenuItem", (String[])new String[0]));
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String selection = LogBrowser.this.text.getSelectionText();
                if (!Utils.isEmpty((CharSequence)selection)) {
                    GUIResource.getInstance().toClipboard(selection);
                }
            }
        });
        this.text.setMenu(menu);
        this.text.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent event) {
                if (event.button == 3) {
                    ConstUI.displayMenu(menu, (Control)LogBrowser.this.text);
                }
            }
        });
    }

    public StyledText getText() {
        return this.text;
    }

    public LogParentProvidedInterface getLogProvider() {
        return this.logProvider;
    }

    public boolean isPaused() {
        return this.paused.get();
    }

    public void setPaused(boolean paused) {
        this.paused.set(paused);
    }
}

