/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.spoon.delegates;

import java.util.List;
import org.pentaho.di.cluster.ClusterSchema;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.RepositoryElementInterface;
import org.pentaho.di.shared.SharedObjectInterface;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.ui.cluster.dialog.ClusterSchemaDialog;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.di.ui.spoon.delegates.SpoonSharedObjectDelegate;
import org.pentaho.di.ui.spoon.tree.provider.ClustersFolderProvider;

public class SpoonClustersDelegate
extends SpoonSharedObjectDelegate {
    public SpoonClustersDelegate(Spoon spoon) {
        super(spoon);
    }

    public void newClusteringSchema(TransMeta transMeta) {
        ClusterSchema clusterSchema = new ClusterSchema();
        ClusterSchemaDialog dialog = new ClusterSchemaDialog(this.spoon.getShell(), clusterSchema, transMeta.getClusterSchemas(), transMeta.getSlaveServers());
        if (dialog.open()) {
            block7: {
                List clusterSchemas = transMeta.getClusterSchemas();
                if (SpoonClustersDelegate.isDuplicate(clusterSchemas, (SharedObjectInterface)clusterSchema)) {
                    new ErrorDialog(this.spoon.getShell(), SpoonClustersDelegate.getMessage("Spoon.Dialog.ErrorSavingCluster.Title"), SpoonClustersDelegate.getMessage("Spoon.Dialog.ErrorSavingCluster.Message", clusterSchema.getName()), (Exception)((Object)new KettleException(SpoonClustersDelegate.getMessage("Spoon.Dialog.ErrorSavingCluster.NotUnique"))));
                    return;
                }
                clusterSchemas.add(clusterSchema);
                if (this.spoon.rep != null) {
                    try {
                        if (!this.spoon.rep.getSecurityProvider().isReadOnly()) {
                            this.spoon.rep.save((RepositoryElementInterface)clusterSchema, "Creation of initial version", null);
                            if (this.sharedObjectSyncUtil != null) {
                                this.sharedObjectSyncUtil.reloadTransformationRepositoryObjects(false);
                            }
                            break block7;
                        }
                        throw new KettleException(BaseMessages.getString((Class)PKG, (String)"Spoon.Dialog.Exception.ReadOnlyRepositoryUser", (String[])new String[0]));
                    }
                    catch (KettleException e) {
                        this.showSaveError(clusterSchema, e);
                    }
                }
            }
            this.refreshTree();
        }
    }

    private void showSaveError(ClusterSchema clusterSchema, KettleException e) {
        new ErrorDialog(this.spoon.getShell(), SpoonClustersDelegate.getMessage("Spoon.Dialog.ErrorSavingCluster.Title"), SpoonClustersDelegate.getMessage("Spoon.Dialog.ErrorSavingCluster.Message", clusterSchema.getName()), (Exception)((Object)e));
    }

    public void editClusterSchema(TransMeta transMeta, ClusterSchema clusterSchema) {
        ClusterSchemaDialog dialog = new ClusterSchemaDialog(this.spoon.getShell(), clusterSchema, transMeta.getClusterSchemas(), transMeta.getSlaveServers());
        if (dialog.open()) {
            if (this.spoon.rep != null && clusterSchema.getObjectId() != null) {
                try {
                    this.saveSharedObjectToRepository(clusterSchema, null);
                }
                catch (KettleException e) {
                    this.showSaveError(clusterSchema, e);
                }
            }
            this.sharedObjectSyncUtil.synchronizeClusterSchemas(clusterSchema);
            this.refreshTree();
        }
    }

    public void delClusterSchema(TransMeta transMeta, ClusterSchema clusterSchema) {
        try {
            int idx = transMeta.getClusterSchemas().indexOf(clusterSchema);
            transMeta.getClusterSchemas().remove(idx);
            if (this.spoon.rep != null && clusterSchema.getObjectId() != null) {
                this.spoon.rep.deleteClusterSchema(clusterSchema.getObjectId());
                if (this.sharedObjectSyncUtil != null) {
                    this.sharedObjectSyncUtil.deleteClusterSchema(clusterSchema);
                }
            }
            this.refreshTree();
        }
        catch (KettleException e) {
            new ErrorDialog(this.spoon.getShell(), BaseMessages.getString((Class)PKG, (String)"Spoon.Dialog.ErrorDeletingPartitionSchema.Title", (String[])new String[0]), BaseMessages.getString((Class)PKG, (String)"Spoon.Dialog.ErrorDeletingPartitionSchema.Message", (String[])new String[0]), (Exception)((Object)e));
        }
    }

    private void refreshTree() {
        this.spoon.refreshTree(ClustersFolderProvider.STRING_CLUSTERS);
    }
}

