/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.spoon;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettlePluginException;
import org.pentaho.di.core.plugins.PluginInterface;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.PluginTypeListener;
import org.pentaho.di.ui.spoon.SpoonLifecycleListener;
import org.pentaho.di.ui.spoon.SpoonPerspectiveManager;
import org.pentaho.di.ui.spoon.SpoonPluginCategories;
import org.pentaho.di.ui.spoon.SpoonPluginInterface;
import org.pentaho.di.ui.spoon.SpoonPluginType;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.XulException;

public class SpoonPluginManager
implements PluginTypeListener {
    private static SpoonPluginManager instance = new SpoonPluginManager();
    private Map<Object, SpoonPluginInterface> plugins = new HashMap<Object, SpoonPluginInterface>();
    private Map<String, List<SpoonPluginInterface>> pluginCategoryMap = new HashMap<String, List<SpoonPluginInterface>>();

    public void pluginAdded(Object serviceObject) {
        try {
            SpoonPluginInterface spoonPluginInterface = (SpoonPluginInterface)this.getPluginRegistry().loadClass((PluginInterface)serviceObject);
            if (this.plugins.get(serviceObject) != null) {
                return;
            }
            SpoonPluginCategories categories = spoonPluginInterface.getClass().getAnnotation(SpoonPluginCategories.class);
            if (categories != null) {
                for (String cat : categories.value()) {
                    List<SpoonPluginInterface> categoryList = this.pluginCategoryMap.get(cat);
                    if (categoryList == null) {
                        categoryList = new ArrayList<SpoonPluginInterface>();
                        this.pluginCategoryMap.put(cat, categoryList);
                    }
                    categoryList.add(spoonPluginInterface);
                }
            }
            if (spoonPluginInterface.getPerspective() != null) {
                this.getSpoonPerspectiveManager().addPerspective(spoonPluginInterface.getPerspective());
            }
            this.plugins.put(serviceObject, spoonPluginInterface);
        }
        catch (KettlePluginException e) {
            e.printStackTrace();
        }
    }

    public void pluginRemoved(Object serviceObject) {
        SpoonPluginInterface spoonPluginInterface = this.plugins.get(serviceObject);
        if (spoonPluginInterface == null) {
            return;
        }
        SpoonPluginCategories categories = spoonPluginInterface.getClass().getAnnotation(SpoonPluginCategories.class);
        if (categories != null) {
            for (String cat : categories.value()) {
                List<SpoonPluginInterface> categoryList = this.pluginCategoryMap.get(cat);
                categoryList.remove(spoonPluginInterface);
            }
        }
        if (spoonPluginInterface.getPerspective() != null) {
            this.getSpoonPerspectiveManager().removePerspective(spoonPluginInterface.getPerspective());
        }
        this.plugins.remove(serviceObject);
    }

    public void pluginChanged(Object serviceObject) {
    }

    public static SpoonPluginManager getInstance() {
        if (Const.isRunningOnWebspoonMode()) {
            try {
                Class<?> singletonUtil = Class.forName("org.eclipse.rap.rwt.SingletonUtil");
                Method getDeclaredMethod = singletonUtil.getDeclaredMethod("getSessionInstance", Class.class);
                return (SpoonPluginManager)getDeclaredMethod.invoke(null, SpoonPluginManager.class);
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
                return null;
            }
        }
        return instance;
    }

    public void applyPluginsForContainer(String category, XulDomContainer container) throws XulException {
        List<SpoonPluginInterface> plugins = this.pluginCategoryMap.get(category);
        if (plugins != null) {
            for (SpoonPluginInterface sp : plugins) {
                sp.applyToContainer(category, container);
            }
        }
    }

    public List<SpoonPluginInterface> getPlugins() {
        return Collections.unmodifiableList(Arrays.asList(this.plugins.values().toArray(new SpoonPluginInterface[0])));
    }

    public void notifyLifecycleListeners(SpoonLifecycleListener.SpoonLifeCycleEvent evt) {
        for (SpoonPluginInterface p : this.plugins.values()) {
            SpoonLifecycleListener listener = p.getLifecycleListener();
            if (listener == null) continue;
            listener.onEvent(evt);
        }
    }

    PluginRegistry getPluginRegistry() {
        return PluginRegistry.getInstance();
    }

    SpoonPerspectiveManager getSpoonPerspectiveManager() {
        return SpoonPerspectiveManager.getInstance();
    }

    private SpoonPluginManager() {
        PluginRegistry pluginRegistry = this.getPluginRegistry();
        pluginRegistry.addPluginListener(SpoonPluginType.class, (PluginTypeListener)this);
        List plugins = pluginRegistry.getPlugins(SpoonPluginType.class);
        for (PluginInterface plug : plugins) {
            this.pluginAdded(plug);
        }
    }
}

