/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.spoon;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.i18n.GlobalMessageUtil;
import org.pentaho.di.i18n.LanguageChoice;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.di.ui.spoon.SpoonPerspective;
import org.pentaho.di.ui.spoon.XulSpoonResourceBundle;
import org.pentaho.ui.xul.XulComponent;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.XulException;
import org.pentaho.ui.xul.XulOverlay;
import org.pentaho.ui.xul.containers.XulDeck;
import org.pentaho.ui.xul.containers.XulToolbar;
import org.pentaho.ui.xul.containers.XulVbox;
import org.pentaho.ui.xul.dom.Document;
import org.pentaho.ui.xul.dom.Element;
import org.pentaho.ui.xul.impl.XulEventHandler;
import org.pentaho.ui.xul.swt.tags.SwtDeck;
import org.pentaho.ui.xul.swt.tags.SwtVbox;

public class SpoonPerspectiveManager {
    private static Class<?> PKG = SpoonPerspectiveManager.class;
    private static SpoonPerspectiveManager instance = new SpoonPerspectiveManager();
    private final Map<Class<? extends SpoonPerspective>, SpoonPerspective> perspectives;
    private final Map<SpoonPerspective, PerspectiveManager> perspectiveManagerMap;
    private final LinkedHashSet<SpoonPerspective> orderedPerspectives;
    private XulDeck deck;
    private SpoonPerspective activePerspective;
    private XulDomContainer domContainer;
    private boolean forcePerspective = false;
    private String startupPerspective = null;
    private final LogChannelInterface log = new LogChannel((Object)this);
    private String[] defaultDisabled = new String[]{"schedulerPerspective"};
    private List<SpoonPerspective> installedPerspectives = new ArrayList<SpoonPerspective>();

    public String getStartupPerspective() {
        return this.startupPerspective;
    }

    public void setStartupPerspective(String startupPerspective) {
        this.startupPerspective = startupPerspective;
    }

    Map<SpoonPerspective, PerspectiveManager> getPerspectiveManagerMap() {
        return Collections.unmodifiableMap(this.perspectiveManagerMap);
    }

    private SpoonPerspectiveManager() {
        this.perspectives = new LinkedHashMap<Class<? extends SpoonPerspective>, SpoonPerspective>();
        this.perspectiveManagerMap = new HashMap<SpoonPerspective, PerspectiveManager>();
        this.orderedPerspectives = new LinkedHashSet();
    }

    public static SpoonPerspectiveManager getInstance() {
        if (Const.isRunningOnWebspoonMode()) {
            try {
                Class<?> webSpoonUtils = Class.forName("org.pentaho.di.webspoon.WebSpoonUtils");
                Method getUISession = webSpoonUtils.getDeclaredMethod("getUISession", new Class[0]);
                Class<?> singletonUtil = Class.forName("org.eclipse.rap.rwt.SingletonUtil");
                Method getUniqueInstance = (Method)Arrays.stream(singletonUtil.getDeclaredMethods()).filter(method -> method.getName().equals("getUniqueInstance") && method.toGenericString().contains("UISession")).collect(Collectors.toList()).get(0);
                return (SpoonPerspectiveManager)getUniqueInstance.invoke(null, SpoonPerspectiveManager.class, getUISession.invoke(null, new Object[0]));
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
                return null;
            }
        }
        return instance;
    }

    public void setDeck(XulDeck deck) {
        this.deck = deck;
    }

    public void setXulDoc(XulDomContainer doc) {
        this.domContainer = doc;
    }

    public void addPerspective(SpoonPerspective perspective) {
        if (this.activePerspective == null) {
            this.activePerspective = perspective;
        }
        this.perspectives.put(perspective.getClass(), perspective);
        this.orderedPerspectives.add(perspective);
        if (this.domContainer != null) {
            this.initialize();
        }
    }

    private void changePerspectiveVisibility(String perspectiveId, boolean hidePerspective) {
        for (SpoonPerspective sp : this.getPerspectiveManagerMap().keySet()) {
            if (!sp.getId().equals(perspectiveId)) continue;
            PerspectiveManager perspectiveManager = this.getPerspectiveManagerMap().get(sp);
            perspectiveManager.setPerspectiveHidden(sp.getDisplayName(Locale.getDefault()), hidePerspective);
            return;
        }
        this.getLogger().logError("Perspective with " + perspectiveId + " is not found.");
    }

    public void showPerspective(String perspectiveId) {
        this.changePerspectiveVisibility(perspectiveId, false);
    }

    public void hidePerspective(String perspectiveId) {
        this.changePerspectiveVisibility(perspectiveId, true);
    }

    public List<SpoonPerspective> getPerspectives() {
        return Collections.unmodifiableList(new ArrayList<SpoonPerspective>(this.orderedPerspectives));
    }

    private void unloadPerspective(SpoonPerspective per) {
        per.setActive(false);
        List<XulOverlay> overlays = per.getOverlays();
        if (overlays != null) {
            for (XulOverlay overlay : overlays) {
                try {
                    this.domContainer.removeOverlay(overlay.getOverlayUri());
                }
                catch (XulException e) {
                    this.log.logError("Error unload perspective", (Throwable)e);
                }
            }
        }
        this.getSpoon().enableMenus();
    }

    public void activatePerspective(Class<? extends SpoonPerspective> clazz) throws KettleException {
        List<XulEventHandler> theXulEventHandlers;
        if (this.forcePerspective) {
            return;
        }
        SpoonPerspective sp = this.perspectives.get(clazz);
        if (sp == null) {
            throw new KettleException("Could not locate perspective by class: " + clazz);
        }
        PerspectiveManager perspectiveManager = this.getPerspectiveManagerMap().get(sp);
        if (perspectiveManager != null) {
            perspectiveManager.initializeIfNeeded();
        }
        this.unloadPerspective(this.activePerspective);
        this.activePerspective = sp;
        List<XulOverlay> overlays = sp.getOverlays();
        if (overlays != null) {
            for (XulOverlay overlay : overlays) {
                try {
                    ResourceBundle res = null;
                    if (overlay.getResourceBundleUri() != null) {
                        try {
                            res = GlobalMessageUtil.getBundle((String)overlay.getResourceBundleUri(), SpoonPerspectiveManager.class);
                        }
                        catch (MissingResourceException missingResourceException) {}
                    } else {
                        try {
                            res = GlobalMessageUtil.getBundle((String)overlay.getOverlayUri().replace(".xul", ".properties"), SpoonPerspectiveManager.class);
                        }
                        catch (MissingResourceException missingResourceException) {
                            // empty catch block
                        }
                    }
                    if (res == null) {
                        res = new XulSpoonResourceBundle(sp.getClass());
                    }
                    this.domContainer.loadOverlay(overlay.getOverlayUri(), (Object)res);
                }
                catch (XulException e) {
                    this.log.logError("Error activate perspective", (Throwable)e);
                }
            }
        }
        if ((theXulEventHandlers = sp.getEventHandlers()) != null) {
            for (XulEventHandler handler : theXulEventHandlers) {
                this.domContainer.addEventHandler(handler);
            }
        }
        sp.setActive(true);
        if (sp.equals(this.activePerspective)) {
            this.deck.setSelectedIndex(this.deck.getChildNodes().indexOf(this.deck.getElementById("perspective-" + sp.getId())));
            this.getSpoon().enableMenus();
        }
    }

    public SpoonPerspective getActivePerspective() {
        return this.activePerspective;
    }

    public boolean isForcePerspective() {
        return this.forcePerspective;
    }

    public void setForcePerspective(boolean forcePerspective) {
        this.forcePerspective = forcePerspective;
    }

    public void removePerspective(SpoonPerspective per) {
        this.perspectives.remove(per);
        this.orderedPerspectives.remove(per);
        Document document = this.domContainer.getDocumentRoot();
        XulComponent comp = document.getElementById("perspective-" + per.getId());
        comp.getParent().removeChild((Element)comp);
        comp = document.getElementById("perspective-btn-" + per.getId());
        comp.getParent().removeChild((Element)comp);
        XulToolbar mainToolbar = (XulToolbar)this.domContainer.getDocumentRoot().getElementById("main-toolbar");
        ((Composite)mainToolbar.getManagedObject()).layout(true, true);
        this.deck.setSelectedIndex(0);
    }

    public void initialize() {
        XulToolbar mainToolbar = (XulToolbar)this.domContainer.getDocumentRoot().getElementById("main-toolbar");
        SwtDeck deck = (SwtDeck)this.domContainer.getDocumentRoot().getElementById("canvas-deck");
        int y = 0;
        int perspectiveIdx = 0;
        Class<?> perClass = null;
        List<SpoonPerspective> perspectives = this.getPerspectives();
        if (this.startupPerspective != null) {
            for (int i = 0; i < perspectives.size(); ++i) {
                if (!perspectives.get(i).getId().equals(this.startupPerspective)) continue;
                perspectiveIdx = i;
                break;
            }
        }
        final ArrayList<PerspectiveData> perspectiveList = new ArrayList<PerspectiveData>();
        final ToolBar swtToolbar = (ToolBar)mainToolbar.getManagedObject();
        final Shell shell = swtToolbar.getShell();
        ToolItem perspectiveButton = new ToolItem(swtToolbar, 4, 7);
        perspectiveButton.setImage(GUIResource.getInstance().getImage("ui/images/perspective_changer.svg"));
        perspectiveButton.setToolTipText(BaseMessages.getString(PKG, (String)"Spoon.Menu.View.Perspectives", (String[])new String[0]));
        perspectiveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Menu menu = new Menu((Control)shell);
                for (final PerspectiveData perspectiveData : perspectiveList) {
                    MenuItem item = new MenuItem(menu, 32);
                    if (perspectiveData.isHidden()) {
                        item.setEnabled(false);
                    }
                    if (SpoonPerspectiveManager.this.activePerspective.getId().equals(perspectiveData.getId())) {
                        item.setSelection(true);
                    }
                    item.setText(perspectiveData.getName());
                    item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent selectionEvent) {
                            Spoon.getInstance().loadPerspective(perspectiveData.getId());
                            swtToolbar.forceFocus();
                        }
                    });
                }
                ToolItem item = (ToolItem)e.widget;
                Rectangle rect = item.getBounds();
                Point pt = item.getParent().toDisplay(new Point(rect.x, rect.y + rect.height));
                menu.setLocation(pt.x, pt.y);
                menu.setVisible(true);
            }
        });
        for (SpoonPerspective per : this.getPerspectives()) {
            if (this.installedPerspectives.contains(per)) {
                ++y;
                continue;
            }
            String name = per.getDisplayName(LanguageChoice.getInstance().getDefaultLocale());
            PerspectiveData perspectiveData = new PerspectiveData(name, per.getId());
            if (Arrays.asList(this.defaultDisabled).contains(per.getId())) {
                perspectiveData.setHidden(true);
            }
            perspectiveList.add(perspectiveData);
            SwtVbox box = deck.createVBoxCard();
            box.setId("perspective-" + per.getId());
            box.setFlex(1);
            deck.addChild((Element)box);
            PerspectiveManager perspectiveManager = new PerspectiveManager(per, (XulVbox)box, mainToolbar, perspectiveList, name);
            this.perspectiveManagerMap.put(per, perspectiveManager);
            if (perspectiveIdx == y || y == 0) {
                if (perspectiveIdx == y) {
                    perClass = per.getClass();
                }
                perspectiveManager.initializeIfNeeded();
            }
            ++y;
            this.installedPerspectives.add(per);
        }
        deck.setSelectedIndex(perspectiveIdx);
        if (perClass != null) {
            try {
                this.activatePerspective(perClass);
                SpoonPerspectiveManager.getInstance().setForcePerspective(true);
            }
            catch (KettleException kettleException) {
                // empty catch block
            }
        }
    }

    Spoon getSpoon() {
        return Spoon.getInstance();
    }

    LogChannelInterface getLogger() {
        return this.log;
    }

    static class PerspectiveData {
        private String name;
        private String id;
        private boolean hidden = false;

        public PerspectiveData(String name, String id) {
            this.name = name;
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public String getId() {
            return this.id;
        }

        public boolean isHidden() {
            return this.hidden;
        }

        public void setHidden(boolean hidden) {
            this.hidden = hidden;
        }
    }

    static class PerspectiveManager {
        private final SpoonPerspective per;
        private final XulVbox box;
        private final XulToolbar mainToolbar;
        private final List<PerspectiveData> perspectiveList;
        private final String name;
        private boolean initialized;

        public PerspectiveManager(SpoonPerspective per, XulVbox box, XulToolbar mainToolbar, List<PerspectiveData> perspectiveList, String name) {
            this.per = per;
            this.box = box;
            this.mainToolbar = mainToolbar;
            this.perspectiveList = perspectiveList;
            this.name = name;
            this.initialized = false;
        }

        public void initializeIfNeeded() {
            if (!this.initialized) {
                this.performInit();
                this.initialized = true;
            }
        }

        void performInit() {
            this.per.getUI().setParent((Composite)this.box.getManagedObject());
            this.per.getUI().layout();
            ((Composite)this.mainToolbar.getManagedObject()).layout(true, true);
        }

        void setPerspectiveHidden(String perspectiveName, boolean hidden) {
            for (PerspectiveData perspectiveData : this.perspectiveList) {
                if (!perspectiveData.getName().equals(perspectiveName)) continue;
                perspectiveData.setHidden(hidden);
            }
        }
    }

    protected static class SpoonPerspectiveComparator
    implements Comparator<SpoonPerspective> {
        protected SpoonPerspectiveComparator() {
        }

        @Override
        public int compare(SpoonPerspective o1, SpoonPerspective o2) {
            return o1.getId().compareTo(o2.getId());
        }
    }
}

