/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.repository.dialog;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.ProgressMonitorAdapter;
import org.pentaho.di.core.ProgressMonitorListener;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.imp.ImportRules;
import org.pentaho.di.repository.ExportFeedback;
import org.pentaho.di.repository.IRepositoryExporter;
import org.pentaho.di.repository.IRepositoryExporterFeedback;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.di.ui.core.dialog.EnterTextDialog;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.repository.dialog.RepositoryDialogInterface;

public class RepositoryExportProgressDialog {
    private static Class<?> PKG = RepositoryDialogInterface.class;
    private Shell shell;
    private Repository rep;
    private RepositoryDirectoryInterface dir;
    private String filename;
    private ImportRules importRules;
    private LogChannelInterface log;

    public RepositoryExportProgressDialog(Shell shell, Repository rep, RepositoryDirectoryInterface dir, String filename) {
        this(shell, rep, dir, filename, new ImportRules());
    }

    public RepositoryExportProgressDialog(Shell shell, Repository rep, RepositoryDirectoryInterface dir, String filename, ImportRules importRules) {
        this.shell = shell;
        this.rep = rep;
        this.dir = dir;
        this.filename = filename;
        this.importRules = importRules;
        this.log = rep.getLog();
    }

    public boolean open() {
        boolean retval = true;
        final ArrayList<ExportFeedback> list = new ArrayList<ExportFeedback>();
        IRepositoryExporter tmpExporter = null;
        try {
            tmpExporter = this.rep.getExporter();
        }
        catch (KettleException e) {
            this.log.logError(RepositoryExportProgressDialog.class.toString(), new Object[]{"Error creating repository: " + e.toString()});
            this.log.logError(Const.getStackTracker((Throwable)e));
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"RepositoryExportDialog.ErrorExport.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"RepositoryExportDialog.ErrorExport.Message", (String[])new String[0]), (Exception)((Object)e));
            return false;
        }
        final IRepositoryExporter exporter = tmpExporter;
        final boolean isFeedback = exporter instanceof IRepositoryExporterFeedback;
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    exporter.setImportRulesToValidate(RepositoryExportProgressDialog.this.importRules);
                    ProgressMonitorAdapter pMonitor = new ProgressMonitorAdapter(monitor);
                    if (isFeedback) {
                        IRepositoryExporterFeedback fExporter = (IRepositoryExporterFeedback)IRepositoryExporterFeedback.class.cast(exporter);
                        List ret = fExporter.exportAllObjectsWithFeedback((ProgressMonitorListener)pMonitor, RepositoryExportProgressDialog.this.filename, RepositoryExportProgressDialog.this.dir, "all");
                        list.addAll(ret);
                    } else {
                        exporter.exportAllObjects((ProgressMonitorListener)pMonitor, RepositoryExportProgressDialog.this.filename, RepositoryExportProgressDialog.this.dir, "all");
                    }
                }
                catch (KettleException e) {
                    throw new InvocationTargetException(e, BaseMessages.getString((Class)PKG, (String)"RepositoryExportDialog.Error.CreateUpdate", (String[])new String[]{Const.getStackTracker((Throwable)e)}));
                }
            }
        };
        try {
            ProgressMonitorDialog pmd = new ProgressMonitorDialog(this.shell);
            pmd.run(true, true, op);
            if (!pmd.getProgressMonitor().isCanceled() && isFeedback) {
                IRepositoryExporterFeedback fExporter = (IRepositoryExporterFeedback)IRepositoryExporterFeedback.class.cast(exporter);
                this.showExportResultStatus(list, fExporter.isRulesViolation());
            }
        }
        catch (InvocationTargetException e) {
            this.log.logError(RepositoryExportProgressDialog.class.toString(), new Object[]{"Error creating repository: " + e.toString()});
            this.log.logError(Const.getStackTracker((Throwable)e));
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"RepositoryExportDialog.ErrorExport.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"RepositoryExportDialog.ErrorExport.Message", (String[])new String[0]), e);
            retval = false;
        }
        catch (InterruptedException e) {
            this.log.logError(RepositoryExportProgressDialog.class.toString(), new Object[]{"Error creating repository: " + e.toString()});
            this.log.logError(Const.getStackTracker((Throwable)e));
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"RepositoryExportDialog.ErrorExport.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"RepositoryExportDialog.ErrorExport.Message", (String[])new String[0]), e);
            retval = false;
        }
        return retval;
    }

    void showExportResultStatus(List<ExportFeedback> list, boolean fail) {
        String desc = fail ? BaseMessages.getString(PKG, (String)"RepositoryExportProgressDialog.ExportResultDialog.Fail", (String[])new String[0]) : BaseMessages.getString(PKG, (String)"RepositoryExportProgressDialog.ExportResultDialog.Succes", (String[])new String[0]);
        EnterTextDialog dialog = new EnterTextDialog(this.shell, BaseMessages.getString(PKG, (String)"RepositoryExportProgressDialog.ExportResultDialog.Title", (String[])new String[0]), desc, this.getExportResultDetails(list, fail));
        dialog.setReadOnly();
        dialog.setModal();
        dialog.open();
    }

    private String getExportResultDetails(List<ExportFeedback> list, boolean fail) {
        StringBuilder sb = new StringBuilder();
        for (ExportFeedback feedback : list) {
            if (fail && (feedback.getResult() == null || feedback.getResult().isEmpty())) {
                if (!feedback.isSimpleString()) continue;
                sb.append(feedback.toString());
                continue;
            }
            sb.append(feedback.toString());
        }
        return sb.toString();
    }

    public static MessageBox checkIsFileIsAcceptable(Shell shell, LogChannelInterface log, String filename) {
        MessageBox box = null;
        try {
            FileObject output = KettleVFS.getFileObject((String)filename);
            if (output.exists()) {
                if (!output.isWriteable()) {
                    box = new MessageBox(shell, 268501284);
                    box.setText(BaseMessages.getString(PKG, (String)"RepositoryExportProgressDialog.ExportFileDialog.AreadyExists", (String[])new String[0]));
                    box.setMessage(BaseMessages.getString(PKG, (String)"RepositoryExportProgressDialog.ExportFileDialog.NoWritePermissions", (String[])new String[0]));
                    return box;
                }
                box = new MessageBox(shell, 268501284);
                box.setText(BaseMessages.getString(PKG, (String)"RepositoryExportProgressDialog.ExportFileDialog.AreadyExists", (String[])new String[0]));
                box.setMessage(BaseMessages.getString(PKG, (String)"RepositoryExportProgressDialog.ExportFileDialog.Overwrite", (String[])new String[0]));
            }
        }
        catch (KettleFileException e) {
            log.logError("Can't access file: " + filename);
        }
        catch (FileSystemException e) {
            log.logError("Can't check if file exists/file permissions: " + filename);
        }
        return box;
    }
}

