/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.job.entries.trans;

import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.pentaho.di.base.AbstractMeta;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.ObjectLocationSpecificationMethod;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.extension.ExtensionPointHandler;
import org.pentaho.di.core.extension.KettleExtensionPoint;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.logging.LogLevel;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.trans.JobEntryTrans;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryDialogInterface;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryObject;
import org.pentaho.di.repository.RepositoryObjectType;
import org.pentaho.di.trans.TransExecutionConfiguration;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.dialog.SimpleMessageDialog;
import org.pentaho.di.ui.core.events.dialog.FilterType;
import org.pentaho.di.ui.core.events.dialog.SelectionOperation;
import org.pentaho.di.ui.core.gui.WindowProperty;
import org.pentaho.di.ui.core.widget.ComboVar;
import org.pentaho.di.ui.job.dialog.JobDialog;
import org.pentaho.di.ui.job.entries.trans.JobEntryBaseDialog;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.di.ui.trans.step.BaseStepDialog;
import org.pentaho.di.ui.util.DialogHelper;
import org.pentaho.di.ui.util.DialogUtils;
import org.pentaho.di.ui.util.SwtSvgImageUtil;

public class JobEntryTransDialog
extends JobEntryBaseDialog
implements JobEntryDialogInterface {
    private static Class<?> PKG = JobEntryTrans.class;
    protected Button wSuppressResultData;
    protected JobEntryTrans jobEntry;
    private static final String[] FILE_FILTERLOGNAMES = new String[]{BaseMessages.getString(PKG, (String)"JobTrans.Fileformat.TXT", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobTrans.Fileformat.LOG", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobTrans.Fileformat.All", (String[])new String[0])};

    public JobEntryTransDialog(Shell parent, JobEntryInterface jobEntryInt, Repository rep, JobMeta jobMeta) {
        super(parent, jobEntryInt, rep, jobMeta);
        this.jobEntry = (JobEntryTrans)jobEntryInt;
    }

    public JobEntryInterface open() {
        Shell parent = this.getParent();
        this.display = parent.getDisplay();
        this.shell = new Shell(parent, this.props.getJobsDialogStyle());
        this.props.setLook((Control)this.shell);
        JobDialog.setShellImage(this.shell, (JobEntryInterface)this.jobEntry);
        this.backupChanged = this.jobEntry.hasChanged();
        this.createElements();
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                JobEntryTransDialog.this.cancel();
            }
        });
        this.getData();
        this.setActive();
        BaseStepDialog.setSize(this.shell);
        int width = 750;
        int height = Const.isWindows() ? 730 : 720;
        this.shell.setSize(width, height);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
        return this.jobEntry;
    }

    @Override
    protected void createElements() {
        super.createElements();
        this.shell.setText(BaseMessages.getString(PKG, (String)"JobTrans.Header", (String[])new String[0]));
        this.wlPath.setText(BaseMessages.getString(PKG, (String)"JobTrans.JobStep.Transformation.Label", (String[])new String[0]));
        this.wPassParams.setText(BaseMessages.getString(PKG, (String)"JobTrans.PassAllParameters.Label", (String[])new String[0]));
        this.wClearRows = new Button((Composite)this.gExecution, 32);
        this.props.setLook((Control)this.wClearRows);
        this.wClearRows.setText(BaseMessages.getString(PKG, (String)"JobTrans.ClearResultList.Label", (String[])new String[0]));
        FormData fdbClearRows = new FormData();
        fdbClearRows.left = new FormAttachment(0, 0);
        fdbClearRows.top = new FormAttachment((Control)this.wEveryRow, 10);
        this.wClearRows.setLayoutData((Object)fdbClearRows);
        this.wClearFiles = new Button((Composite)this.gExecution, 32);
        this.props.setLook((Control)this.wClearFiles);
        this.wClearFiles.setText(BaseMessages.getString(PKG, (String)"JobTrans.ClearResultFiles.Label", (String[])new String[0]));
        FormData fdbClearFiles = new FormData();
        fdbClearFiles.left = new FormAttachment(0, 0);
        fdbClearFiles.top = new FormAttachment((Control)this.wClearRows, 10);
        this.wClearFiles.setLayoutData((Object)fdbClearFiles);
        this.wWaitingToFinish = new Button((Composite)this.gExecution, 32);
        this.props.setLook((Control)this.wWaitingToFinish);
        this.wWaitingToFinish.setText(BaseMessages.getString(PKG, (String)"JobTrans.WaitToFinish.Label", (String[])new String[0]));
        FormData fdWait = new FormData();
        fdWait.top = new FormAttachment((Control)this.wClearFiles, 10);
        fdWait.left = new FormAttachment(0, 0);
        this.wWaitingToFinish.setLayoutData((Object)fdWait);
        this.wFollowingAbortRemotely = new Button((Composite)this.gExecution, 32);
        this.props.setLook((Control)this.wFollowingAbortRemotely);
        this.wFollowingAbortRemotely.setText(BaseMessages.getString(PKG, (String)"JobTrans.AbortRemote.Label", (String[])new String[0]));
        FormData fdFollow = new FormData();
        fdFollow.top = new FormAttachment((Control)this.wWaitingToFinish, 10);
        fdFollow.left = new FormAttachment(0, 0);
        this.wFollowingAbortRemotely.setLayoutData((Object)fdFollow);
        this.wSuppressResultData = new Button((Composite)this.gExecution, 32);
        this.props.setLook((Control)this.wSuppressResultData);
        this.wSuppressResultData.setText(BaseMessages.getString(PKG, (String)"JobTrans.SuppressResults.Label", (String[])new String[0]));
        FormData fdSuppress = new FormData();
        fdSuppress.top = new FormAttachment((Control)this.wFollowingAbortRemotely, 10);
        fdSuppress.left = new FormAttachment(0, 0);
        this.wSuppressResultData.setLayoutData((Object)fdSuppress);
        Composite cRunConfiguration = new Composite(this.wOptions, 0);
        cRunConfiguration.setLayout((Layout)new FormLayout());
        this.props.setLook((Control)cRunConfiguration);
        FormData fdLocal = new FormData();
        fdLocal.top = new FormAttachment(0);
        fdLocal.right = new FormAttachment(100);
        fdLocal.left = new FormAttachment(0);
        cRunConfiguration.setBackground(this.shell.getBackground());
        cRunConfiguration.setLayoutData((Object)fdLocal);
        Label wlRunConfiguration = new Label(cRunConfiguration, 16384);
        this.props.setLook((Control)wlRunConfiguration);
        wlRunConfiguration.setText("Run configuration:");
        FormData fdlRunConfiguration = new FormData();
        fdlRunConfiguration.top = new FormAttachment(0);
        fdlRunConfiguration.left = new FormAttachment(0);
        wlRunConfiguration.setLayoutData((Object)fdlRunConfiguration);
        this.wRunConfiguration = new ComboVar((VariableSpace)this.jobMeta, cRunConfiguration, 2048);
        this.props.setLook((Control)this.wRunConfiguration);
        FormData fdRunConfiguration = new FormData();
        fdRunConfiguration.width = 200;
        fdRunConfiguration.top = new FormAttachment((Control)wlRunConfiguration, 5);
        fdRunConfiguration.left = new FormAttachment(0);
        this.wRunConfiguration.setLayoutData(fdRunConfiguration);
        this.wRunConfiguration.addModifyListener(new JobEntryBaseDialog.RunConfigurationModifyListener());
        this.fdgExecution.top = new FormAttachment((Control)cRunConfiguration, 10);
        this.wbGetParams.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                JobEntryTransDialog.this.getParameters(null);
            }
        });
        this.wbBrowse.addSelectionListener((SelectionListener)DialogHelper.constructSelectionAdapterFileDialogTextVarForKettleFile(this.log, this.wPath, (AbstractMeta)this.jobMeta, SelectionOperation.FILE, FilterType.KTR, this.rep));
        this.wbLogFilename.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JobEntryTransDialog.this.selectLogFile(FILE_FILTERLOGNAMES);
            }
        });
    }

    @Override
    protected JobEntryBase getJobEntry() {
        return this.jobEntry;
    }

    @Override
    protected Image getImage() {
        return SwtSvgImageUtil.getImage(this.shell.getDisplay(), ((Object)((Object)this)).getClass().getClassLoader(), "TRN.svg", 48, 48);
    }

    @Override
    protected boolean getArgFromPrev() {
        return this.jobEntry.argFromPrevious;
    }

    @Override
    protected String[] getArguments() {
        return this.jobEntry.arguments;
    }

    @Override
    protected String[] getParamters() {
        return this.jobEntry.parameters;
    }

    private void getParameters(TransMeta inputTransMeta) {
        try {
            if (inputTransMeta == null) {
                JobEntryTrans jet = new JobEntryTrans();
                this.getInfo(jet);
                inputTransMeta = jet.getTransMeta(this.rep, this.metaStore, (VariableSpace)this.jobMeta);
            }
            String[] parameters = inputTransMeta.listParameters();
            String[] existing = this.wParameters.getItems(1);
            for (int i = 0; i < parameters.length; ++i) {
                if (Const.indexOfString((String)parameters[i], (String[])existing) >= 0) continue;
                TableItem item = new TableItem(this.wParameters.table, 0);
                item.setText(1, parameters[i]);
            }
            this.wParameters.removeEmptyRows();
            this.wParameters.setRowNums();
            this.wParameters.optWidth(true);
        }
        catch (Exception e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"JobEntryTransDialog.Exception.UnableToLoadTransformation.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobEntryTransDialog.Exception.UnableToLoadTransformation.Message", (String[])new String[0]), e);
        }
    }

    String getEntryName(String name) {
        return "${Internal.Entry.Current.Directory}/" + name;
    }

    public void dispose() {
        WindowProperty winprop = new WindowProperty(this.shell);
        this.props.setScreen(winprop);
        this.shell.dispose();
    }

    public void getData() {
        TableItem ti;
        this.wName.setText(Const.NVL((String)this.jobEntry.getName(), (String)""));
        this.specificationMethod = this.jobEntry.getSpecificationMethod();
        switch (this.specificationMethod) {
            case FILENAME: {
                this.wPath.setText(Const.NVL((String)this.jobEntry.getFilename(), (String)""));
                break;
            }
            case REPOSITORY_BY_NAME: {
                String dirPath = Const.NVL((String)this.jobEntry.getDirectory(), (String)"");
                String transPath = Const.NVL((String)this.jobEntry.getTransname(), (String)"");
                String fullPath = (StringUtils.isBlank((String)dirPath) ? "" : dirPath + "/") + transPath;
                this.wPath.setText(fullPath);
                break;
            }
            case REPOSITORY_BY_REFERENCE: {
                this.referenceObjectId = this.jobEntry.getTransObjectId();
                if (this.rep == null || this.jobEntry.getTransObjectId() == null) break;
                this.getByReferenceData(this.jobEntry.getTransObjectId());
                break;
            }
        }
        if (this.jobEntry.arguments != null) {
            for (int i = 0; i < this.jobEntry.arguments.length; ++i) {
                ti = this.wFields.table.getItem(i);
                if (this.jobEntry.arguments[i] == null) continue;
                ti.setText(1, this.jobEntry.arguments[i]);
            }
            this.wFields.setRowNums();
            this.wFields.optWidth(true);
        }
        if (this.jobEntry.parameters != null) {
            for (int i = 0; i < this.jobEntry.parameters.length; ++i) {
                ti = this.wParameters.table.getItem(i);
                if (Utils.isEmpty((CharSequence)this.jobEntry.parameters[i])) continue;
                ti.setText(1, Const.NVL((String)this.jobEntry.parameters[i], (String)""));
                ti.setText(2, Const.NVL((String)this.jobEntry.parameterFieldNames[i], (String)""));
                ti.setText(3, Const.NVL((String)this.jobEntry.parameterValues[i], (String)""));
                this.parameterTableHelper.checkTableOnOpen(ti, i);
            }
            this.wParameters.setRowNums();
            this.wParameters.optWidth(true);
        }
        this.wPassParams.setSelection(this.jobEntry.isPassingAllParameters());
        if (this.jobEntry.logfile != null) {
            this.wLogfile.setText(this.jobEntry.logfile);
        }
        if (this.jobEntry.logext != null) {
            this.wLogext.setText(this.jobEntry.logext);
        }
        this.wPrevious.setSelection(this.jobEntry.argFromPrevious);
        this.wPrevToParams.setSelection(this.jobEntry.paramsFromPrevious);
        this.wEveryRow.setSelection(this.jobEntry.execPerRow);
        this.wSetLogfile.setSelection(this.jobEntry.setLogfile);
        this.wAddDate.setSelection(this.jobEntry.addDate);
        this.wAddTime.setSelection(this.jobEntry.addTime);
        this.wClearRows.setSelection(this.jobEntry.clearResultRows);
        this.wClearFiles.setSelection(this.jobEntry.clearResultFiles);
        this.wWaitingToFinish.setSelection(this.jobEntry.isWaitingToFinish());
        this.wFollowingAbortRemotely.setSelection(this.jobEntry.isFollowingAbortRemotely());
        this.wSuppressResultData.setSelection(this.jobEntry.isSuppressResultData());
        this.wAppendLogfile.setSelection(this.jobEntry.setAppendLogfile);
        this.wbLogFilename.setSelection(this.jobEntry.setAppendLogfile);
        this.wCreateParentFolder.setSelection(this.jobEntry.createParentFolder);
        if (this.jobEntry.logFileLevel != null) {
            this.wLoglevel.select(this.jobEntry.logFileLevel.getLevel());
        }
        ArrayList runConfigurations = new ArrayList();
        try {
            ExtensionPointHandler.callExtensionPoint((LogChannelInterface)Spoon.getInstance().getLog(), (String)KettleExtensionPoint.SpoonRunConfiguration.id, (Object)new Object[]{runConfigurations, "transformation"});
        }
        catch (KettleException kettleException) {
            // empty catch block
        }
        this.wRunConfiguration.setItems(runConfigurations.toArray(new String[0]));
        if (Utils.isEmpty((CharSequence)this.jobEntry.getRunConfiguration())) {
            this.wRunConfiguration.select(0);
        } else {
            this.wRunConfiguration.setText(this.jobEntry.getRunConfiguration());
        }
        this.wName.selectAll();
        this.wName.setFocus();
    }

    private void getByReferenceData(ObjectId transObjectId) {
        try {
            RepositoryObject transInf = this.rep.getObjectInformation(transObjectId, RepositoryObjectType.TRANSFORMATION);
            String path = DialogUtils.getPath(this.jobMeta.getRepositoryDirectory().getPath(), transInf.getRepositoryDirectory().getPath());
            String fullPath = Const.NVL((String)path, (String)"") + "/" + Const.NVL((String)transInf.getName(), (String)"");
            this.wPath.setText(fullPath);
        }
        catch (KettleException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"JobEntryTransDialog.Exception.UnableToReferenceObjectId.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobEntryTransDialog.Exception.UnableToReferenceObjectId.Message", (String[])new String[0]), (Exception)((Object)e));
        }
    }

    @Override
    protected void cancel() {
        this.jobEntry.setChanged(this.backupChanged);
        this.jobEntry = null;
        this.dispose();
    }

    private void getInfo(JobEntryTrans jet) throws KettleException {
        int i;
        jet.setName(this.wName.getText());
        this.specificationMethod = this.rep != null ? ObjectLocationSpecificationMethod.REPOSITORY_BY_NAME : ObjectLocationSpecificationMethod.FILENAME;
        jet.setSpecificationMethod(this.specificationMethod);
        switch (this.specificationMethod) {
            case FILENAME: {
                jet.setFileName(this.wPath.getText());
                if (jet.getFilename().isEmpty()) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"JobTrans.Dialog.Exception.NoValidMappingDetailsFound", (String[])new String[0]));
                }
                jet.setDirectory(null);
                jet.setTransname(null);
                jet.setTransObjectId(null);
                break;
            }
            case REPOSITORY_BY_NAME: {
                String transPath;
                String transName = transPath = this.wPath.getText();
                String directory = "";
                int index = transPath.lastIndexOf("/");
                if (index != -1) {
                    transName = transPath.substring(index + 1);
                    directory = index == 0 ? "/" : transPath.substring(0, index);
                }
                jet.setDirectory(directory);
                jet.setTransname(transName);
                jet.setFileName(null);
                jet.setTransObjectId(null);
                break;
            }
        }
        int nritems = this.wFields.nrNonEmpty();
        int nr = 0;
        for (i = 0; i < nritems; ++i) {
            String arg = this.wFields.getNonEmpty(i).getText(1);
            if (arg == null || arg.length() == 0) continue;
            ++nr;
        }
        jet.arguments = new String[nr];
        nr = 0;
        for (i = 0; i < nritems; ++i) {
            String arg = this.wFields.getNonEmpty(i).getText(1);
            if (arg == null || arg.length() == 0) continue;
            jet.arguments[nr] = arg;
            ++nr;
        }
        nritems = this.wParameters.nrNonEmpty();
        nr = 0;
        for (i = 0; i < nritems; ++i) {
            String param = this.wParameters.getNonEmpty(i).getText(1);
            if (param == null || param.length() == 0) continue;
            ++nr;
        }
        jet.parameters = new String[nr];
        jet.parameterFieldNames = new String[nr];
        jet.parameterValues = new String[nr];
        nr = 0;
        for (i = 0; i < nritems; ++i) {
            String param = this.wParameters.getNonEmpty(i).getText(1);
            String fieldName = this.wParameters.getNonEmpty(i).getText(2);
            String value = this.wParameters.getNonEmpty(i).getText(3);
            jet.parameters[nr] = param;
            jet.parameterFieldNames[nr] = !Utils.isEmpty((CharSequence)Const.trim((String)fieldName)) ? fieldName : "";
            jet.parameterValues[nr] = !Utils.isEmpty((CharSequence)Const.trim((String)value)) ? value : "";
            ++nr;
        }
        jet.setPassingAllParameters(this.wPassParams.getSelection());
        jet.logfile = this.wLogfile.getText();
        jet.logext = this.wLogext.getText();
        jet.logFileLevel = this.wLoglevel.getSelectionIndex() >= 0 ? LogLevel.values()[this.wLoglevel.getSelectionIndex()] : LogLevel.BASIC;
        jet.argFromPrevious = this.wPrevious.getSelection();
        jet.paramsFromPrevious = this.wPrevToParams.getSelection();
        jet.execPerRow = this.wEveryRow.getSelection();
        jet.setLogfile = this.wSetLogfile.getSelection();
        jet.addDate = this.wAddDate.getSelection();
        jet.addTime = this.wAddTime.getSelection();
        jet.clearResultRows = this.wClearRows.getSelection();
        jet.clearResultFiles = this.wClearFiles.getSelection();
        jet.createParentFolder = this.wCreateParentFolder.getSelection();
        jet.setRunConfiguration(this.wRunConfiguration.getText());
        jet.setAppendLogfile = this.wAppendLogfile.getSelection();
        jet.setWaitingToFinish(this.wWaitingToFinish.getSelection());
        jet.setFollowingAbortRemotely(this.wFollowingAbortRemotely.getSelection());
        jet.setSuppressResultData(this.wSuppressResultData.getSelection());
        TransExecutionConfiguration executionConfiguration = new TransExecutionConfiguration();
        executionConfiguration.setRunConfiguration(jet.getRunConfiguration());
        try {
            ExtensionPointHandler.callExtensionPoint((LogChannelInterface)this.jobEntry.getLogChannel(), (String)KettleExtensionPoint.SpoonTransBeforeStart.id, (Object)new Object[]{executionConfiguration, this.jobMeta, this.jobMeta, null});
        }
        catch (KettleException kettleException) {
            // empty catch block
        }
        try {
            ExtensionPointHandler.callExtensionPoint((LogChannelInterface)this.jobEntry.getLogChannel(), (String)KettleExtensionPoint.JobEntryTransSave.id, (Object)new Object[]{this.jobMeta, jet.getRunConfiguration()});
        }
        catch (KettleException kettleException) {
            // empty catch block
        }
        jet.setClustering(executionConfiguration.isExecutingClustered());
        if (executionConfiguration.getRemoteServer() != null) {
            jet.setRemoteSlaveServerName(executionConfiguration.getRemoteServer().getName());
        }
        jet.setLoggingRemoteWork(executionConfiguration.isLogRemoteExecutionLocally());
    }

    @Override
    protected void ok() {
        if (Utils.isEmpty((CharSequence)this.wName.getText())) {
            SimpleMessageDialog dialog = new SimpleMessageDialog(this.shell, BaseMessages.getString(PKG, (String)"System.StepJobEntryNameMissing.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.JobEntryNameMissing.Msg", (String[])new String[0]), 1);
            dialog.open();
            return;
        }
        if (this.parameterTableHelper.checkParams(this.shell)) {
            return;
        }
        this.jobEntry.setName(this.wName.getText());
        try {
            this.getInfo(this.jobEntry);
        }
        catch (KettleException kettleException) {
            // empty catch block
        }
        this.jobEntry.setChanged();
        this.dispose();
    }
}

