/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.job.entries.getpop;

import javax.mail.Folder;
import javax.mail.MessagingException;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.entries.getpop.JobEntryGetPOP;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.gui.WindowProperty;
import org.pentaho.di.ui.trans.step.BaseStepDialog;

public class SelectFolderDialog
extends Dialog {
    private static Class<?> PKG = JobEntryGetPOP.class;
    private PropsUI props;
    private Shell shell;
    private Tree wTree;
    private TreeItem tiTree;
    private Button wOK;
    private Button wRefresh;
    private Button wCancel;
    private String selection;
    private Folder folder;
    private GUIResource guiresource = GUIResource.getInstance();

    public SelectFolderDialog(Shell parent, int style, Folder folder) {
        super(parent, style);
        this.props = PropsUI.getInstance();
        this.folder = folder;
        this.selection = null;
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.shell.setText(BaseMessages.getString(PKG, (String)"SelectFolderDialog.Dialog.Main.Title", (String[])new String[0]));
        this.shell.setImage(this.guiresource.getImageSpoon());
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.wTree = new Tree((Composite)this.shell, 2052);
        this.props.setLook((Control)this.wTree);
        if (!this.getData()) {
            return null;
        }
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wRefresh = new Button((Composite)this.shell, 8);
        this.wRefresh.setText(BaseMessages.getString(PKG, (String)"System.Button.Refresh", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        FormData fdTree = new FormData();
        fdTree.left = new FormAttachment(0, 0);
        fdTree.top = new FormAttachment(0, 0);
        fdTree.right = new FormAttachment(100, 0);
        fdTree.bottom = new FormAttachment(100, -50);
        this.wTree.setLayoutData((Object)fdTree);
        BaseStepDialog.positionBottomButtons((Composite)this.shell, new Button[]{this.wOK, this.wRefresh, this.wCancel}, 4, null);
        this.wCancel.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                SelectFolderDialog.this.dispose();
            }
        });
        this.wOK.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                SelectFolderDialog.this.handleOK();
            }
        });
        this.wTree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent arg0) {
                SelectFolderDialog.this.handleOK();
            }
        });
        this.wRefresh.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                SelectFolderDialog.this.getData();
            }
        });
        BaseStepDialog.setSize(this.shell);
        this.shell.open();
        Display display = parent.getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.selection;
    }

    private boolean getData() {
        if (this.tiTree != null && !this.tiTree.isDisposed()) {
            this.tiTree.dispose();
        }
        this.wTree.removeAll();
        try {
            this.buildFoldersTree(this.folder, null, true);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private void buildFoldersTree(Folder folder, TreeItem parentTreeItem, boolean topfolder) throws MessagingException {
        if ((folder.getType() & 2) != 0) {
            Folder[] f = folder.list();
            for (int i = 0; i < f.length; ++i) {
                this.tiTree = topfolder ? new TreeItem(this.wTree, 0) : new TreeItem(parentTreeItem, 0);
                this.tiTree.setImage(this.guiresource.getImageBol());
                this.tiTree.setText(f[i].getName());
                if ((f[i].getType() & 2) == 0) continue;
                this.buildFoldersTree(f[i], this.tiTree, false);
            }
        }
    }

    public void dispose() {
        if (this.folder != null) {
            try {
                this.folder.close(false);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.props.setScreen(new WindowProperty(this.shell));
        this.shell.dispose();
    }

    public void handleOK() {
        TreeItem[] ti = this.wTree.getSelection();
        if (ti.length == 1) {
            String fullpath = ti[0].getText();
            for (TreeItem parent = ti[0].getParentItem(); parent != null; parent = parent.getParentItem()) {
                fullpath = parent.getText() + "/" + fullpath;
            }
            this.selection = fullpath;
            this.dispose();
        }
    }
}

