/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.i18n;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.ui.i18n.KeyOccurrence;
import org.pentaho.di.ui.i18n.LocaleStore;
import org.pentaho.di.ui.i18n.MessagesStore;
import org.pentaho.di.ui.i18n.SourceStore;

public class TranslationsStore {
    private List<String> localeList;
    private Map<String, LocaleStore> localeMap;
    private String mainLocale;
    private Map<String, Map<String, List<KeyOccurrence>>> sourcePackageOccurrences;
    private LogChannelInterface log;

    public TranslationsStore(LogChannelInterface log, List<String> localeList, String mainLocale, Map<String, Map<String, List<KeyOccurrence>>> sourcePackageOccurrences) {
        this.log = log;
        this.localeList = localeList;
        this.mainLocale = mainLocale;
        this.sourcePackageOccurrences = sourcePackageOccurrences;
        this.localeMap = new HashMap<String, LocaleStore>();
    }

    public void read(List<String> directories) throws KettleException {
        for (String locale : this.localeList) {
            LocaleStore localeStore = new LocaleStore(this.log, locale, this.mainLocale, this.sourcePackageOccurrences);
            try {
                localeStore.read(directories);
                this.localeMap.put(locale, localeStore);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public List<String> getLocaleList() {
        return this.localeList;
    }

    public void setLocaleList(List<String> localeList) {
        this.localeList = localeList;
    }

    public String getMainLocale() {
        return this.mainLocale;
    }

    public void setMainLocale(String mainLocale) {
        this.mainLocale = mainLocale;
    }

    public String lookupKeyValue(String locale, String messagesPackage, String key) {
        LocaleStore localeStore = this.localeMap.get(locale);
        if (localeStore == null) {
            return null;
        }
        for (String sourceFolder : localeStore.getSourceMap().keySet()) {
            String value;
            SourceStore sourceStore = localeStore.getSourceMap().get(sourceFolder);
            MessagesStore messagesStore = sourceStore.getMessagesMap().get(messagesPackage);
            if (messagesStore == null || (value = messagesStore.getMessagesMap().get(key)) == null) continue;
            return value;
        }
        return null;
    }

    public void removeValue(String locale, String sourceFolder, String messagesPackage, String key) {
        LocaleStore localeStore = this.localeMap.get(locale);
        if (localeStore == null) {
            return;
        }
        SourceStore sourceStore = localeStore.getSourceMap().get(sourceFolder);
        if (sourceStore == null) {
            return;
        }
        MessagesStore messagesStore = sourceStore.getMessagesMap().get(messagesPackage);
        if (messagesStore == null) {
            return;
        }
        messagesStore.getMessagesMap().remove(key);
        messagesStore.setChanged();
    }

    public void storeValue(String locale, String sourceFolder, String messagesPackage, String key, String value) {
        MessagesStore messagesStore;
        SourceStore sourceStore;
        LocaleStore localeStore = this.localeMap.get(locale);
        if (localeStore == null) {
            localeStore = new LocaleStore(this.log, locale, this.mainLocale, this.sourcePackageOccurrences);
            this.localeMap.put(locale, localeStore);
        }
        if ((sourceStore = localeStore.getSourceMap().get(sourceFolder)) == null) {
            sourceStore = new SourceStore(this.log, locale, sourceFolder, this.sourcePackageOccurrences);
            localeStore.getSourceMap().put(sourceFolder, sourceStore);
        }
        if ((messagesStore = sourceStore.getMessagesMap().get(messagesPackage)) == null) {
            messagesStore = new MessagesStore(locale, sourceFolder, messagesPackage, this.sourcePackageOccurrences);
            sourceStore.getMessagesMap().put(messagesPackage, messagesStore);
        }
        messagesStore.getMessagesMap().put(key, value);
        messagesStore.setChanged();
    }

    public List<MessagesStore> getChangedMessagesStores() {
        ArrayList<MessagesStore> list = new ArrayList<MessagesStore>();
        for (LocaleStore localeStore : this.localeMap.values()) {
            for (SourceStore sourceStore : localeStore.getSourceMap().values()) {
                for (MessagesStore messagesStore : sourceStore.getMessagesMap().values()) {
                    if (!messagesStore.hasChanged()) continue;
                    list.add(messagesStore);
                }
            }
        }
        return list;
    }

    public List<MessagesStore> getMessagesStores(String searchLocale, String messagesPackage) {
        ArrayList<MessagesStore> list = new ArrayList<MessagesStore>();
        LocaleStore localeStore = this.localeMap.get(searchLocale);
        for (SourceStore sourceStore : localeStore.getSourceMap().values()) {
            for (MessagesStore messagesStore : sourceStore.getMessagesMap().values()) {
                if (messagesPackage != null && !messagesStore.getMessagesPackage().equals(messagesPackage)) continue;
                list.add(messagesStore);
            }
        }
        return list;
    }

    public MessagesStore findMainLocaleMessagesStore(String sourceFolder, String messagesPackage) {
        return this.localeMap.get(this.mainLocale).getSourceMap().get(sourceFolder).getMessagesMap().get(messagesPackage);
    }

    public Map<String, Map<String, List<KeyOccurrence>>> getSourcePackageOccurrences() {
        return this.sourcePackageOccurrences;
    }

    public void setSourcePackageOccurrences(Map<String, Map<String, List<KeyOccurrence>>> sourcePackageOccurrences) {
        this.sourcePackageOccurrences = sourcePackageOccurrences;
    }
}

