/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.core.widget;

import java.util.Hashtable;
import java.util.Map;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.pentaho.di.ui.core.ConstUI;

public class TreeMemory {
    private static TreeMemory treeMemory;
    private Map<TreeMemoryEntry, Boolean> map = new Hashtable<TreeMemoryEntry, Boolean>(100);

    public static final TreeMemory getInstance() {
        if (treeMemory != null) {
            return treeMemory;
        }
        treeMemory = new TreeMemory();
        return treeMemory;
    }

    private TreeMemory() {
    }

    public void storeExpanded(String treeName, TreeItem treeItem, boolean expanded) {
        String[] path = ConstUI.getTreeStrings(treeItem);
        this.storeExpanded(treeName, path, expanded);
    }

    public void storeExpanded(String treeName, String[] path, boolean expanded) {
        TreeMemoryEntry key = new TreeMemoryEntry(treeName, path);
        if (expanded) {
            this.map.put(key, expanded);
        } else {
            this.map.remove(key);
        }
    }

    public boolean isExpanded(String treeName, String[] path) {
        TreeMemoryEntry key = new TreeMemoryEntry(treeName, path);
        Boolean expanded = this.map.get(key);
        if (expanded != null) {
            return expanded;
        }
        return false;
    }

    public void clear() {
        this.map.clear();
    }

    public static final TreeListener addTreeListener(Tree tree, final String treeName) {
        TreeListener treeListener = new TreeListener(){

            public void treeExpanded(TreeEvent e) {
                TreeItem treeItem = (TreeItem)e.item;
                String[] path = ConstUI.getTreeStrings(treeItem);
                TreeMemory treeMemory = TreeMemory.getInstance();
                treeMemory.storeExpanded(treeName, path, true);
            }

            public void treeCollapsed(TreeEvent e) {
                TreeItem treeItem = (TreeItem)e.item;
                String[] path = ConstUI.getTreeStrings(treeItem);
                TreeMemory treeMemory = TreeMemory.getInstance();
                treeMemory.storeExpanded(treeName, path, false);
            }
        };
        tree.addTreeListener(treeListener);
        return treeListener;
    }

    public static void setExpandedFromMemory(Tree tree, String treeName) {
        TreeItem[] items = tree.getItems();
        for (int i = 0; i < items.length; ++i) {
            TreeMemory.setExpandedFromMemory(tree, treeName, items[i]);
        }
    }

    private static void setExpandedFromMemory(Tree tree, String treeName, TreeItem treeItem) {
        TreeMemory treeMemory = TreeMemory.getInstance();
        String[] path = ConstUI.getTreeStrings(treeItem);
        boolean expanded = treeMemory.isExpanded(treeName, path);
        treeItem.setExpanded(expanded);
        TreeItem[] items = treeItem.getItems();
        for (int i = 0; i < items.length; ++i) {
            TreeMemory.setExpandedFromMemory(tree, treeName, items[i]);
        }
    }

    private class TreeMemoryEntry {
        private String treeName;
        private String[] path;

        TreeMemoryEntry(String treeName, String[] path) {
            this.path = path;
            this.treeName = treeName;
        }

        public int hashCode() {
            int code = this.treeName.hashCode();
            for (String p : this.path) {
                code ^= p.hashCode();
            }
            return code;
        }

        public boolean equals(Object obj) {
            TreeMemoryEntry entry = (TreeMemoryEntry)obj;
            if (!entry.treeName.equals(this.treeName)) {
                return false;
            }
            if (entry.path.length != this.path.length) {
                return false;
            }
            for (int i = 0; i < this.path.length; ++i) {
                if (this.path[i].equals(entry.path[i])) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            StringBuilder string = new StringBuilder(50);
            string.append("{");
            for (int i = 0; i < this.path.length; ++i) {
                if (i > 0) {
                    string.append("|");
                }
                string.append(this.path[i]);
            }
            string.append(":").append(this.treeName).append("}");
            return string.toString();
        }
    }
}

