/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.core.widget;

import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.pentaho.di.base.AbstractMeta;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.ObjectLocationSpecificationMethod;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.events.dialog.FilterType;
import org.pentaho.di.ui.core.events.dialog.SelectionAdapterFileDialogTextVar;
import org.pentaho.di.ui.core.events.dialog.SelectionAdapterOptions;
import org.pentaho.di.ui.core.events.dialog.SelectionOperation;
import org.pentaho.di.ui.core.widget.GetCaretPositionInterface;
import org.pentaho.di.ui.core.widget.InsertTextInterface;
import org.pentaho.di.ui.core.widget.TextVar;

public class FileChooserVar
extends Composite {
    private TextVar wPath;
    private Button wBrowseButton;
    VariableSpace space;
    protected ObjectLocationSpecificationMethod specificationMethod;
    PropsUI props = PropsUI.getInstance();

    public FileChooserVar(VariableSpace space, Composite composite, int flags, String buttonLabel) {
        this(space, composite, flags, buttonLabel, null, null, null);
    }

    public FileChooserVar(VariableSpace space, Composite composite, int flags, String buttonLabel, String toolTipText) {
        this(space, composite, flags, buttonLabel, toolTipText, null, null);
    }

    public FileChooserVar(VariableSpace space, Composite composite, int flags, String buttonLabel, GetCaretPositionInterface getCaretPositionInterface, InsertTextInterface insertTextInterface) {
        this(space, composite, flags, buttonLabel, null, getCaretPositionInterface, insertTextInterface);
    }

    public FileChooserVar(VariableSpace space, Composite composite, int flags, String buttonLabel, String toolTipText, GetCaretPositionInterface getCaretPositionInterface, InsertTextInterface insertTextInterface) {
        super(composite, 0);
        this.space = space;
        this.initialize(flags, buttonLabel, toolTipText, getCaretPositionInterface, insertTextInterface);
    }

    protected void initialize(int flags, String buttonLabel, String toolTipText, GetCaretPositionInterface getCaretPositionInterface, InsertTextInterface insertTextInterface) {
        this.props.setLook((Control)this);
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 0;
        formLayout.marginHeight = 0;
        formLayout.marginTop = 0;
        formLayout.marginBottom = 0;
        this.setLayout((Layout)formLayout);
        this.wBrowseButton = new Button((Composite)this, 8);
        this.props.setLook((Control)this.wBrowseButton);
        this.wBrowseButton.setText(buttonLabel);
        FormData fdButton = new FormData();
        fdButton.top = new FormAttachment(0, 0);
        fdButton.right = new FormAttachment(100, 0);
        this.wBrowseButton.setLayoutData((Object)fdButton);
        this.wPath = new TextVar(this.space, this, flags, toolTipText, getCaretPositionInterface, insertTextInterface);
        this.props.setLook((Control)this.wPath);
        FormData fdTextVar = new FormData();
        fdTextVar.top = new FormAttachment(0, 0);
        fdTextVar.left = new FormAttachment(0, 0);
        fdTextVar.right = new FormAttachment((Control)this.wBrowseButton, -8);
        this.wPath.setLayoutData(fdTextVar);
        this.wBrowseButton.addListener(13, event -> this.openFileBrowser());
    }

    public TextVar getTextVarWidget() {
        return this.wPath;
    }

    public String getText() {
        return this.wPath.getText();
    }

    public Button getButton() {
        return this.wBrowseButton;
    }

    private void openFileBrowser() {
        LogChannel log = new LogChannel();
        TransMeta meta = new TransMeta(this.space);
        SelectionAdapterFileDialogTextVar selectionAdapterFileDialogTextVar = new SelectionAdapterFileDialogTextVar((LogChannelInterface)log, this.wPath, (AbstractMeta)meta, new SelectionAdapterOptions(SelectionOperation.FILE, new FilterType[]{FilterType.ALL}, FilterType.ALL));
        selectionAdapterFileDialogTextVar.widgetSelected(null);
        if (this.wPath.getText() != null && Const.isWindows()) {
            this.wPath.setText(this.wPath.getText().replace('\\', '/'));
        }
    }

    public void addModifyListener(ModifyListener modifyListener) {
        this.wPath.addModifyListener(modifyListener);
    }

    public void setText(String text) {
        this.wPath.setText(text);
    }
}

