/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.core.widget;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.window.ToolTip;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.widget.CheckBoxToolTipListener;

public class CheckBoxToolTip
extends ToolTip {
    private String message = "";
    private String title;
    private Image image;
    private String checkBoxMessage;
    private boolean visible;
    private List<CheckBoxToolTipListener> listeners;
    private Display display;
    protected Rectangle checkBoxBounds;
    private boolean showingScrollBars;

    public CheckBoxToolTip(Control control) {
        super(control, 1, true);
        this.image = control.getDisplay().getSystemImage(2);
        this.listeners = new ArrayList<CheckBoxToolTipListener>();
        this.visible = false;
        this.display = control.getDisplay();
        super.setRespectMonitorBounds(true);
        super.setRespectDisplayBounds(true);
        super.setHideDelay(50000);
        super.setPopupDelay(0);
        super.setHideOnMouseDown(false);
    }

    protected Composite createToolTipContentArea(Event event, Composite parent) {
        Composite composite = new Composite(parent, 0);
        FormLayout compLayout = new FormLayout();
        compLayout.marginHeight = 5;
        compLayout.marginWidth = 5;
        composite.setLayout((Layout)compLayout);
        composite.setBackground(this.display.getSystemColor(29));
        Label imageLabel = new Label(composite, 0);
        imageLabel.setImage(this.image);
        imageLabel.setBackground(this.display.getSystemColor(29));
        FormData fdImageLabel = new FormData();
        fdImageLabel.left = new FormAttachment(0, 0);
        fdImageLabel.top = new FormAttachment(0, 0);
        imageLabel.setLayoutData((Object)fdImageLabel);
        Label titleLabel = new Label(composite, 16384);
        titleLabel.setText(this.title);
        titleLabel.setBackground(this.display.getSystemColor(29));
        titleLabel.setFont(GUIResource.getInstance().getFontBold());
        FormData fdTitleLabel = new FormData();
        fdTitleLabel.left = new FormAttachment((Control)imageLabel, 20);
        fdTitleLabel.top = new FormAttachment(0, 0);
        titleLabel.setLayoutData((Object)fdTitleLabel);
        Label line = new Label(composite, 258);
        line.setBackground(this.display.getSystemColor(29));
        FormData fdLine = new FormData();
        fdLine.left = new FormAttachment((Control)imageLabel, 5);
        fdLine.right = new FormAttachment(100, -5);
        fdLine.top = new FormAttachment((Control)titleLabel, 5);
        line.setLayoutData((Object)fdLine);
        Label messageLabel = new Label(composite, 16384);
        messageLabel.setText(this.message);
        messageLabel.setBackground(this.display.getSystemColor(29));
        FormData fdMessageLabel = new FormData();
        fdMessageLabel.left = new FormAttachment((Control)imageLabel, 20);
        fdMessageLabel.top = new FormAttachment((Control)line, 5);
        messageLabel.setLayoutData((Object)fdMessageLabel);
        final Button disable = new Button(composite, 32);
        disable.setText(this.checkBoxMessage);
        disable.setBackground(this.display.getSystemColor(29));
        disable.setSelection(false);
        FormData fdDisable = new FormData();
        fdDisable.left = new FormAttachment(0, 0);
        fdDisable.top = new FormAttachment((Control)messageLabel, 20);
        fdDisable.bottom = new FormAttachment(100, 0);
        disable.setLayoutData((Object)fdDisable);
        disable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                for (CheckBoxToolTipListener listener : CheckBoxToolTip.this.listeners) {
                    listener.checkBoxSelected(false);
                }
                CheckBoxToolTip.this.hide();
            }
        });
        disable.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent arg0) {
                CheckBoxToolTip.this.checkBoxBounds = disable.getBounds();
            }
        });
        composite.layout();
        this.checkBoxBounds = disable.getBounds();
        return composite;
    }

    public void show(Point location) {
        super.show(location);
        this.visible = true;
    }

    public void hide() {
        this.visible = false;
        super.hide();
    }

    public void addCheckBoxToolTipListener(CheckBoxToolTipListener listener) {
        this.listeners.add(listener);
    }

    protected void afterHideToolTip(Event event) {
        super.afterHideToolTip(event);
        this.visible = false;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
        try {
            Method setText = super.getClass().getMethod("setText", String.class);
            setText.invoke((Object)this, title);
        }
        catch (NoSuchMethodException setText) {
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        this.image = image;
    }

    public String getCheckBoxMessage() {
        return this.checkBoxMessage;
    }

    public void setCheckBoxMessage(String checkBoxMessage) {
        this.checkBoxMessage = checkBoxMessage;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public Rectangle getCheckBoxBounds() {
        return this.checkBoxBounds;
    }

    public void setCheckBoxBounds(Rectangle checkBoxBounds) {
        this.checkBoxBounds = checkBoxBounds;
    }

    public boolean isShowingScrollBars() {
        return this.showingScrollBars;
    }

    public void setShowingScrollBars(boolean showingScrollBars) {
        this.showingScrollBars = showingScrollBars;
    }
}

