/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.core.widget;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.TableView;

public class CheckBoxTableCombo {
    private final PropsUI props;
    private final ModifyListener lsMod;
    private final TransMeta transMeta;
    private final Composite parentComposite;
    private Map<String, String> dataMap;
    private final String columnOneName;
    private final String columnTwoName;
    private final String buttonName;
    private final String tableName;
    protected TableView propertiesTable;
    protected Button wCheckBox;
    private boolean isEnabled;

    CheckBoxTableCombo() {
        this.parentComposite = null;
        this.props = null;
        this.lsMod = null;
        this.transMeta = null;
        this.dataMap = null;
        this.buttonName = null;
        this.tableName = null;
        this.columnOneName = null;
        this.columnTwoName = null;
        this.isEnabled = false;
    }

    public CheckBoxTableCombo(Composite parentComposite, PropsUI props, ModifyListener lsMod, TransMeta transMeta, Map<String, String> dataMap, String buttonName, String tableName, String columnOneName, String columnTwoName, boolean isEnabled) {
        Preconditions.checkNotNull((Object)((Object)props));
        Preconditions.checkNotNull((Object)parentComposite);
        Preconditions.checkNotNull((Object)lsMod);
        Preconditions.checkNotNull((Object)transMeta);
        this.parentComposite = parentComposite;
        this.props = props;
        this.lsMod = lsMod;
        this.transMeta = transMeta;
        this.dataMap = dataMap;
        this.buttonName = buttonName;
        this.tableName = tableName;
        this.columnOneName = columnOneName;
        this.columnTwoName = columnTwoName;
        this.isEnabled = isEnabled;
        this.buildWidget();
    }

    public Map<String, String> getPropertiesData() {
        return this.tableToMap(this.propertiesTable);
    }

    public boolean getIsEnabled() {
        return this.wCheckBox.getSelection();
    }

    public void updateDataMap(Map<String, String> newDataMap) {
        this.dataMap = newDataMap;
        this.populateSSLData();
    }

    private void buildWidget() {
        this.wCheckBox = new Button(this.parentComposite, 32);
        this.wCheckBox.setText(this.buttonName);
        this.props.setLook((Control)this.wCheckBox);
        FormData fdUseSSL = new FormData();
        fdUseSSL.top = new FormAttachment((Control)this.parentComposite, 0);
        fdUseSSL.left = new FormAttachment(0, 0);
        this.wCheckBox.setLayoutData((Object)fdUseSSL);
        this.wCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                boolean selection = ((Button)selectionEvent.getSource()).getSelection();
                CheckBoxTableCombo.this.propertiesTable.setEnabled(selection);
                CheckBoxTableCombo.this.propertiesTable.table.setEnabled(selection);
                CheckBoxTableCombo.this.lsMod.modifyText(null);
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                boolean selection = ((Button)selectionEvent.getSource()).getSelection();
                CheckBoxTableCombo.this.propertiesTable.setEnabled(selection);
                CheckBoxTableCombo.this.propertiesTable.table.setEnabled(selection);
                CheckBoxTableCombo.this.lsMod.modifyText(null);
            }
        });
        Label wlSSLProperties = new Label(this.parentComposite, 16384);
        wlSSLProperties.setText(this.tableName);
        this.props.setLook((Control)wlSSLProperties);
        FormData fdlSSLProperties = new FormData();
        fdlSSLProperties.top = new FormAttachment((Control)this.wCheckBox, 10);
        fdlSSLProperties.left = new FormAttachment(0, 0);
        wlSSLProperties.setLayoutData((Object)fdlSSLProperties);
        this.buildSSLTable(this.parentComposite, (Control)wlSSLProperties);
        this.setUIText();
    }

    private void setUIText() {
        this.wCheckBox.setSelection(this.isEnabled);
        this.propertiesTable.setEnabled(this.isEnabled);
        this.propertiesTable.table.setEnabled(this.isEnabled);
        this.propertiesTable.table.select(0);
        this.propertiesTable.table.showSelection();
    }

    private void buildSSLTable(Composite parentWidget, Control relativePosition) {
        ColumnInfo[] columns = this.getSSLColumns();
        this.propertiesTable = new TableView((VariableSpace)this.transMeta, parentWidget, 67586, columns, 0, true, this.lsMod, this.props, false);
        this.propertiesTable.setSortable(false);
        this.propertiesTable.getTable().addListener(11, event -> {
            Table table = (Table)event.widget;
            table.getColumn(1).setWidth(200);
            table.getColumn(2).setWidth(200);
        });
        this.populateSSLData();
        FormData fdData = new FormData();
        fdData.left = new FormAttachment(0, 0);
        fdData.top = new FormAttachment(relativePosition, 5);
        fdData.bottom = new FormAttachment(100, 0);
        fdData.width = 430;
        Arrays.stream(this.propertiesTable.getTable().getColumns()).forEach(column -> {
            if (column.getWidth() > 0) {
                column.setWidth(200);
            }
        });
        this.propertiesTable.setLayoutData(fdData);
    }

    private ColumnInfo[] getSSLColumns() {
        ColumnInfo optionName = new ColumnInfo(this.columnOneName, 1, false, true);
        ColumnInfo value = new ColumnInfo(this.columnTwoName, 1, false, false, 200);
        value.setUsingVariables(true);
        return new ColumnInfo[]{optionName, value};
    }

    private void populateSSLData() {
        this.propertiesTable.getTable().removeAll();
        new TableItem(this.propertiesTable.getTable(), 0);
        Preconditions.checkNotNull((Object)this.propertiesTable.getItem(0));
        Preconditions.checkState((this.propertiesTable.getItem(0).length == 2 ? 1 : 0) != 0);
        if (this.dataMap.size() == 0) {
            return;
        }
        ArrayList keys = Lists.newArrayList(this.dataMap.keySet());
        Collections.sort(keys);
        String firstKey = (String)keys.remove(0);
        this.propertiesTable.getTable().getItem(0).setText(1, firstKey);
        this.propertiesTable.getTable().getItem(0).setText(2, this.dataMap.get(firstKey));
        keys.stream().forEach(key -> this.propertiesTable.add((String)key, this.dataMap.get(key)));
    }

    private Map<String, String> tableToMap(TableView table) {
        return IntStream.range(0, table.getItemCount()).mapToObj(table::getItem).collect(Collectors.toMap(strArray -> strArray[0], strArray -> strArray[1]));
    }
}

