/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.core.widget;

import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.di.core.util.DateDetector;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.ui.core.FormDataBuilder;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.widget.ComboVar;
import org.pentaho.di.ui.core.widget.TextVar;

public class CalendarDateAndTime
extends Composite {
    private Label wlDateLabel;
    private TextVar wDateString;
    private Label calendarImage;
    private Label wlTimeLabel;
    private ComboVar wHour;
    private ComboVar wMinute;
    private ComboVar wSecond;
    private Shell calendarShell;

    public CalendarDateAndTime(Composite composite, int i, VariableSpace variableSpace) {
        super(composite, i);
        FormLayout formLayout = new FormLayout();
        formLayout.marginBottom = 0;
        formLayout.marginHeight = 0;
        formLayout.marginWidth = 0;
        formLayout.marginTop = 0;
        this.setLayout((Layout)formLayout);
        this.wlDateLabel = new Label((Composite)this, 16384);
        this.wlDateLabel.setText("Date:");
        this.wlDateLabel.setLayoutData((Object)new FormDataBuilder().top().left().result());
        this.wlTimeLabel = new Label((Composite)this, 16384);
        this.wlTimeLabel.setText("Time:");
        this.wlTimeLabel.setLayoutData((Object)new FormDataBuilder().top().left((Control)this.wlDateLabel, 135).result());
        this.wDateString = new TextVar(variableSpace, this, 18436);
        this.wDateString.setLayoutData(new FormDataBuilder().top((Control)this.wlDateLabel, 5).left().width(100).result());
        this.calendarImage = new Label((Composite)this, 17408);
        this.calendarImage.setImage(GUIResource.getInstance().getImageCalendar());
        this.calendarImage.setLayoutData((Object)new FormDataBuilder().left((Control)this.wDateString, 5).top(50, 0).result());
        this.calendarImage.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent mouseEvent) {
                this.mouseDown(mouseEvent);
            }

            public void mouseDown(MouseEvent mouseEvent) {
                if (CalendarDateAndTime.this.calendarShell == null || CalendarDateAndTime.this.calendarShell.isDisposed()) {
                    CalendarDateAndTime.this.showCalendarWidget();
                }
            }

            public void mouseUp(MouseEvent mouseEvent) {
            }
        });
        this.wHour = new ComboVar(variableSpace, this, 18436);
        this.setDropDownValues(this.wHour, 0, 23);
        this.wHour.setLayoutData(new FormDataBuilder().top((Control)this.wlTimeLabel).left((Control)this.calendarImage, 50).result());
        this.wHour.setText("00");
        this.wMinute = new ComboVar(variableSpace, this, 18436);
        this.setDropDownValues(this.wMinute, 0, 59);
        this.wMinute.setLayoutData(new FormDataBuilder().top((Control)this.wlTimeLabel).left((Control)this.wHour, 5).result());
        this.wMinute.setText("00");
        this.wSecond = new ComboVar(variableSpace, this, 18436);
        this.setDropDownValues(this.wSecond, 0, 59);
        this.wSecond.setLayoutData(new FormDataBuilder().top((Control)this.wlTimeLabel).left((Control)this.wMinute, 5).result());
        this.wSecond.setText("00");
    }

    private void setDropDownValues(ComboVar c, int start, int end) {
        for (int i = start; i <= end; ++i) {
            String value = String.valueOf(i);
            value = value.length() == 1 ? 0 + value : value;
            c.add(value);
        }
    }

    public void setDateAndTime(Date d) {
        if (d == null) {
            d = Calendar.getInstance().getTime();
        }
        this.setDateString(String.format("%1$tY/%1$tm/%1$td", d));
        this.setTime(d);
    }

    public Date getDate() throws ParseException {
        return DateDetector.getDateFromString((String)(this.getDateString() + " " + this.getTimeString()));
    }

    public String getTimeString() {
        return this.wHour.getText() + ":" + this.wMinute.getText() + ":" + this.wSecond.getText();
    }

    public void setDateString(String dateString) {
        this.wDateString.setText(dateString);
    }

    public String getDateString() {
        return this.wDateString.getText();
    }

    public void setTime(Date widgetDate) {
        this.wHour.setText(String.format("%TH", widgetDate));
        this.wMinute.setText(String.format("%TM", widgetDate));
        this.wSecond.setText(String.format("%TS", widgetDate));
    }

    private void showCalendarWidget() {
        this.calendarShell = new Shell(this.getShell(), 2144);
        FormLayout formLayout = new FormLayout();
        formLayout.marginBottom = 0;
        formLayout.marginHeight = 0;
        formLayout.marginWidth = 0;
        formLayout.marginTop = 0;
        this.calendarShell.setLayout((Layout)formLayout);
        final DateTime calendarWidget = new DateTime((Composite)this.calendarShell, 3072);
        calendarWidget.setLayoutData((Object)new FormDataBuilder().top().left().result());
        try {
            Date dateFromField = DateDetector.getDateFromString((String)this.wDateString.getText());
            Calendar c = Calendar.getInstance();
            c.setTime(dateFromField);
            calendarWidget.setDate(c.get(1), c.get(2), c.get(5));
        }
        catch (ParseException dateFromField) {
            // empty catch block
        }
        Button okButton = new Button((Composite)this.calendarShell, 8);
        Button cancelButton = new Button((Composite)this.calendarShell, 8);
        cancelButton.setText("CANCEL");
        cancelButton.setLayoutData((Object)new FormDataBuilder().top((Control)calendarWidget).right().result());
        okButton.setText("OK");
        okButton.setLayoutData((Object)new FormDataBuilder().top((Control)calendarWidget).right((Control)cancelButton, -5).result());
        okButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                this.widgetDefaultSelected(selectionEvent);
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                CalendarDateAndTime.this.setDateString(calendarWidget.getYear() + "/" + (calendarWidget.getMonth() + 1) + "/" + calendarWidget.getDay());
                CalendarDateAndTime.this.calendarShell.dispose();
            }
        });
        cancelButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                this.widgetDefaultSelected(selectionEvent);
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                CalendarDateAndTime.this.calendarShell.dispose();
            }
        });
        this.calendarShell.pack();
        this.calendarShell.open();
    }
}

