/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.core.dialog;

import java.util.Map;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.gui.GUIResource;

public class WarningDialog
extends Dialog {
    private final PropsUI props;
    private final String title;
    private final String message;
    private final Map<String, Listener> listenerMap;
    private Shell shell;

    public WarningDialog(Shell parent, String title, String message, Map<String, Listener> listenerMap) {
        super(parent);
        this.title = title;
        this.message = message.trim();
        this.listenerMap = listenerMap;
        this.props = PropsUI.getInstance();
    }

    public void open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 268503152);
        this.shell.setImage(GUIResource.getInstance().getImageSpoon());
        this.shell.setLayout((Layout)new FormLayout());
        this.shell.setText(this.title);
        this.props.setLook((Control)this.shell);
        Label wlImage = new Label((Composite)this.shell, 0);
        wlImage.setImage(GUIResource.getInstance().getImageWarning32());
        FormData fdWarnImage = new FormData();
        fdWarnImage.left = new FormAttachment(0, 15);
        fdWarnImage.top = new FormAttachment(0, 15);
        fdWarnImage.height = 32;
        fdWarnImage.width = 32;
        wlImage.setLayoutData((Object)fdWarnImage);
        this.props.setLook((Control)wlImage);
        Label wlMessage = new Label((Composite)this.shell, 0x800040);
        wlMessage.setText(this.message);
        FormData fdMessage = new FormData();
        fdMessage.left = new FormAttachment((Control)wlImage, 15, 131072);
        fdMessage.right = new FormAttachment(100, -15);
        fdMessage.top = new FormAttachment((Control)wlImage, 0, 128);
        wlMessage.setLayoutData((Object)fdMessage);
        this.props.setLook((Control)wlMessage);
        Button spacer = new Button((Composite)this.shell, 0);
        FormData fdSpacer = new FormData();
        fdSpacer.right = new FormAttachment(100, 0);
        fdSpacer.bottom = new FormAttachment(100, -15);
        fdSpacer.left = new FormAttachment(100, -11);
        fdSpacer.top = new FormAttachment((Control)wlMessage, 15, 1024);
        spacer.setLayoutData((Object)fdSpacer);
        spacer.setVisible(false);
        this.props.setLook((Control)spacer);
        Button attachTo = spacer;
        for (String label : this.listenerMap.keySet()) {
            Button wButton = new Button((Composite)this.shell, 8);
            wButton.setText(label);
            FormData fdButton = new FormData();
            fdButton.right = new FormAttachment((Control)attachTo, -4, 16384);
            fdButton.bottom = new FormAttachment((Control)attachTo, 0, 1024);
            wButton.setLayoutData((Object)fdButton);
            wButton.addListener(13, this.listenAndDispose(this.listenerMap.get(label)));
            this.props.setLook((Control)wButton);
            attachTo = wButton;
        }
        Point point = this.shell.computeSize(436, -1);
        this.shell.setSize(point);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    private Listener listenAndDispose(final Listener lsCancel) {
        return new Listener(){

            public void handleEvent(Event event) {
                lsCancel.handleEvent(event);
                WarningDialog.this.shell.dispose();
            }
        };
    }
}

