/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.core.dialog;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.spoon.Spoon;

public class ShowHelpDialog
extends Dialog {
    private static Class<?> PKG = Spoon.class;
    private static final String DOC_URL = Spoon.DOCUMENTATION_URL;
    private static final String PREFIX = "https://help";
    private static final String PRINT_PREFIX = "https://f1.help";
    private static final String PRINT_SCRIPT = "javascript:window.print();";
    private static final int TOOLBAR_HEIGHT = 34;
    private static final int TOOL_ITEM_SPACING = 4;
    private static final int MARGIN = 5;
    private boolean fromPrint;
    private String dialogTitle;
    private String url;
    private String homeURL;
    private Browser wBrowser;
    private ToolBar toolbarLeft;
    private ToolBar toolbarRight;
    private ToolItem tltmBack;
    private ToolItem tltmForward;
    private ToolItem tltmRefresh;
    private ToolItem tltmHome;
    private ToolItem tltmPrint;
    private Image imageBackEnabled;
    private Image imageBackDisabled;
    private Image imageForwardEnabled;
    private Image imageForwardDisabled;
    private Image imageRefreshEnabled;
    private Image imageRefreshDisabled;
    private Image imageHomeEnabled;
    private Image imageHomeDisabled;
    private Image imagePrintEnabled;
    private Image imagePrintDisabled;
    private Text textURL;
    private Cursor cursorEnabled;
    private Shell shell;
    private Display display;
    private PropsUI props = PropsUI.getInstance();

    public ShowHelpDialog(Shell parent, String dialogTitle, String url, String header) {
        super(parent, 0);
        this.dialogTitle = BaseMessages.getString(PKG, (String)"Spoon.Documentation.Pentaho.Title", (String[])new String[0]);
        this.url = url;
        try {
            this.homeURL = new URL(DOC_URL).toString();
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    public ShowHelpDialog(Shell parent, String dialogTitle, String url) {
        this(parent, dialogTitle, url, "");
    }

    protected Shell createShell(Shell parent) {
        return new Shell(parent, 3312);
    }

    public void open() {
        Program.launch((String)this.url);
    }

    private void setImages() {
        this.imageBackEnabled = GUIResource.getInstance().getImageBackEnabled();
        this.imageBackDisabled = GUIResource.getInstance().getImageBackDisabled();
        this.imageForwardEnabled = GUIResource.getInstance().getImageForwardEnabled();
        this.imageForwardDisabled = GUIResource.getInstance().getImageForwardDisabled();
        this.imageRefreshEnabled = GUIResource.getInstance().getImageRefreshEnabled();
        this.imageRefreshDisabled = GUIResource.getInstance().getImageRefreshDisabled();
        this.imageHomeEnabled = GUIResource.getInstance().getImageHomeEnabled();
        this.imageHomeDisabled = GUIResource.getInstance().getImageHomeDisabled();
        this.imagePrintEnabled = GUIResource.getInstance().getImagePrintEnabled();
        this.imagePrintDisabled = GUIResource.getInstance().getImagePrintDisabled();
        this.cursorEnabled = new Cursor((Device)this.display, 21);
    }

    private void setUpListeners() {
        this.setUpSelectionListeners();
        this.addProgressAndLocationListener();
        this.addShellListener();
    }

    private void setUpSelectionListeners() {
        SelectionListener selectionListenerBack = new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                ShowHelpDialog.this.back();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        };
        SelectionListener selectionListenerForward = new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                ShowHelpDialog.this.forward();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        };
        SelectionListener selectionListenerRefresh = new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                ShowHelpDialog.this.refresh();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        };
        SelectionListener selectionListenerHome = new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                ShowHelpDialog.this.home();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        };
        SelectionListener selectionListenerPrint = new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                ShowHelpDialog.this.print();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        };
        this.tltmBack.addSelectionListener(selectionListenerBack);
        this.tltmForward.addSelectionListener(selectionListenerForward);
        this.tltmRefresh.addSelectionListener(selectionListenerRefresh);
        this.tltmHome.addSelectionListener(selectionListenerHome);
        this.tltmPrint.addSelectionListener(selectionListenerPrint);
    }

    private void addProgressAndLocationListener() {
        ProgressListener progressListener = new ProgressListener(){

            public void changed(ProgressEvent event) {
            }

            public void completed(ProgressEvent event) {
                if (ShowHelpDialog.this.fromPrint) {
                    ShowHelpDialog.this.wBrowser.execute(ShowHelpDialog.PRINT_SCRIPT);
                    ShowHelpDialog.this.fromPrint = false;
                }
                ShowHelpDialog.this.setForwardBackEnable();
            }
        };
        LocationListener listener = new LocationListener(){

            public void changing(LocationEvent event) {
                if (event.location.endsWith(".pdf")) {
                    Program.launch((String)event.location);
                    event.doit = false;
                }
            }

            public void changed(LocationEvent event) {
                ShowHelpDialog.this.textURL.setText(event.location);
            }
        };
        this.wBrowser.addProgressListener(progressListener);
        this.wBrowser.addLocationListener(listener);
    }

    private void addShellListener() {
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                ShowHelpDialog.this.ok();
            }
        });
    }

    private void back() {
        this.wBrowser.back();
    }

    private void forward() {
        this.wBrowser.forward();
    }

    private void refresh() {
        this.wBrowser.refresh();
    }

    private void home() {
        this.wBrowser.setUrl(this.homeURL != null ? this.homeURL : this.url);
    }

    private void print() {
        String printURL = this.wBrowser.getUrl();
        if (printURL.startsWith(PREFIX)) {
            printURL = printURL.replace(PREFIX, PRINT_PREFIX);
            this.fromPrint = true;
            this.wBrowser.setUrl(printURL);
        } else {
            this.wBrowser.execute(PRINT_SCRIPT);
        }
    }

    private void setForwardBackEnable() {
        this.setBackEnable(this.wBrowser.isBackEnabled());
        this.setForwardEnable(this.wBrowser.isForwardEnabled());
    }

    private void setBackEnable(boolean enable) {
        this.tltmBack.setEnabled(enable);
    }

    private void setForwardEnable(boolean enable) {
        this.tltmForward.setEnabled(enable);
    }

    public void dispose() {
        this.shell.dispose();
    }

    private void ok() {
        this.dispose();
    }
}

