/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.core.dialog;

import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.KettleVariablesList;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.util.EnvUtil;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.gui.WindowProperty;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.FieldDisabledListener;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.trans.step.BaseStepDialog;

public class KettlePropertiesFileDialog
extends Dialog {
    private static Class<?> PKG = KettlePropertiesFileDialog.class;
    private Label wlFields;
    private TableView wFields;
    private FormData fdlFields;
    private FormData fdFields;
    private Button wOK;
    private Button wCancel;
    private Listener lsOK;
    private Listener lsCancel;
    private Shell shell;
    private PropsUI props = PropsUI.getInstance();
    private Map<String, String> kettleProperties = null;
    private Set<String> previousKettlePropertiesKeys;

    public KettlePropertiesFileDialog(Shell parent, int style) {
        super(parent, style);
    }

    public Map<String, String> open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3184);
        this.shell.setImage(GUIResource.getInstance().getImageTransGraph());
        this.props.setLook((Control)this.shell);
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"KettlePropertiesFileDialog.Title", (String[])new String[0]));
        int margin = 4;
        this.wlFields = new Label((Composite)this.shell, 0);
        this.wlFields.setText(BaseMessages.getString(PKG, (String)"KettlePropertiesFileDialog.Message", (String[])new String[0]));
        this.props.setLook((Control)this.wlFields);
        this.fdlFields = new FormData();
        this.fdlFields.left = new FormAttachment(0, 0);
        this.fdlFields.top = new FormAttachment(0, margin);
        this.wlFields.setLayoutData((Object)this.fdlFields);
        int FieldsRows = 0;
        ColumnInfo[] colinf = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"KettlePropertiesFileDialog.Name.Label", (String[])new String[0]), 1, false, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"KettlePropertiesFileDialog.Value.Label", (String[])new String[0]), 1, false, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"KettlePropertiesFileDialog.Description.Label", (String[])new String[0]), 1, false, true)};
        colinf[2].setDisabledListener(new FieldDisabledListener(){

            @Override
            public boolean isFieldDisabled(int rowNr) {
                return false;
            }
        });
        this.wFields = new TableView(Variables.getADefaultVariableSpace(), (Composite)this.shell, 67586, colinf, FieldsRows, null, this.props);
        this.wFields.setReadonly(false);
        this.fdFields = new FormData();
        this.fdFields.left = new FormAttachment(0, 0);
        this.fdFields.top = new FormAttachment((Control)this.wlFields, 30);
        this.fdFields.right = new FormAttachment(100, 0);
        this.fdFields.bottom = new FormAttachment(100, -50);
        this.wFields.setLayoutData(this.fdFields);
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        BaseStepDialog.positionBottomButtons((Composite)this.shell, new Button[]{this.wOK, this.wCancel}, margin, (Control)this.wFields);
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                KettlePropertiesFileDialog.this.ok();
            }
        };
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                KettlePropertiesFileDialog.this.cancel();
            }
        };
        this.wOK.addListener(13, this.lsOK);
        this.wCancel.addListener(13, this.lsCancel);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                KettlePropertiesFileDialog.this.cancel();
            }
        });
        this.getData();
        BaseStepDialog.setSize(this.shell);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.kettleProperties;
    }

    public void dispose() {
        this.props.setScreen(new WindowProperty(this.shell));
        this.shell.dispose();
    }

    public void getData() {
        try {
            Properties properties = EnvUtil.readProperties((String)this.getKettlePropertiesFilename());
            KettleVariablesList variablesList = KettleVariablesList.getInstance();
            for (String key : variablesList.getDescriptionMap().keySet()) {
                if (!Utils.isEmpty((CharSequence)((String)properties.get(key)))) continue;
                String defaultValue = (String)variablesList.getDefaultValueMap().get(key);
                properties.put(key, Const.NVL((String)defaultValue, (String)""));
            }
            ArrayList<String> keys = new ArrayList<String>();
            Enumeration<Object> keysEnum = properties.keys();
            while (keysEnum.hasMoreElements()) {
                keys.add((String)keysEnum.nextElement());
            }
            Collections.sort(keys);
            for (int i = 0; i < keys.size(); ++i) {
                String key = (String)keys.get(i);
                String value = properties.getProperty(key, "");
                String description = Const.NVL((String)((String)variablesList.getDescriptionMap().get(key)), (String)"");
                TableItem item = new TableItem(this.wFields.table, 0);
                item.setBackground(3, GUIResource.getInstance().getColorLightGray());
                int pos = 1;
                item.setText(pos++, key);
                item.setText(pos++, value);
                item.setText(pos++, description);
            }
            this.wFields.removeEmptyRows();
            this.wFields.setRowNums();
            this.wFields.optWidth(true);
            this.previousKettlePropertiesKeys = new HashSet<String>();
            this.previousKettlePropertiesKeys.addAll(Arrays.asList(properties.keySet().toArray(new String[0])));
        }
        catch (Exception e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"KettlePropertiesFileDialog.Exception.ErrorLoadingData.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"KettlePropertiesFileDialog.Exception.ErrorLoadingData.Message", (String[])new String[0]), e);
        }
    }

    private String getKettlePropertiesFilename() {
        return Const.getKettlePropertiesFilename();
    }

    private void cancel() {
        this.kettleProperties = null;
        this.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void ok() {
        block13: {
            Properties properties = new Properties();
            this.kettleProperties = new HashMap<String, String>();
            int nr = this.wFields.nrNonEmpty();
            for (int i = 0; i < nr; ++i) {
                TableItem item = this.wFields.getNonEmpty(i);
                int pos = 1;
                String variable = item.getText(pos++);
                String value = item.getText(pos++);
                if (Utils.isEmpty((CharSequence)variable)) continue;
                properties.put(variable, value);
                this.kettleProperties.put(variable, value);
            }
            FileOutputStream out = null;
            out = new FileOutputStream(this.getKettlePropertiesFilename());
            properties.store(out, Const.getKettlePropertiesFileHeader());
            try {
                out.close();
            }
            catch (IOException e) {
                LogChannel.GENERAL.logError(BaseMessages.getString(PKG, (String)"KettlePropertiesFileDialog.Exception.ErrorSavingData.Message", (String[])new String[]{"kettle.properties", this.getKettlePropertiesFilename()}), (Throwable)e);
            }
            break block13;
            catch (Exception e) {
                try {
                    new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"KettlePropertiesFileDialog.Exception.ErrorSavingData.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"KettlePropertiesFileDialog.Exception.ErrorSavingData.Message", (String[])new String[0]), e);
                }
                catch (Throwable throwable) {
                    try {
                        out.close();
                    }
                    catch (IOException e2) {
                        LogChannel.GENERAL.logError(BaseMessages.getString(PKG, (String)"KettlePropertiesFileDialog.Exception.ErrorSavingData.Message", (String[])new String[]{"kettle.properties", this.getKettlePropertiesFilename()}), (Throwable)e2);
                    }
                    throw throwable;
                }
                try {
                    out.close();
                }
                catch (IOException e3) {
                    LogChannel.GENERAL.logError(BaseMessages.getString(PKG, (String)"KettlePropertiesFileDialog.Exception.ErrorSavingData.Message", (String[])new String[]{"kettle.properties", this.getKettlePropertiesFilename()}), (Throwable)e3);
                }
            }
        }
        if (this.previousKettlePropertiesKeys != null) {
            for (String originalKey : this.previousKettlePropertiesKeys) {
                if (this.kettleProperties.containsKey(originalKey)) continue;
                EnvUtil.clearSystemProperty((String)originalKey);
            }
        }
        this.dispose();
    }
}

