/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core;

import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Transform;
import org.pentaho.di.core.SwtUniversalImage;

public class SwtUniversalImageBitmap
extends SwtUniversalImage {
    private final Image bitmap;

    public SwtUniversalImageBitmap(Image bitmap) {
        this.bitmap = bitmap;
    }

    @Override
    public synchronized void dispose() {
        super.dispose();
        if (!this.bitmap.isDisposed()) {
            this.bitmap.dispose();
        }
    }

    @Override
    protected Image renderSimple(Device device) {
        return this.bitmap;
    }

    @Override
    protected Image renderSimple(Device device, int width, int height) {
        ImageData imageData = this.bitmap.getImageData();
        ImageData scaledData = imageData.scaledTo(width, height);
        return new Image(device, scaledData);
    }

    @Override
    protected Image renderRotated(Device device, int width, int height, double angleRadians) {
        Image result = new Image(device, width * 2, height * 2);
        GC gc = new GC((Drawable)result);
        int bw = this.bitmap.getBounds().width;
        int bh = this.bitmap.getBounds().height;
        Transform affineTransform = new Transform(device);
        affineTransform.translate((float)width, (float)height);
        affineTransform.rotate((float)Math.toDegrees(angleRadians));
        affineTransform.scale(1.0f * (float)width / (float)bw, 1.0f * (float)height / (float)bh);
        gc.setTransform(affineTransform);
        gc.drawImage(this.bitmap, 0, 0, bw, bh, -bw / 2, -bh / 2, bw, bh);
        gc.dispose();
        return result;
    }
}

